/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.util;

import com.oracle.labs.mlrg.olcut.util.SubprocessConnectionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SubprocessConnection {
    private static final Logger logger = Logger.getLogger(SubprocessConnection.class.getName());
    public static final String SHUTDOWN = "SHUTDOWN";
    private static final String PYTHONUNBUFFERED = "PYTHONUNBUFFERED";
    private final String command;
    private Map<String, String> environment = new HashMap<String, String>();
    private long idleTimeoutMillis;
    private long readTimeoutMillis;
    private Process process = null;
    private final ReentrantLock processLock = new ReentrantLock();
    private Timer idlerTimer = null;
    private long lastIOTime;
    private final ArrayList<SubprocessConnectionListener> listeners = new ArrayList();

    public SubprocessConnection(String command) {
        this.command = command;
        this.environment.put(PYTHONUNBUFFERED, "True");
    }

    public SubprocessConnection(String command, boolean startImmediately) throws IOException {
        this(command, startImmediately, null);
    }

    public SubprocessConnection(String command, boolean startImmediately, Map<String, String> environment) throws IOException {
        if (environment != null) {
            this.environment = new HashMap<String, String>(environment);
        }
        this.command = command;
        if (startImmediately) {
            this.ensureRunning();
        }
        if (!this.environment.containsKey(PYTHONUNBUFFERED)) {
            this.environment.put(PYTHONUNBUFFERED, "True");
        }
    }

    public void addSubprocessListener(SubprocessConnectionListener l) {
        if (l != null) {
            this.listeners.add(l);
        }
    }

    public void removeSubprocessListener(SubprocessConnectionListener l) {
        if (l != null) {
            this.listeners.remove(l);
        }
    }

    public String getCommand() {
        return this.command;
    }

    public void setIdleTimeout(int time, TimeUnit unit) {
        if (time > 0 && unit != null) {
            this.idleTimeoutMillis = unit.toMillis(time);
        }
    }

    public void setReadTimeout(int time, TimeUnit unit) {
        if (time > 0 && unit != null) {
            this.readTimeoutMillis = unit.toMillis(time);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectOutputWithTimeout(Consumer<String> func) throws TimeoutException {
        block8: {
            BufferedReader stdout = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
            Timer readTimeoutTimer = null;
            if (this.readTimeoutMillis > 0L) {
                readTimeoutTimer = new Timer("SubprocessReaper", true);
                readTimeoutTimer.schedule((TimerTask)new SubprocessReaper(this.process), this.readTimeoutMillis);
            }
            String line = null;
            try {
                while ((line = stdout.readLine()) != null && !line.trim().isEmpty()) {
                    logger.finer("RECEIVED::" + line);
                    func.accept(line);
                    this.lastIOTime = System.currentTimeMillis();
                    if (readTimeoutTimer == null) continue;
                    readTimeoutTimer.cancel();
                    readTimeoutTimer = new Timer("SubprocessReaper", true);
                    readTimeoutTimer.schedule((TimerTask)new SubprocessReaper(this.process), this.readTimeoutMillis);
                }
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Error reading from subprocess stdout", e);
                line = null;
            }
            finally {
                if (readTimeoutTimer != null) {
                    readTimeoutTimer.cancel();
                }
                if (line != null) break block8;
                logger.fine("Read a null line - EOF reached, shutting down engine");
                this.shutdown(false);
                throw new TimeoutException("Reading interrupted because stream was closed (read timed out?)");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String run(String command) throws IOException, TimeoutException {
        StringBuilder results = new StringBuilder();
        try {
            this.processLock.lock();
            this.ensureRunning();
            PrintWriter stdin = new PrintWriter(this.process.getOutputStream());
            logger.finer("SENT::" + command);
            stdin.println(command);
            stdin.flush();
            this.collectOutputWithTimeout(line -> results.append((String)line).append("\n"));
        }
        finally {
            this.processLock.unlock();
        }
        return results.toString();
    }

    private static long transferTo(InputStream is, OutputStream os) throws IOException {
        int read;
        long transferred = 0L;
        byte[] buffer = new byte[8192];
        while ((read = is.read(buffer, 0, 8192)) >= 0) {
            os.write(buffer, 0, read);
            transferred += (long)read;
        }
        return transferred;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<String> run(InputStream is) throws IOException, TimeoutException {
        ArrayList<String> results = new ArrayList<String>();
        try {
            this.processLock.lock();
            this.ensureRunning();
            long transferred = SubprocessConnection.transferTo(is, this.process.getOutputStream());
            logger.fine("Transferred " + transferred + " bytes");
            this.collectOutputWithTimeout(line -> results.add((String)line));
        }
        finally {
            this.processLock.unlock();
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureRunning() throws IOException {
        try {
            this.processLock.lock();
            if (this.process == null || !this.process.isAlive()) {
                String line;
                ProcessBuilder pb = new ProcessBuilder(this.command.split("\\s+"));
                logger.info("Running subprocess " + Arrays.toString(this.command.split("\\s+")));
                pb.redirectError(ProcessBuilder.Redirect.INHERIT);
                pb.environment().putAll(this.environment);
                this.process = pb.start();
                BufferedReader stdout = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
                while ((line = stdout.readLine()) != null) {
                    logger.fine("RECEIVED::" + line);
                    if (!line.toLowerCase(Locale.ROOT).equals("ready")) continue;
                    logger.info("Subprocess is ready");
                    break;
                }
                this.lastIOTime = System.currentTimeMillis();
                this.listeners.forEach(l -> l.subprocessStarted(this));
            }
            if (this.idleTimeoutMillis != 0L && this.idlerTimer == null) {
                this.idlerTimer = new Timer("SubProcessIdler", true);
                this.idlerTimer.schedule((TimerTask)new Idler(), 30000L, 30000L);
            }
        }
        finally {
            this.processLock.unlock();
        }
    }

    public void shutdown() {
        this.shutdown(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean graceful) {
        try {
            this.processLock.lock();
            if (this.process != null && this.process.isAlive()) {
                this.listeners.forEach(l -> l.subprocessPreShutdown(this));
                try {
                    if (graceful) {
                        PrintWriter stdin = new PrintWriter(this.process.getOutputStream());
                        stdin.println(SHUTDOWN);
                        stdin.flush();
                        if (!this.process.waitFor(5L, TimeUnit.SECONDS)) {
                            this.process.destroyForcibly();
                        }
                    } else {
                        this.process.destroyForcibly();
                    }
                }
                catch (InterruptedException e) {
                    logger.log(Level.WARNING, "Shutdown interrupted", e);
                    this.process.destroyForcibly();
                }
                finally {
                    this.process = null;
                }
            }
            this.listeners.forEach(l -> l.subprocessPostShutdown(this));
            if (this.idlerTimer != null) {
                this.idlerTimer.cancel();
                this.idlerTimer = null;
            }
        }
        finally {
            this.processLock.unlock();
        }
    }

    protected class SubprocessReaper
    extends TimerTask {
        protected final Process proc;

        public SubprocessReaper(Process proc) {
            this.proc = proc;
        }

        @Override
        public void run() {
            SubprocessConnection.this.listeners.forEach(l -> l.subprocessPreShutdown(SubprocessConnection.this));
            logger.fine("Killing subprocess");
            try {
                this.proc.destroyForcibly();
                SubprocessConnection.this.processLock.lock();
                this.proc.waitFor();
            }
            catch (InterruptedException e) {
                logger.log(Level.WARNING, "Waiting for subprocess destruction interrupted", e);
            }
            finally {
                SubprocessConnection.this.processLock.unlock();
            }
            SubprocessConnection.this.shutdown(false);
            logger.fine("Subprocess destroy");
        }
    }

    public class Idler
    extends TimerTask {
        @Override
        public void run() {
            try {
                long currTime;
                SubprocessConnection.this.processLock.lock();
                if (SubprocessConnection.this.process != null && SubprocessConnection.this.process.isAlive() && (currTime = System.currentTimeMillis()) - SubprocessConnection.this.lastIOTime > SubprocessConnection.this.idleTimeoutMillis) {
                    logger.info("Shutting down subprocess due to idle timeout.");
                    SubprocessConnection.this.shutdown();
                }
            }
            finally {
                SubprocessConnection.this.processLock.unlock();
            }
        }
    }
}

