/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.notifications;

import io.skylite.core.notifications.NotificationCore;
import io.skylite.core.notifications.model.DestinationMessageResponse;
import io.skylite.core.notifications.model.MessageContent;
import io.skylite.core.notifications.model.destination.BaseDestination;
import io.skylite.notifications.setting.PluginSettings;
import io.skylite.notifications.transport.DestinationTransport;
import io.skylite.notifications.transport.DestinationTransportProvider;
import java.security.AccessController;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class NotificationCoreImpl
implements NotificationCore {
    public static final String LOG_PREFIX = "notifications-core";
    public static final String PLUGIN_NAME = "skylite-notifications-core";
    public static final NotificationCoreImpl INSTANCE = new NotificationCoreImpl();

    private NotificationCoreImpl() {
    }

    public DestinationMessageResponse sendMessage(BaseDestination destination, MessageContent message, String referenceId) {
        return AccessController.doPrivileged(() -> {
            DestinationTransport<BaseDestination> destinationFactory = DestinationTransportProvider.getTransport(destination.getDestinationType());
            return destinationFactory.sendMessage(destination, message, referenceId);
        });
    }

    public List<String> getAllowedConfigTypes() {
        return AccessController.doPrivileged(PluginSettings::getAllowedConfigTypes);
    }

    public Map<String, String> getPluginFeatures() {
        return AccessController.doPrivileged(() -> Collections.singletonMap("tooltip_support", String.valueOf(PluginSettings.isTooltipSupport())));
    }
}

