/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.notifications.client;

import io.skylite.core.notifications.model.MessageContent;
import io.skylite.core.notifications.model.destination.ChimeDestination;
import io.skylite.core.notifications.model.destination.CustomWebhookDestination;
import io.skylite.core.notifications.model.destination.MicrosoftTeamsDestination;
import io.skylite.core.notifications.model.destination.SlackDestination;
import io.skylite.core.notifications.model.destination.WebhookDestination;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.notifications.setting.PluginSettings;
import io.skylite.notifications.utils.Helpers;
import io.skylite.notifications.utils.ValidationHelpers;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hc.client5.http.HttpRequestRetryStrategy;
import org.apache.hc.client5.http.classic.methods.HttpPatch;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.DefaultHttpRequestRetryStrategy;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.util.Timeout;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DestinationHttpClient {
    private static final Logger log = LogManager.getLogger(DestinationHttpClient.class);
    private static final Set<Integer> VALID_RESPONSE_STATUS = Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(RestStatus.OK.getStatus(), RestStatus.CREATED.getStatus(), RestStatus.ACCEPTED.getStatus(), RestStatus.NON_AUTHORITATIVE_INFORMATION.getStatus(), RestStatus.NO_CONTENT.getStatus(), RestStatus.RESET_CONTENT.getStatus(), RestStatus.PARTIAL_CONTENT.getStatus(), RestStatus.MULTI_STATUS.getStatus())));
    private final CloseableHttpClient httpClient;

    public DestinationHttpClient() {
        this.httpClient = DestinationHttpClient.createHttpClient();
    }

    public DestinationHttpClient(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    private static CloseableHttpClient createHttpClient() {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(Timeout.ofMilliseconds((long)PluginSettings.getConnectionTimeout())).setConnectionRequestTimeout(Timeout.ofMilliseconds((long)PluginSettings.getConnectionTimeout())).setResponseTimeout(Timeout.ofMilliseconds((long)PluginSettings.getSocketTimeout())).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setMaxTotal(PluginSettings.getMaxConnections());
        connectionManager.setDefaultMaxPerRoute(PluginSettings.getMaxConnectionsPerRoute());
        return HttpClientBuilder.create().setDefaultRequestConfig(config).setConnectionManager((HttpClientConnectionManager)connectionManager).setRetryStrategy((HttpRequestRetryStrategy)new DefaultHttpRequestRetryStrategy()).useSystemProperties().disableRedirectHandling().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute(WebhookDestination destination, MessageContent message, String referenceId) throws Exception {
        CloseableHttpResponse response = null;
        try {
            ValidationHelpers.validateUrlHost(destination.getUrl(), PluginSettings.getHostDenyList());
            response = this.getHttpResponse(destination, message);
            this.validateResponseStatus((HttpResponse)response);
            String responseString = this.getResponseString(response);
            log.debug("Http response for id {}: {}", (Object)referenceId, (Object)responseString);
            String string = responseString;
            return string;
        }
        finally {
            if (response != null) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
        }
    }

    private CloseableHttpResponse getHttpResponse(WebhookDestination destination, MessageContent message) throws Exception {
        HttpPost httpRequest = new HttpPost(destination.getUrl());
        if (destination instanceof CustomWebhookDestination) {
            CustomWebhookDestination customDest = (CustomWebhookDestination)destination;
            httpRequest = this.constructHttpRequest(customDest.getMethod(), destination.getUrl());
            Map headerParams = customDest.getHeaderParams();
            if (headerParams == null || headerParams.isEmpty()) {
                httpRequest.setHeader("Content-type", (Object)"application/json");
            } else {
                for (Map.Entry entry : headerParams.entrySet()) {
                    httpRequest.setHeader((String)entry.getKey(), entry.getValue());
                }
            }
        }
        StringEntity entity = new StringEntity(this.buildRequestBody(destination, message), StandardCharsets.UTF_8);
        httpRequest.setEntity((HttpEntity)entity);
        return this.httpClient.execute((ClassicHttpRequest)httpRequest);
    }

    private HttpUriRequestBase constructHttpRequest(String method, String url) {
        switch (method) {
            case "POST": {
                return new HttpPost(url);
            }
            case "PUT": {
                return new HttpPut(url);
            }
            case "PATCH": {
                return new HttpPatch(url);
            }
        }
        throw new IllegalArgumentException("Invalid or empty method supplied. Only POST, PUT and PATCH are allowed");
    }

    public String getResponseString(CloseableHttpResponse response) throws IOException, ParseException {
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            return "{}";
        }
        String responseString = EntityUtils.toString((HttpEntity)entity, (int)(PluginSettings.getMaxHttpResponseSize() / 2));
        return responseString == null || responseString.isEmpty() ? "{}" : responseString;
    }

    private void validateResponseStatus(HttpResponse response) throws IOException {
        int statusCode = response.getCode();
        if (!VALID_RESPONSE_STATUS.contains(statusCode)) {
            throw new IOException("Failed: " + response.getReasonPhrase());
        }
    }

    public String buildRequestBody(WebhookDestination destination, MessageContent message) throws IOException {
        String keyName;
        XContentBuilder builder = MediaTypeRegistry.JSON.contentBuilder();
        if (destination instanceof SlackDestination) {
            keyName = "text";
        } else if (destination instanceof ChimeDestination) {
            keyName = "Content";
        } else if (destination instanceof MicrosoftTeamsDestination) {
            keyName = "text";
        } else {
            if (destination instanceof CustomWebhookDestination) {
                return message.getTextDescription();
            }
            throw new IllegalArgumentException("Invalid destination type is provided, Only Slack, Chime, Microsoft Teams and CustomWebhook are allowed");
        }
        builder.startObject().field(keyName, message.buildMessageWithTitle()).endObject();
        return Helpers.string(builder);
    }
}

