/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.notifications.client;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.SdkBaseException;
import com.amazonaws.services.simpleemail.AmazonSimpleEmailService;
import com.amazonaws.services.simpleemail.model.AccountSendingPausedException;
import com.amazonaws.services.simpleemail.model.AmazonSimpleEmailServiceException;
import com.amazonaws.services.simpleemail.model.ConfigurationSetDoesNotExistException;
import com.amazonaws.services.simpleemail.model.ConfigurationSetSendingPausedException;
import com.amazonaws.services.simpleemail.model.MailFromDomainNotVerifiedException;
import com.amazonaws.services.simpleemail.model.MessageRejectedException;
import com.amazonaws.services.simpleemail.model.RawMessage;
import com.amazonaws.services.simpleemail.model.SendRawEmailRequest;
import com.amazonaws.services.simpleemail.model.SendRawEmailResult;
import io.skylite.core.notifications.model.DestinationMessageResponse;
import io.skylite.core.notifications.model.MessageContent;
import io.skylite.core.notifications.model.destination.SesDestination;
import io.skylite.core.rest.RestStatus;
import io.skylite.notifications.client.EmailMessageValidator;
import io.skylite.notifications.client.EmailMimeProvider;
import io.skylite.notifications.credentials.SesClientFactory;
import io.skylite.notifications.setting.PluginSettings;
import io.skylite.notifications.utils.SecurityAccess;
import jakarta.mail.Session;
import jakarta.mail.internet.MimeMessage;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DestinationSesClient {
    private static final Logger log = LogManager.getLogger(DestinationSesClient.class);
    private final SesClientFactory sesClientFactory;

    public DestinationSesClient(SesClientFactory sesClientFactory) {
        this.sesClientFactory = sesClientFactory;
    }

    private Session prepareSession() {
        Properties prop = new Properties();
        prop.put("mail.transport.protocol", "smtp");
        return Session.getInstance((Properties)prop);
    }

    public DestinationMessageResponse execute(SesDestination sesDestination, MessageContent message, String referenceId) throws Exception {
        if (EmailMessageValidator.isMessageSizeOverLimit(message)) {
            return new DestinationMessageResponse(RestStatus.REQUEST_ENTITY_TOO_LARGE.getStatus(), "Email size larger than " + PluginSettings.getEmailSizeLimit());
        }
        Session session = this.prepareSession();
        MimeMessage mimeMessage = EmailMimeProvider.prepareMimeMessage(session, sesDestination.getFromAddress(), sesDestination.getRecipient(), message);
        return this.sendMimeMessage(referenceId, sesDestination.getAwsRegion(), sesDestination.getRoleArn(), mimeMessage);
    }

    private DestinationMessageResponse sendMimeMessage(String referenceId, String sesAwsRegion, String roleArn, MimeMessage mimeMessage) {
        try {
            log.debug("{}:Sending Email-SES:{}", (Object)"notifications-core", (Object)referenceId);
            AmazonSimpleEmailService client = this.sesClientFactory.createSesClient(sesAwsRegion, roleArn);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            SecurityAccess.doPrivileged(() -> {
                mimeMessage.writeTo((OutputStream)outputStream);
                return null;
            });
            int emailSize = outputStream.size();
            if (emailSize <= PluginSettings.getEmailSizeLimit()) {
                RawMessage rawMessage = new RawMessage(ByteBuffer.wrap(outputStream.toByteArray()));
                SendRawEmailRequest rawEmailRequest = new SendRawEmailRequest(rawMessage);
                SendRawEmailResult response = SecurityAccess.doPrivileged(() -> client.sendRawEmail(rawEmailRequest));
                log.info("{}:Email-SES:{} status:{}", (Object)"notifications-core", (Object)referenceId, (Object)response);
                return new DestinationMessageResponse(RestStatus.OK.getStatus(), "Success:" + response.getMessageId());
            }
            return new DestinationMessageResponse(RestStatus.REQUEST_ENTITY_TOO_LARGE.getStatus(), "Email size(" + emailSize + ") larger than " + PluginSettings.getEmailSizeLimit());
        }
        catch (MessageRejectedException exception) {
            return new DestinationMessageResponse(RestStatus.SERVICE_UNAVAILABLE.getStatus(), this.getSesExceptionText((AmazonSimpleEmailServiceException)((Object)exception)));
        }
        catch (MailFromDomainNotVerifiedException exception) {
            return new DestinationMessageResponse(RestStatus.FORBIDDEN.getStatus(), this.getSesExceptionText((AmazonSimpleEmailServiceException)((Object)exception)));
        }
        catch (ConfigurationSetDoesNotExistException exception) {
            return new DestinationMessageResponse(RestStatus.NOT_IMPLEMENTED.getStatus(), this.getSesExceptionText((AmazonSimpleEmailServiceException)((Object)exception)));
        }
        catch (ConfigurationSetSendingPausedException exception) {
            return new DestinationMessageResponse(RestStatus.SERVICE_UNAVAILABLE.getStatus(), this.getSesExceptionText((AmazonSimpleEmailServiceException)((Object)exception)));
        }
        catch (AccountSendingPausedException exception) {
            return new DestinationMessageResponse(RestStatus.INSUFFICIENT_STORAGE.getStatus(), this.getSesExceptionText((AmazonSimpleEmailServiceException)((Object)exception)));
        }
        catch (AmazonSimpleEmailServiceException exception) {
            return new DestinationMessageResponse(RestStatus.FAILED_DEPENDENCY.getStatus(), this.getSesExceptionText(exception));
        }
        catch (AmazonServiceException exception) {
            return new DestinationMessageResponse(RestStatus.FAILED_DEPENDENCY.getStatus(), this.getServiceExceptionText(exception));
        }
        catch (SdkBaseException exception) {
            return new DestinationMessageResponse(RestStatus.FAILED_DEPENDENCY.getStatus(), this.getSdkExceptionText(exception));
        }
        catch (Exception exception) {
            return new DestinationMessageResponse(RestStatus.INTERNAL_SERVER_ERROR.getStatus(), "Error: " + exception.getMessage());
        }
    }

    private String getSesExceptionText(AmazonSimpleEmailServiceException exception) {
        log.info("{}:SesException {}", (Object)"notifications-core", (Object)exception.toString());
        return "sendEmail Error, SES status:" + exception.getErrorMessage();
    }

    private String getServiceExceptionText(AmazonServiceException exception) {
        log.info("{}:SesException {}", (Object)"notifications-core", (Object)exception.toString());
        return "sendEmail Error(" + exception.getStatusCode() + "), SES status:(" + exception.getErrorType().name() + ")" + exception.getErrorCode() + ":" + exception.getErrorMessage();
    }

    private String getSdkExceptionText(SdkBaseException exception) {
        log.info("{}:SdkException {}", (Object)"notifications-core", (Object)exception.toString());
        return "sendEmail Error, SDK status:" + exception.getMessage();
    }
}

