/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.notifications.client;

import io.skylite.common.SecureString;
import io.skylite.core.notifications.model.DestinationMessageResponse;
import io.skylite.core.notifications.model.MessageContent;
import io.skylite.core.notifications.model.SecureDestinationSettings;
import io.skylite.core.notifications.model.destination.SmtpDestination;
import io.skylite.core.rest.RestStatus;
import io.skylite.notifications.client.EmailMessageValidator;
import io.skylite.notifications.client.EmailMimeProvider;
import io.skylite.notifications.setting.PluginSettings;
import io.skylite.notifications.utils.SecurityAccess;
import jakarta.mail.Authenticator;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.SendFailedException;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.MimeMessage;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.angus.mail.util.MailConnectException;

public class DestinationSmtpClient {
    private static final Logger log = LogManager.getLogger(DestinationSmtpClient.class);

    public DestinationMessageResponse execute(SmtpDestination smtpDestination, MessageContent message, String referenceId) throws Exception {
        SecureDestinationSettings secureDestinationSetting;
        if (EmailMessageValidator.isMessageSizeOverLimit(message)) {
            return new DestinationMessageResponse(RestStatus.REQUEST_ENTITY_TOO_LARGE.getStatus(), "Email size larger than " + PluginSettings.getEmailSizeLimit());
        }
        Properties prop = new Properties();
        prop.put("mail.transport.protocol", "smtp");
        prop.put("mail.smtp.host", smtpDestination.getHost());
        prop.put("mail.smtp.port", (Object)smtpDestination.getPort());
        Session session = Session.getInstance((Properties)prop);
        switch (smtpDestination.getMethod()) {
            case "ssl": {
                prop.put("mail.smtp.ssl.enable", (Object)true);
                break;
            }
            case "start_tls": {
                prop.put("mail.smtp.starttls.enable", (Object)true);
                break;
            }
            case "none": {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid method supplied");
            }
        }
        if (!"none".equals(smtpDestination.getMethod()) && (secureDestinationSetting = this.getSecureDestinationSetting(smtpDestination)) != null) {
            prop.put("mail.smtp.auth", (Object)true);
            session = Session.getInstance((Properties)prop, (Authenticator)new Authenticator(this){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(secureDestinationSetting.getEmailUsername().toString(), secureDestinationSetting.getEmailPassword().toString());
                }
            });
        }
        MimeMessage mimeMessage = EmailMimeProvider.prepareMimeMessage(session, smtpDestination.getFromAddress(), smtpDestination.getRecipient(), message);
        return this.sendMimeMessage(mimeMessage, referenceId);
    }

    public SecureDestinationSettings getSecureDestinationSetting(SmtpDestination smtpDestination) {
        Map<String, SecureDestinationSettings> settings = PluginSettings.getDestinationSettings();
        if (settings == null) {
            return null;
        }
        SecureDestinationSettings destinationSetting = settings.get(smtpDestination.getAccountName());
        if (destinationSetting == null) {
            return null;
        }
        SecureString emailUsername = destinationSetting.getEmailUsername();
        SecureString emailPassword = destinationSetting.getEmailPassword();
        if (emailUsername == null || emailPassword == null) {
            return null;
        }
        return new SecureDestinationSettings(emailUsername, emailPassword);
    }

    private DestinationMessageResponse sendMimeMessage(MimeMessage mimeMessage, String referenceId) {
        try {
            log.debug("Sending Email-SMTP for {}", (Object)referenceId);
            SecurityAccess.doPrivileged(() -> {
                this.sendMessage((Message)mimeMessage);
                return null;
            });
            log.info("Email-SMTP sent for {}", (Object)referenceId);
            return new DestinationMessageResponse(RestStatus.OK.getStatus(), "Success");
        }
        catch (SendFailedException exception) {
            return new DestinationMessageResponse(RestStatus.BAD_GATEWAY.getStatus(), this.getMessagingExceptionText((MessagingException)((Object)exception)));
        }
        catch (MailConnectException exception) {
            return new DestinationMessageResponse(RestStatus.SERVICE_UNAVAILABLE.getStatus(), this.getMessagingExceptionText((MessagingException)((Object)exception)));
        }
        catch (MessagingException exception) {
            return new DestinationMessageResponse(RestStatus.FAILED_DEPENDENCY.getStatus(), this.getMessagingExceptionText(exception));
        }
        catch (Exception exception) {
            return new DestinationMessageResponse(RestStatus.INTERNAL_SERVER_ERROR.getStatus(), "Error: " + exception.getMessage());
        }
    }

    public void sendMessage(Message msg) throws Exception {
        Transport.send((Message)msg);
    }

    private String getMessagingExceptionText(MessagingException exception) {
        log.info("EmailException {}", (Object)exception.toString());
        return "sendEmail Error, status:" + exception.getMessage();
    }
}

