/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.notifications.client;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.SdkBaseException;
import com.amazonaws.services.sns.AmazonSNS;
import com.amazonaws.services.sns.model.AmazonSNSException;
import com.amazonaws.services.sns.model.AuthorizationErrorException;
import com.amazonaws.services.sns.model.EndpointDisabledException;
import com.amazonaws.services.sns.model.InternalErrorException;
import com.amazonaws.services.sns.model.InvalidParameterException;
import com.amazonaws.services.sns.model.InvalidParameterValueException;
import com.amazonaws.services.sns.model.InvalidSecurityException;
import com.amazonaws.services.sns.model.KMSAccessDeniedException;
import com.amazonaws.services.sns.model.KMSDisabledException;
import com.amazonaws.services.sns.model.KMSInvalidStateException;
import com.amazonaws.services.sns.model.KMSNotFoundException;
import com.amazonaws.services.sns.model.KMSOptInRequiredException;
import com.amazonaws.services.sns.model.KMSThrottlingException;
import com.amazonaws.services.sns.model.NotFoundException;
import com.amazonaws.services.sns.model.PlatformApplicationDisabledException;
import com.amazonaws.services.sns.model.PublishRequest;
import com.amazonaws.services.sns.model.PublishResult;
import io.skylite.core.notifications.model.DestinationMessageResponse;
import io.skylite.core.notifications.model.MessageContent;
import io.skylite.core.notifications.model.destination.SnsDestination;
import io.skylite.core.rest.RestStatus;
import io.skylite.notifications.credentials.SnsClientFactory;
import io.skylite.notifications.setting.PluginSettings;
import java.io.IOException;
import java.util.Locale;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DestinationSnsClient {
    private static final Logger log = LogManager.getLogger(DestinationSnsClient.class);
    private final SnsClientFactory snsClientFactory;

    public DestinationSnsClient(SnsClientFactory snsClientFactory) {
        this.snsClientFactory = snsClientFactory;
    }

    public DestinationMessageResponse execute(SnsDestination destination, MessageContent message, String referenceId) throws IOException {
        AmazonSNS amazonSNS = this.snsClientFactory.createSnsClient(destination.getRegion(), destination.getRoleArn());
        try {
            PublishResult result = this.sendMessage(amazonSNS, destination, message);
            return new DestinationMessageResponse(RestStatus.OK.getStatus(), "Success, message id: " + result.getMessageId());
        }
        catch (InvalidParameterException exception) {
            return new DestinationMessageResponse(RestStatus.BAD_REQUEST.getStatus(), this.getSnsExceptionText((AmazonSNSException)((Object)exception)));
        }
        catch (InvalidParameterValueException exception) {
            return new DestinationMessageResponse(RestStatus.BAD_REQUEST.getStatus(), this.getSnsExceptionText((AmazonSNSException)((Object)exception)));
        }
        catch (InternalErrorException exception) {
            return new DestinationMessageResponse(RestStatus.INTERNAL_SERVER_ERROR.getStatus(), this.getSnsExceptionText((AmazonSNSException)((Object)exception)));
        }
        catch (NotFoundException exception) {
            return new DestinationMessageResponse(RestStatus.NOT_FOUND.getStatus(), this.getSnsExceptionText((AmazonSNSException)((Object)exception)));
        }
        catch (EndpointDisabledException exception) {
            return new DestinationMessageResponse(RestStatus.LOCKED.getStatus(), this.getSnsExceptionText((AmazonSNSException)((Object)exception)));
        }
        catch (PlatformApplicationDisabledException exception) {
            return new DestinationMessageResponse(RestStatus.SERVICE_UNAVAILABLE.getStatus(), this.getSnsExceptionText((AmazonSNSException)((Object)exception)));
        }
        catch (AuthorizationErrorException exception) {
            return new DestinationMessageResponse(RestStatus.UNAUTHORIZED.getStatus(), this.getSnsExceptionText((AmazonSNSException)((Object)exception)));
        }
        catch (KMSDisabledException exception) {
            return new DestinationMessageResponse(RestStatus.PRECONDITION_FAILED.getStatus(), this.getSnsExceptionText((AmazonSNSException)((Object)exception)));
        }
        catch (KMSInvalidStateException exception) {
            return new DestinationMessageResponse(RestStatus.PRECONDITION_FAILED.getStatus(), this.getSnsExceptionText((AmazonSNSException)((Object)exception)));
        }
        catch (KMSNotFoundException exception) {
            return new DestinationMessageResponse(RestStatus.PRECONDITION_FAILED.getStatus(), this.getSnsExceptionText((AmazonSNSException)((Object)exception)));
        }
        catch (KMSOptInRequiredException exception) {
            return new DestinationMessageResponse(RestStatus.PRECONDITION_FAILED.getStatus(), this.getSnsExceptionText((AmazonSNSException)((Object)exception)));
        }
        catch (KMSThrottlingException exception) {
            return new DestinationMessageResponse(RestStatus.TOO_MANY_REQUESTS.getStatus(), this.getSnsExceptionText((AmazonSNSException)((Object)exception)));
        }
        catch (KMSAccessDeniedException exception) {
            return new DestinationMessageResponse(RestStatus.UNAUTHORIZED.getStatus(), this.getSnsExceptionText((AmazonSNSException)((Object)exception)));
        }
        catch (InvalidSecurityException exception) {
            return new DestinationMessageResponse(RestStatus.UNAUTHORIZED.getStatus(), this.getSnsExceptionText((AmazonSNSException)((Object)exception)));
        }
        catch (AmazonSNSException exception) {
            return new DestinationMessageResponse(RestStatus.FAILED_DEPENDENCY.getStatus(), this.getSnsExceptionText(exception));
        }
        catch (AmazonServiceException exception) {
            return new DestinationMessageResponse(RestStatus.FAILED_DEPENDENCY.getStatus(), this.getServiceExceptionText(exception));
        }
        catch (SdkBaseException exception) {
            return new DestinationMessageResponse(RestStatus.FAILED_DEPENDENCY.getStatus(), this.getSdkExceptionText(exception));
        }
    }

    private String getSnsExceptionText(AmazonSNSException exception) {
        log.info("{}:SnsException {}", (Object)"notifications-core", (Object)exception.toString());
        return "SNS Send Error(" + exception.getStatusCode() + "), SNS status:(" + exception.getErrorType().name() + ")" + exception.getErrorCode() + ":" + exception.getErrorMessage();
    }

    private String getServiceExceptionText(AmazonServiceException exception) {
        log.info("{}:SnsException {}", (Object)"notifications-core", (Object)exception.toString());
        return "SNS service Error(" + exception.getStatusCode() + "), Service status:(" + exception.getErrorType().name() + ")" + exception.getErrorCode() + ":" + exception.getErrorMessage();
    }

    private String getSdkExceptionText(SdkBaseException exception) {
        log.info("{}:SdkException {}", (Object)"notifications-core", (Object)exception.toString());
        return "SNS sdk Error, SDK status:" + exception.getMessage();
    }

    public PublishResult sendMessage(AmazonSNS amazonSNS, SnsDestination destination, MessageContent message) {
        PublishRequest request = new PublishRequest().withTopicArn(destination.getTopicArn()).withMessage(message.getTextDescription()).withSubject(message.getTitle());
        if (destination.getTopicArn().endsWith(".fifo")) {
            request.withMessageDeduplicationId(UUID.randomUUID().toString()).withMessageGroupId(String.format(Locale.ROOT, "lucenia-%s", PluginSettings.getClusterName()));
        }
        return amazonSNS.publish(request);
    }
}

