/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.notifications.client;

import io.skylite.core.notifications.model.MessageContent;
import io.skylite.notifications.setting.PluginSettings;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class EmailMessageValidator {
    private static final Logger log = LogManager.getLogger(EmailMessageValidator.class);

    private EmailMessageValidator() {
    }

    public static boolean isMessageSizeOverLimit(MessageContent message) {
        int approxAttachmentLength = 0;
        if (message.getFileData() != null && message.getFileName() != null) {
            approxAttachmentLength = PluginSettings.getEmailMinimumHeaderLength() + message.getFileData().length() + message.getFileName().length();
        }
        int approxEmailLength = PluginSettings.getEmailMinimumHeaderLength() + message.getTitle().length() + message.getTextDescription().length() + (message.getHtmlDescription() != null ? message.getHtmlDescription().length() : 0) + approxAttachmentLength;
        return approxEmailLength > PluginSettings.getEmailSizeLimit();
    }
}

