/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.notifications.client;

import io.skylite.core.notifications.model.MessageContent;
import jakarta.activation.CommandMap;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.activation.MailcapCommandMap;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Session;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.util.ByteArrayDataSource;
import java.util.Base64;

public final class EmailMimeProvider {
    private EmailMimeProvider() {
    }

    public static MimeMessage prepareMimeMessage(Session session, String fromAddress, String recipient, MessageContent messageContent) throws MessagingException {
        MailcapCommandMap mc = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
        mc.addMailcap("text/html;; x-java-content-handler=org.eclipse.angus.mail.handlers.text_html");
        mc.addMailcap("text/xml;; x-java-content-handler=org.eclipse.angus.mail.handlers.text_xml");
        mc.addMailcap("text/plain;; x-java-content-handler=org.eclipse.angus.mail.handlers.text_plain");
        mc.addMailcap("multipart/*;; x-java-content-handler=org.eclipse.angus.mail.handlers.multipart_mixed");
        mc.addMailcap("message/rfc822;; x-java-content-handler=org.eclipse.angus.mail.handlers.message_rfc822");
        MimeMessage mimeMessage = new MimeMessage(session);
        mimeMessage.setFrom(fromAddress);
        mimeMessage.setRecipients(Message.RecipientType.TO, recipient);
        mimeMessage.setSubject(messageContent.getTitle(), "UTF-8");
        MimeMultipart msgBody = new MimeMultipart("alternative");
        MimeBodyPart bodyWrapper = new MimeBodyPart();
        MimeBodyPart textPart = new MimeBodyPart();
        textPart.setContent((Object)messageContent.getTextDescription(), "text/plain; charset=UTF-8");
        msgBody.addBodyPart((BodyPart)textPart);
        if (messageContent.getHtmlDescription() != null) {
            MimeBodyPart htmlPart = new MimeBodyPart();
            htmlPart.setContent((Object)messageContent.getHtmlDescription(), "text/html; charset=UTF-8");
            msgBody.addBodyPart((BodyPart)htmlPart);
        }
        bodyWrapper.setContent((Multipart)msgBody);
        MimeMultipart msg = new MimeMultipart("mixed");
        mimeMessage.setContent((Multipart)msg);
        msg.addBodyPart((BodyPart)bodyWrapper);
        if (messageContent.getFileName() != null && messageContent.getFileData() != null && messageContent.getFileContentType() != null && messageContent.getFileEncoding() != null) {
            MimeBodyPart attachmentMime = null;
            if ("text".equals(messageContent.getFileEncoding())) {
                attachmentMime = EmailMimeProvider.createTextAttachmentPart(messageContent);
            } else if ("base64".equals(messageContent.getFileEncoding())) {
                attachmentMime = EmailMimeProvider.createBinaryAttachmentPart(messageContent);
            }
            if (attachmentMime != null) {
                msg.addBodyPart((BodyPart)attachmentMime);
            }
        }
        return mimeMessage;
    }

    private static MimeBodyPart createBinaryAttachmentPart(MessageContent messageContent) throws MessagingException {
        MimeBodyPart attachmentMime = new MimeBodyPart();
        ByteArrayDataSource fds = new ByteArrayDataSource(Base64.getMimeDecoder().decode(messageContent.getFileData()), messageContent.getFileContentType() != null ? messageContent.getFileContentType() : "application/octet-stream");
        attachmentMime.setDataHandler(new DataHandler((DataSource)fds));
        attachmentMime.setFileName(messageContent.getFileName());
        return attachmentMime;
    }

    private static MimeBodyPart createTextAttachmentPart(MessageContent messageContent) throws MessagingException {
        int lastSlash;
        MimeBodyPart attachmentMime = new MimeBodyPart();
        String subContentType = "plain";
        if (messageContent.getFileContentType() != null && (lastSlash = messageContent.getFileContentType().lastIndexOf(47)) >= 0) {
            subContentType = messageContent.getFileContentType().substring(lastSlash + 1);
        }
        attachmentMime.setText(messageContent.getFileData(), "UTF-8", subContentType);
        attachmentMime.setFileName(messageContent.getFileName());
        return attachmentMime;
    }
}

