/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.notifications.credentials.oss;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.amazonaws.services.securitytoken.model.AssumeRoleRequest;
import com.amazonaws.services.securitytoken.model.AssumeRoleResult;
import com.amazonaws.services.securitytoken.model.Credentials;
import io.skylite.notifications.credentials.CredentialsProvider;

public class CredentialsProviderFactory
implements CredentialsProvider {
    @Override
    public AWSCredentialsProvider getCredentialsProvider(String region, String roleArn) {
        if (roleArn != null) {
            return this.getCredentialsProviderByIAMRole(region, roleArn);
        }
        return DefaultAWSCredentialsProviderChain.getInstance();
    }

    private AWSCredentialsProvider getCredentialsProviderByIAMRole(String region, String roleArn) {
        AWSSecurityTokenService stsClient = (AWSSecurityTokenService)((AWSSecurityTokenServiceClientBuilder)((AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClientBuilder.standard().withCredentials((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance())).withRegion(region)).build();
        AssumeRoleRequest roleRequest = new AssumeRoleRequest().withRoleArn(roleArn).withRoleSessionName("lucenia-notifications");
        AssumeRoleResult roleResponse = stsClient.assumeRole(roleRequest);
        Credentials sessionCredentials = roleResponse.getCredentials();
        BasicSessionCredentials awsCredentials = new BasicSessionCredentials(sessionCredentials.getAccessKeyId(), sessionCredentials.getSecretAccessKey(), sessionCredentials.getSessionToken());
        return new AWSStaticCredentialsProvider((AWSCredentials)awsCredentials);
    }
}

