/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.notifications.credentials.oss;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.simpleemail.AmazonSimpleEmailService;
import com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClientBuilder;
import io.skylite.notifications.credentials.SesClientFactory;
import io.skylite.notifications.credentials.oss.CredentialsProviderFactory;
import io.skylite.notifications.utils.SecurityAccess;

public final class SesClientFactoryImpl
implements SesClientFactory {
    public static final SesClientFactoryImpl INSTANCE = new SesClientFactoryImpl();

    private SesClientFactoryImpl() {
    }

    @Override
    public AmazonSimpleEmailService createSesClient(String region, String roleArn) {
        try {
            return SecurityAccess.doPrivileged(() -> {
                AWSCredentialsProvider credentials = new CredentialsProviderFactory().getCredentialsProvider(region, roleArn);
                return (AmazonSimpleEmailService)((AmazonSimpleEmailServiceClientBuilder)((AmazonSimpleEmailServiceClientBuilder)AmazonSimpleEmailServiceClientBuilder.standard().withRegion(region)).withCredentials(credentials)).build();
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create SES client", e);
        }
    }
}

