/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.notifications.credentials.oss;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.sns.AmazonSNS;
import com.amazonaws.services.sns.AmazonSNSClientBuilder;
import io.skylite.notifications.credentials.SnsClientFactory;
import io.skylite.notifications.credentials.oss.CredentialsProviderFactory;
import io.skylite.notifications.utils.SecurityAccess;

public final class SnsClientFactoryImpl
implements SnsClientFactory {
    public static final SnsClientFactoryImpl INSTANCE = new SnsClientFactoryImpl();

    private SnsClientFactoryImpl() {
    }

    @Override
    public AmazonSNS createSnsClient(String region, String roleArn) {
        try {
            return SecurityAccess.doPrivileged(() -> {
                AWSCredentialsProvider credentials = new CredentialsProviderFactory().getCredentialsProvider(region, roleArn);
                return (AmazonSNS)((AmazonSNSClientBuilder)((AmazonSNSClientBuilder)AmazonSNSClientBuilder.standard().withRegion(region)).withCredentials(credentials)).build();
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create SNS client", e);
        }
    }
}

