/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.notifications.setting;

import io.skylite.common.SecureString;
import io.skylite.core.bootstrap.BootstrapInfo;
import io.skylite.core.cluster.ClusterName;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.unit.ByteSizeValue;
import io.skylite.core.http.HttpTransportSettings;
import io.skylite.core.notifications.model.SecureDestinationSettings;
import io.skylite.core.settings.SecureSetting;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class PluginSettings {
    private static final Logger log = LogManager.getLogger(PluginSettings.class);
    private static final String KEY_PREFIX = "skylite.notifications.core";
    private static final String EMAIL_KEY_PREFIX = "skylite.notifications.core.email";
    private static final String LEGACY_EMAIL_DESTINATION_SETTING_PREFIX = "plugins.alerting.destination.email.";
    private static final String EMAIL_DESTINATION_SETTING_PREFIX = "skylite.notifications.core.email.";
    private static final String HTTP_CONNECTION_KEY_PREFIX = "skylite.notifications.core.http";
    private static final String EMAIL_SIZE_LIMIT_KEY = "skylite.notifications.core.email.size_limit";
    private static final String EMAIL_MINIMUM_HEADER_LENGTH_KEY = "skylite.notifications.core.email.minimum_header_length";
    private static final String MAX_CONNECTIONS_KEY = "skylite.notifications.core.http.max_connections";
    private static final String MAX_CONNECTIONS_PER_ROUTE_KEY = "skylite.notifications.core.http.max_connection_per_route";
    private static final String CONNECTION_TIMEOUT_MILLISECONDS_KEY = "skylite.notifications.core.http.connection_timeout";
    private static final String SOCKET_TIMEOUT_MILLISECONDS_KEY = "skylite.notifications.core.http.socket_timeout";
    private static final String MAX_HTTP_RESPONSE_SIZE_KEY = "skylite.notifications.core.max_http_response_size";
    private static final String LEGACY_ALERTING_HOST_DENY_LIST_KEY = "opendistro.destination.host.deny_list";
    private static final String ALERTING_HOST_DENY_LIST_KEY = "plugins.destination.host.deny_list";
    private static final String HOST_DENY_LIST_KEY = "skylite.notifications.core.http.host_deny_list";
    private static final String ALLOWED_CONFIG_TYPE_KEY = "skylite.notifications.core.allowed_config_types";
    private static final String TOOLTIP_SUPPORT_KEY = "skylite.notifications.core.tooltip_support";
    private static final String CLUSTER_NAME = "cluster.name";
    private static final String DEFAULT_CLUSTER_NAME = "Lucenia:DefaultClusterName";
    private static final int DEFAULT_EMAIL_SIZE_LIMIT = 10000000;
    private static final int MINIMUM_EMAIL_SIZE_LIMIT = 10000;
    private static final int DEFAULT_MAX_CONNECTIONS = 60;
    private static final int DEFAULT_MAX_CONNECTIONS_PER_ROUTE = 20;
    private static final int DEFAULT_CONNECTION_TIMEOUT_MILLISECONDS = 5000;
    private static final int DEFAULT_SOCKET_TIMEOUT_MILLISECONDS = 50000;
    private static final int DEFAULT_MAX_HTTP_RESPONSE_SIZE = (int)((ByteSizeValue)HttpTransportSettings.SETTING_HTTP_MAX_CONTENT_LENGTH.getDefault(Settings.EMPTY)).getBytes();
    private static final int DEFAULT_MINIMUM_EMAIL_HEADER_LENGTH = 160;
    private static final List<String> DEFAULT_ALLOWED_CONFIG_TYPES = Arrays.asList("slack", "chime", "microsoft_teams", "webhook", "email", "sns", "ses_account", "smtp_account", "email_group");
    private static final List<String> DEFAULT_HOST_DENY_LIST = Collections.emptyList();
    private static final boolean DEFAULT_TOOLTIP_SUPPORT = true;
    private static final Map<String, SecureDestinationSettings> DEFAULT_DESTINATION_SETTINGS = Collections.emptyMap();
    private static volatile List<String> allowedConfigTypes;
    private static volatile int emailSizeLimit;
    private static volatile int emailMinimumHeaderLength;
    private static volatile int maxConnections;
    private static volatile int maxConnectionsPerRoute;
    private static volatile int connectionTimeout;
    private static volatile int socketTimeout;
    private static volatile int maxHttpResponseSize;
    private static volatile boolean tooltipSupport;
    private static volatile List<String> hostDenyList;
    private static volatile String clusterName;
    private static volatile Map<String, SecureDestinationSettings> destinationSettings;
    private static final Map<String, String> defaultSettings;
    public static final Setting<Integer> EMAIL_SIZE_LIMIT_SETTING;
    public static final Setting<Integer> EMAIL_MINIMUM_HEADER_LENGTH_SETTING;
    public static final Setting<Integer> MAX_CONNECTIONS_SETTING;
    public static final Setting<Integer> MAX_CONNECTIONS_PER_ROUTE_SETTING;
    public static final Setting<Integer> CONNECTION_TIMEOUT_MILLISECONDS_SETTING;
    public static final Setting<Integer> SOCKET_TIMEOUT_MILLISECONDS_SETTING;
    public static final Setting<Integer> MAX_HTTP_RESPONSE_SIZE_SETTING;
    public static final Setting<List<String>> ALLOWED_CONFIG_TYPES_SETTING;
    public static final Setting<Boolean> TOOLTIP_SUPPORT_SETTING;
    public static final Setting<List<String>> LEGACY_ALERTING_HOST_DENY_LIST_SETTING;
    public static final Setting<List<String>> ALERTING_HOST_DENY_LIST_SETTING;
    public static final Setting<List<String>> HOST_DENY_LIST_SETTING;
    private static final Setting.AffixSetting<SecureString> LEGACY_EMAIL_USERNAME;
    private static final Setting.AffixSetting<SecureString> LEGACY_EMAIL_PASSWORD;
    private static final Setting.AffixSetting<SecureString> EMAIL_USERNAME;
    private static final Setting.AffixSetting<SecureString> EMAIL_PASSWORD;

    private PluginSettings() {
    }

    public static List<Setting<?>> getAllSettings() {
        return Arrays.asList(EMAIL_SIZE_LIMIT_SETTING, EMAIL_MINIMUM_HEADER_LENGTH_SETTING, MAX_CONNECTIONS_SETTING, MAX_CONNECTIONS_PER_ROUTE_SETTING, CONNECTION_TIMEOUT_MILLISECONDS_SETTING, SOCKET_TIMEOUT_MILLISECONDS_SETTING, MAX_HTTP_RESPONSE_SIZE_SETTING, ALLOWED_CONFIG_TYPES_SETTING, TOOLTIP_SUPPORT_SETTING, HOST_DENY_LIST_SETTING, EMAIL_USERNAME, EMAIL_PASSWORD);
    }

    private static void updateSettingValuesFromLocal(ClusterService clusterService) {
        allowedConfigTypes = (List)ALLOWED_CONFIG_TYPES_SETTING.get(clusterService.getSettings());
        emailSizeLimit = (Integer)EMAIL_SIZE_LIMIT_SETTING.get(clusterService.getSettings());
        emailMinimumHeaderLength = (Integer)EMAIL_MINIMUM_HEADER_LENGTH_SETTING.get(clusterService.getSettings());
        maxConnections = (Integer)MAX_CONNECTIONS_SETTING.get(clusterService.getSettings());
        maxConnectionsPerRoute = (Integer)MAX_CONNECTIONS_PER_ROUTE_SETTING.get(clusterService.getSettings());
        connectionTimeout = (Integer)CONNECTION_TIMEOUT_MILLISECONDS_SETTING.get(clusterService.getSettings());
        socketTimeout = (Integer)SOCKET_TIMEOUT_MILLISECONDS_SETTING.get(clusterService.getSettings());
        maxHttpResponseSize = (Integer)MAX_HTTP_RESPONSE_SIZE_SETTING.get(clusterService.getSettings());
        tooltipSupport = (Boolean)TOOLTIP_SUPPORT_SETTING.get(clusterService.getSettings());
        hostDenyList = (List)HOST_DENY_LIST_SETTING.get(clusterService.getSettings());
        destinationSettings = PluginSettings.loadDestinationSettings(clusterService.getSettings());
        clusterName = clusterService.getClusterName().value();
    }

    private static void updateSettingValuesFromCluster(ClusterService clusterService) {
        ClusterName clusterClusterName;
        List clusterHostDenyList;
        Boolean clusterTooltipSupport;
        List clusterAllowedConfigTypes;
        Integer clusterMaxHttpResponseSize;
        Integer clusterSocketTimeout;
        Integer clusterConnectionTimeout;
        Integer clusterMaxConnectionsPerRoute;
        Integer clusterMaxConnections;
        Integer clusterEmailMinimumHeaderLength;
        Integer clusterEmailSizeLimit = (Integer)clusterService.getClusterSettings().get(EMAIL_SIZE_LIMIT_SETTING);
        if (clusterEmailSizeLimit != null) {
            log.debug("{}:{} -autoUpdatedTo-> {}", (Object)"notifications-core", (Object)EMAIL_SIZE_LIMIT_KEY, (Object)clusterEmailSizeLimit);
            emailSizeLimit = clusterEmailSizeLimit;
        }
        if ((clusterEmailMinimumHeaderLength = (Integer)clusterService.getClusterSettings().get(EMAIL_MINIMUM_HEADER_LENGTH_SETTING)) != null) {
            log.debug("{}:{} -autoUpdatedTo-> {}", (Object)"notifications-core", (Object)EMAIL_MINIMUM_HEADER_LENGTH_KEY, (Object)clusterEmailMinimumHeaderLength);
            emailMinimumHeaderLength = clusterEmailMinimumHeaderLength;
        }
        if ((clusterMaxConnections = (Integer)clusterService.getClusterSettings().get(MAX_CONNECTIONS_SETTING)) != null) {
            log.debug("{}:{} -autoUpdatedTo-> {}", (Object)"notifications-core", (Object)MAX_CONNECTIONS_KEY, (Object)clusterMaxConnections);
            maxConnections = clusterMaxConnections;
        }
        if ((clusterMaxConnectionsPerRoute = (Integer)clusterService.getClusterSettings().get(MAX_CONNECTIONS_PER_ROUTE_SETTING)) != null) {
            log.debug("{}:{} -autoUpdatedTo-> {}", (Object)"notifications-core", (Object)MAX_CONNECTIONS_PER_ROUTE_KEY, (Object)clusterMaxConnectionsPerRoute);
            maxConnectionsPerRoute = clusterMaxConnectionsPerRoute;
        }
        if ((clusterConnectionTimeout = (Integer)clusterService.getClusterSettings().get(CONNECTION_TIMEOUT_MILLISECONDS_SETTING)) != null) {
            log.debug("{}:{} -autoUpdatedTo-> {}", (Object)"notifications-core", (Object)CONNECTION_TIMEOUT_MILLISECONDS_KEY, (Object)clusterConnectionTimeout);
            connectionTimeout = clusterConnectionTimeout;
        }
        if ((clusterSocketTimeout = (Integer)clusterService.getClusterSettings().get(SOCKET_TIMEOUT_MILLISECONDS_SETTING)) != null) {
            log.debug("{}:{} -autoUpdatedTo-> {}", (Object)"notifications-core", (Object)SOCKET_TIMEOUT_MILLISECONDS_KEY, (Object)clusterSocketTimeout);
            socketTimeout = clusterSocketTimeout;
        }
        if ((clusterMaxHttpResponseSize = (Integer)clusterService.getClusterSettings().get(MAX_HTTP_RESPONSE_SIZE_SETTING)) != null) {
            log.debug("{}:{} -autoUpdatedTo-> {}", (Object)"notifications-core", (Object)MAX_HTTP_RESPONSE_SIZE_KEY, (Object)clusterMaxHttpResponseSize);
            maxHttpResponseSize = clusterMaxHttpResponseSize;
        }
        if ((clusterAllowedConfigTypes = (List)clusterService.getClusterSettings().get(ALLOWED_CONFIG_TYPES_SETTING)) != null) {
            log.debug("{}:{} -autoUpdatedTo-> {}", (Object)"notifications-core", (Object)ALLOWED_CONFIG_TYPE_KEY, (Object)clusterAllowedConfigTypes);
            allowedConfigTypes = clusterAllowedConfigTypes;
        }
        if ((clusterTooltipSupport = (Boolean)clusterService.getClusterSettings().get(TOOLTIP_SUPPORT_SETTING)) != null) {
            log.debug("{}:{} -autoUpdatedTo-> {}", (Object)"notifications-core", (Object)TOOLTIP_SUPPORT_KEY, (Object)clusterTooltipSupport);
            tooltipSupport = clusterTooltipSupport;
        }
        if ((clusterHostDenyList = (List)clusterService.getClusterSettings().get(HOST_DENY_LIST_SETTING)) != null) {
            log.debug("{}:{} -autoUpdatedTo-> {}", (Object)"notifications-core", (Object)HOST_DENY_LIST_KEY, (Object)clusterHostDenyList);
            hostDenyList = clusterHostDenyList;
        }
        if ((clusterClusterName = clusterService.getClusterName()) != null) {
            log.debug("{}:cluster.name -autoUpdatedTo-> {}", (Object)"notifications-core", (Object)clusterClusterName);
            clusterName = clusterClusterName.value();
        }
    }

    public static void addSettingsUpdateConsumer(ClusterService clusterService) {
        PluginSettings.updateSettingValuesFromLocal(clusterService);
        PluginSettings.updateSettingValuesFromCluster(clusterService);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(ALLOWED_CONFIG_TYPES_SETTING, value -> {
            allowedConfigTypes = value;
            log.info("{}:{} -updatedTo-> {}", (Object)"notifications-core", (Object)ALLOWED_CONFIG_TYPE_KEY, value);
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(EMAIL_SIZE_LIMIT_SETTING, value -> {
            emailSizeLimit = value;
            log.info("{}:{} -updatedTo-> {}", (Object)"notifications-core", (Object)EMAIL_SIZE_LIMIT_KEY, value);
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(EMAIL_MINIMUM_HEADER_LENGTH_SETTING, value -> {
            emailMinimumHeaderLength = value;
            log.info("{}:{} -updatedTo-> {}", (Object)"notifications-core", (Object)EMAIL_MINIMUM_HEADER_LENGTH_KEY, value);
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MAX_CONNECTIONS_SETTING, value -> {
            maxConnections = value;
            log.info("{}:{} -updatedTo-> {}", (Object)"notifications-core", (Object)MAX_CONNECTIONS_KEY, value);
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MAX_CONNECTIONS_PER_ROUTE_SETTING, value -> {
            maxConnectionsPerRoute = value;
            log.info("{}:{} -updatedTo-> {}", (Object)"notifications-core", (Object)MAX_CONNECTIONS_PER_ROUTE_KEY, value);
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(CONNECTION_TIMEOUT_MILLISECONDS_SETTING, value -> {
            connectionTimeout = value;
            log.info("{}:{} -updatedTo-> {}", (Object)"notifications-core", (Object)CONNECTION_TIMEOUT_MILLISECONDS_KEY, value);
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(SOCKET_TIMEOUT_MILLISECONDS_SETTING, value -> {
            socketTimeout = value;
            log.info("{}:{} -updatedTo-> {}", (Object)"notifications-core", (Object)SOCKET_TIMEOUT_MILLISECONDS_KEY, value);
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MAX_HTTP_RESPONSE_SIZE_SETTING, value -> {
            maxHttpResponseSize = value;
            log.info("{}:{} -updatedTo-> {}", (Object)"notifications-core", (Object)MAX_HTTP_RESPONSE_SIZE_KEY, value);
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(TOOLTIP_SUPPORT_SETTING, value -> {
            tooltipSupport = value;
            log.info("{}:{} -updatedTo-> {}", (Object)"notifications-core", (Object)TOOLTIP_SUPPORT_KEY, value);
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(HOST_DENY_LIST_SETTING, value -> {
            hostDenyList = value;
            log.info("{}:{} -updatedTo-> {}", (Object)"notifications-core", (Object)HOST_DENY_LIST_KEY, value);
        });
    }

    public static Map<String, SecureDestinationSettings> loadDestinationSettings(Settings settings) {
        HashSet emailAccountNames = new HashSet(settings.getGroups(EMAIL_DESTINATION_SETTING_PREFIX, true).keySet());
        Set legacyEmailAccountNames = settings.getGroups(LEGACY_EMAIL_DESTINATION_SETTING_PREFIX, true).keySet();
        emailAccountNames.addAll(legacyEmailAccountNames);
        HashMap<String, SecureDestinationSettings> emailAccounts = new HashMap<String, SecureDestinationSettings>();
        for (String emailAccountName : emailAccountNames) {
            SecureDestinationSettings secureSettings = PluginSettings.getSecureDestinationSettings(settings, emailAccountName);
            if (secureSettings == null) continue;
            emailAccounts.put(emailAccountName, secureSettings);
        }
        return emailAccounts;
    }

    private static SecureDestinationSettings getSecureDestinationSettings(Settings settings, String emailAccountName) {
        SecureString emailUsername = PluginSettings.getEmailSettingValue(settings, emailAccountName, EMAIL_USERNAME);
        if (emailUsername == null) {
            return null;
        }
        SecureString emailPassword = PluginSettings.getEmailSettingValue(settings, emailAccountName, EMAIL_PASSWORD);
        if (emailPassword == null) {
            return null;
        }
        return new SecureDestinationSettings(emailUsername.clone(), emailPassword.clone());
    }

    private static <T> T getEmailSettingValue(Settings settings, String emailAccountName, Setting.AffixSetting<T> emailSetting) {
        Setting concreteSetting = emailSetting.getConcreteSettingForNamespace(emailAccountName);
        return (T)concreteSetting.get(settings);
    }

    private static <T> Setting<T> fallback(String key, Setting.AffixSetting<T> affixSetting, String regex, String replacement) {
        if ("_na_".equals(key)) {
            return affixSetting.getConcreteSettingForNamespace(key);
        }
        return affixSetting.getConcreteSetting(key.replaceAll(regex, replacement));
    }

    public static void reset() {
        emailSizeLimit = 10000000;
        emailMinimumHeaderLength = 160;
        maxConnections = 60;
        maxConnectionsPerRoute = 20;
        connectionTimeout = 5000;
        socketTimeout = 50000;
        maxHttpResponseSize = DEFAULT_MAX_HTTP_RESPONSE_SIZE;
        allowedConfigTypes = DEFAULT_ALLOWED_CONFIG_TYPES;
        tooltipSupport = true;
        hostDenyList = DEFAULT_HOST_DENY_LIST;
    }

    public static List<String> getAllowedConfigTypes() {
        return allowedConfigTypes;
    }

    public static int getEmailSizeLimit() {
        return emailSizeLimit;
    }

    public static int getEmailMinimumHeaderLength() {
        return emailMinimumHeaderLength;
    }

    public static int getMaxConnections() {
        return maxConnections;
    }

    public static int getMaxConnectionsPerRoute() {
        return maxConnectionsPerRoute;
    }

    public static int getConnectionTimeout() {
        return connectionTimeout;
    }

    public static int getSocketTimeout() {
        return socketTimeout;
    }

    public static int getMaxHttpResponseSize() {
        return maxHttpResponseSize;
    }

    public static boolean isTooltipSupport() {
        return tooltipSupport;
    }

    public static List<String> getHostDenyList() {
        return hostDenyList;
    }

    public static String getClusterName() {
        return clusterName;
    }

    public static Map<String, SecureDestinationSettings> getDestinationSettings() {
        return destinationSettings;
    }

    public static void setDestinationSettings(Map<String, SecureDestinationSettings> settings) {
        destinationSettings = settings;
    }

    static {
        Settings settings = null;
        Object configDirName = null;
        Dictionary systemProps = BootstrapInfo.getSystemProperties();
        if (systemProps != null) {
            configDirName = systemProps.get("lucenia.path.conf");
        }
        if (configDirName != null) {
            Path defaultSettingYmlFile = Path.of(configDirName.toString(), "skylite-notifications-core", "notifications-core.yml");
            try {
                settings = Settings.builder().loadFromPath(defaultSettingYmlFile).build();
            }
            catch (IOException e) {
                log.warn("{}:Failed to load {}:{}", (Object)"notifications-core", (Object)defaultSettingYmlFile.toAbsolutePath(), (Object)e.getMessage());
            }
        }
        emailSizeLimit = settings != null && settings.get(EMAIL_SIZE_LIMIT_KEY) != null ? Integer.parseInt(settings.get(EMAIL_SIZE_LIMIT_KEY)) : 10000000;
        emailMinimumHeaderLength = settings != null && settings.get(EMAIL_MINIMUM_HEADER_LENGTH_KEY) != null ? Integer.parseInt(settings.get(EMAIL_MINIMUM_HEADER_LENGTH_KEY)) : 160;
        maxConnections = settings != null && settings.get(MAX_CONNECTIONS_KEY) != null ? Integer.parseInt(settings.get(MAX_CONNECTIONS_KEY)) : 60;
        maxConnectionsPerRoute = settings != null && settings.get(MAX_CONNECTIONS_PER_ROUTE_KEY) != null ? Integer.parseInt(settings.get(MAX_CONNECTIONS_PER_ROUTE_KEY)) : 20;
        connectionTimeout = settings != null && settings.get(CONNECTION_TIMEOUT_MILLISECONDS_KEY) != null ? Integer.parseInt(settings.get(CONNECTION_TIMEOUT_MILLISECONDS_KEY)) : 5000;
        socketTimeout = settings != null && settings.get(SOCKET_TIMEOUT_MILLISECONDS_KEY) != null ? Integer.parseInt(settings.get(SOCKET_TIMEOUT_MILLISECONDS_KEY)) : 50000;
        maxHttpResponseSize = settings != null && settings.get(MAX_HTTP_RESPONSE_SIZE_KEY) != null ? Integer.parseInt(settings.get(MAX_HTTP_RESPONSE_SIZE_KEY)) : DEFAULT_MAX_HTTP_RESPONSE_SIZE;
        allowedConfigTypes = settings != null ? settings.getAsList(ALLOWED_CONFIG_TYPE_KEY, DEFAULT_ALLOWED_CONFIG_TYPES) : DEFAULT_ALLOWED_CONFIG_TYPES;
        tooltipSupport = settings != null ? settings.getAsBoolean(TOOLTIP_SUPPORT_KEY, Boolean.valueOf(true)) : true;
        hostDenyList = settings != null ? settings.getAsList(HOST_DENY_LIST_KEY, DEFAULT_HOST_DENY_LIST) : DEFAULT_HOST_DENY_LIST;
        clusterName = settings != null ? settings.get(CLUSTER_NAME, DEFAULT_CLUSTER_NAME) : DEFAULT_CLUSTER_NAME;
        destinationSettings = settings != null ? PluginSettings.loadDestinationSettings(settings) : DEFAULT_DESTINATION_SETTINGS;
        defaultSettings = new HashMap<String, String>();
        defaultSettings.put(EMAIL_SIZE_LIMIT_KEY, String.valueOf(emailSizeLimit));
        defaultSettings.put(EMAIL_MINIMUM_HEADER_LENGTH_KEY, String.valueOf(emailMinimumHeaderLength));
        defaultSettings.put(MAX_CONNECTIONS_KEY, String.valueOf(maxConnections));
        defaultSettings.put(MAX_CONNECTIONS_PER_ROUTE_KEY, String.valueOf(maxConnectionsPerRoute));
        defaultSettings.put(CONNECTION_TIMEOUT_MILLISECONDS_KEY, String.valueOf(connectionTimeout));
        defaultSettings.put(SOCKET_TIMEOUT_MILLISECONDS_KEY, String.valueOf(socketTimeout));
        defaultSettings.put(MAX_HTTP_RESPONSE_SIZE_KEY, String.valueOf(maxHttpResponseSize));
        defaultSettings.put(TOOLTIP_SUPPORT_KEY, String.valueOf(tooltipSupport));
        EMAIL_SIZE_LIMIT_SETTING = Setting.intSetting((String)EMAIL_SIZE_LIMIT_KEY, (int)Integer.parseInt(defaultSettings.get(EMAIL_SIZE_LIMIT_KEY)), (int)10000, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
        EMAIL_MINIMUM_HEADER_LENGTH_SETTING = Setting.intSetting((String)EMAIL_MINIMUM_HEADER_LENGTH_KEY, (int)Integer.parseInt(defaultSettings.get(EMAIL_MINIMUM_HEADER_LENGTH_KEY)), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
        MAX_CONNECTIONS_SETTING = Setting.intSetting((String)MAX_CONNECTIONS_KEY, (int)Integer.parseInt(defaultSettings.get(MAX_CONNECTIONS_KEY)), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
        MAX_CONNECTIONS_PER_ROUTE_SETTING = Setting.intSetting((String)MAX_CONNECTIONS_PER_ROUTE_KEY, (int)Integer.parseInt(defaultSettings.get(MAX_CONNECTIONS_PER_ROUTE_KEY)), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
        CONNECTION_TIMEOUT_MILLISECONDS_SETTING = Setting.intSetting((String)CONNECTION_TIMEOUT_MILLISECONDS_KEY, (int)Integer.parseInt(defaultSettings.get(CONNECTION_TIMEOUT_MILLISECONDS_KEY)), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
        SOCKET_TIMEOUT_MILLISECONDS_SETTING = Setting.intSetting((String)SOCKET_TIMEOUT_MILLISECONDS_KEY, (int)Integer.parseInt(defaultSettings.get(SOCKET_TIMEOUT_MILLISECONDS_KEY)), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
        MAX_HTTP_RESPONSE_SIZE_SETTING = Setting.intSetting((String)MAX_HTTP_RESPONSE_SIZE_KEY, (int)Integer.parseInt(defaultSettings.get(MAX_HTTP_RESPONSE_SIZE_KEY)), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
        ALLOWED_CONFIG_TYPES_SETTING = Setting.listSetting((String)ALLOWED_CONFIG_TYPE_KEY, DEFAULT_ALLOWED_CONFIG_TYPES, Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
        TOOLTIP_SUPPORT_SETTING = Setting.boolSetting((String)TOOLTIP_SUPPORT_KEY, (boolean)Boolean.parseBoolean(defaultSettings.get(TOOLTIP_SUPPORT_KEY)), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
        LEGACY_ALERTING_HOST_DENY_LIST_SETTING = Setting.listSetting((String)LEGACY_ALERTING_HOST_DENY_LIST_KEY, DEFAULT_HOST_DENY_LIST, Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Final, Setting.Property.Deprecated});
        ALERTING_HOST_DENY_LIST_SETTING = Setting.listSetting((String)ALERTING_HOST_DENY_LIST_KEY, LEGACY_ALERTING_HOST_DENY_LIST_SETTING, Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Final});
        HOST_DENY_LIST_SETTING = Setting.listSetting((String)HOST_DENY_LIST_KEY, ALERTING_HOST_DENY_LIST_SETTING, Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
        LEGACY_EMAIL_USERNAME = Setting.affixKeySetting((String)LEGACY_EMAIL_DESTINATION_SETTING_PREFIX, (String)"username", key -> SecureSetting.secureString((String)key, null, (Setting.Property[])new Setting.Property[0]), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
        LEGACY_EMAIL_PASSWORD = Setting.affixKeySetting((String)LEGACY_EMAIL_DESTINATION_SETTING_PREFIX, (String)"password", key -> SecureSetting.secureString((String)key, null, (Setting.Property[])new Setting.Property[0]), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
        EMAIL_USERNAME = Setting.affixKeySetting((String)EMAIL_DESTINATION_SETTING_PREFIX, (String)"username", key -> SecureSetting.secureString((String)key, PluginSettings.fallback(key, LEGACY_EMAIL_USERNAME, "skylite\\.notifications\\.core", "plugins.alerting.destination"), (Setting.Property[])new Setting.Property[0]), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
        EMAIL_PASSWORD = Setting.affixKeySetting((String)EMAIL_DESTINATION_SETTING_PREFIX, (String)"password", key -> SecureSetting.secureString((String)key, PluginSettings.fallback(key, LEGACY_EMAIL_PASSWORD, "skylite\\.notifications\\.core", "plugins.alerting.destination"), (Setting.Property[])new Setting.Property[0]), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    }
}

