/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.notifications.transport;

import io.skylite.core.notifications.model.destination.BaseDestination;
import io.skylite.core.notifications.model.destination.DestinationType;
import io.skylite.notifications.transport.DestinationTransport;
import io.skylite.notifications.transport.SesDestinationTransport;
import io.skylite.notifications.transport.SmtpDestinationTransport;
import io.skylite.notifications.transport.SnsDestinationTransport;
import io.skylite.notifications.transport.WebhookDestinationTransport;
import java.util.EnumMap;
import java.util.Map;

public final class DestinationTransportProvider {
    private static final WebhookDestinationTransport WEBHOOK_DESTINATION_TRANSPORT = new WebhookDestinationTransport();
    private static final SmtpDestinationTransport SMTP_DESTINATION_TRANSPORT = new SmtpDestinationTransport();
    private static final SnsDestinationTransport SNS_DESTINATION_TRANSPORT = new SnsDestinationTransport();
    private static final SesDestinationTransport SES_DESTINATION_TRANSPORT = new SesDestinationTransport();
    public static Map<DestinationType, DestinationTransport<? extends BaseDestination>> destinationTransportMap = new EnumMap<DestinationType, DestinationTransport<? extends BaseDestination>>(DestinationType.class);

    private DestinationTransportProvider() {
    }

    public static DestinationTransport<BaseDestination> getTransport(DestinationType destinationType) {
        DestinationTransport<BaseDestination> transport = destinationTransportMap.get(destinationType);
        if (transport == null) {
            throw new IllegalArgumentException("Invalid channel type");
        }
        return transport;
    }

    static {
        destinationTransportMap.put(DestinationType.SLACK, WEBHOOK_DESTINATION_TRANSPORT);
        destinationTransportMap.put(DestinationType.CHIME, WEBHOOK_DESTINATION_TRANSPORT);
        destinationTransportMap.put(DestinationType.MICROSOFT_TEAMS, WEBHOOK_DESTINATION_TRANSPORT);
        destinationTransportMap.put(DestinationType.CUSTOM_WEBHOOK, WEBHOOK_DESTINATION_TRANSPORT);
        destinationTransportMap.put(DestinationType.SMTP, SMTP_DESTINATION_TRANSPORT);
        destinationTransportMap.put(DestinationType.SNS, SNS_DESTINATION_TRANSPORT);
        destinationTransportMap.put(DestinationType.SES, SES_DESTINATION_TRANSPORT);
    }
}

