/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.notifications.transport;

import io.skylite.core.notifications.model.DestinationMessageResponse;
import io.skylite.core.notifications.model.MessageContent;
import io.skylite.core.notifications.model.destination.SesDestination;
import io.skylite.core.rest.RestStatus;
import io.skylite.notifications.client.DestinationClientPool;
import io.skylite.notifications.client.DestinationSesClient;
import io.skylite.notifications.transport.DestinationTransport;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.AddressException;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SesDestinationTransport
implements DestinationTransport<SesDestination> {
    private static final Logger log = LogManager.getLogger(SesDestinationTransport.class);
    private final DestinationSesClient destinationEmailClient;

    public SesDestinationTransport() {
        this.destinationEmailClient = DestinationClientPool.SES_CLIENT;
    }

    public SesDestinationTransport(DestinationSesClient destinationSesClient) {
        this.destinationEmailClient = destinationSesClient;
    }

    @Override
    public DestinationMessageResponse sendMessage(SesDestination destination, MessageContent message, String referenceId) {
        try {
            return this.destinationEmailClient.execute(destination, message, referenceId);
        }
        catch (AddressException addressException) {
            log.error("Error sending Email: recipient parsing failed with status:{}", (Object)addressException.getMessage());
            return new DestinationMessageResponse(RestStatus.BAD_REQUEST.getStatus(), "recipient parsing failed with status:" + addressException.getMessage());
        }
        catch (MessagingException messagingException) {
            log.error("Error sending Email: Email message creation failed with status:{}", (Object)messagingException.getMessage());
            return new DestinationMessageResponse(RestStatus.FAILED_DEPENDENCY.getStatus(), "Email message creation failed with status:" + messagingException.getMessage());
        }
        catch (IOException ioException) {
            log.error("Error sending Email: Email message creation failed with status:{}", (Object)ioException.getMessage());
            return new DestinationMessageResponse(RestStatus.FAILED_DEPENDENCY.getStatus(), "Email message creation failed with status:" + ioException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.error("Error sending Email: Email message creation failed with status:{}", (Object)illegalArgumentException.getMessage());
            return new DestinationMessageResponse(RestStatus.BAD_REQUEST.getStatus(), "Email message creation failed with status:" + illegalArgumentException.getMessage());
        }
        catch (Exception e) {
            log.error("Error sending Email: {}", (Object)e.getMessage());
            return new DestinationMessageResponse(RestStatus.INTERNAL_SERVER_ERROR.getStatus(), "Email message creation failed with status:" + e.getMessage());
        }
    }
}

