/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.notifications.transport;

import io.skylite.core.notifications.model.DestinationMessageResponse;
import io.skylite.core.notifications.model.MessageContent;
import io.skylite.core.notifications.model.destination.SmtpDestination;
import io.skylite.core.rest.RestStatus;
import io.skylite.notifications.client.DestinationClientPool;
import io.skylite.notifications.client.DestinationSmtpClient;
import io.skylite.notifications.transport.DestinationTransport;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.AddressException;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SmtpDestinationTransport
implements DestinationTransport<SmtpDestination> {
    private static final Logger log = LogManager.getLogger(SmtpDestinationTransport.class);
    private final DestinationSmtpClient destinationEmailClient;

    public SmtpDestinationTransport() {
        this.destinationEmailClient = DestinationClientPool.SMTP_CLIENT;
    }

    public SmtpDestinationTransport(DestinationSmtpClient destinationSmtpClient) {
        this.destinationEmailClient = destinationSmtpClient;
    }

    @Override
    public DestinationMessageResponse sendMessage(SmtpDestination destination, MessageContent message, String referenceId) {
        try {
            return this.destinationEmailClient.execute(destination, message, referenceId);
        }
        catch (AddressException addressException) {
            log.error("Error sending Email: recipient parsing failed with status:{}", (Object)addressException.getMessage());
            return new DestinationMessageResponse(RestStatus.BAD_REQUEST.getStatus(), "recipient parsing failed with status:" + addressException.getMessage());
        }
        catch (MessagingException messagingException) {
            log.error("Error sending Email: Email message creation failed with status:{}", (Object)messagingException.getMessage());
            return new DestinationMessageResponse(RestStatus.FAILED_DEPENDENCY.getStatus(), "Email message creation failed with status:" + messagingException.getMessage());
        }
        catch (IOException ioException) {
            log.error("Error sending Email: Email message creation failed with status:{}", (Object)ioException.getMessage());
            return new DestinationMessageResponse(RestStatus.FAILED_DEPENDENCY.getStatus(), "Email message creation failed with status:" + ioException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.error("Error sending Email: Email message creation failed with status:{}", (Object)illegalArgumentException.getMessage());
            return new DestinationMessageResponse(RestStatus.BAD_REQUEST.getStatus(), "Email message creation failed with status:" + illegalArgumentException.getMessage());
        }
        catch (Exception e) {
            log.error("Error sending Email: {}", (Object)e.getMessage());
            return new DestinationMessageResponse(RestStatus.INTERNAL_SERVER_ERROR.getStatus(), "Email message creation failed with status:" + e.getMessage());
        }
    }
}

