/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.notifications.transport;

import io.skylite.core.notifications.model.DestinationMessageResponse;
import io.skylite.core.notifications.model.MessageContent;
import io.skylite.core.notifications.model.destination.SnsDestination;
import io.skylite.core.rest.RestStatus;
import io.skylite.notifications.client.DestinationClientPool;
import io.skylite.notifications.client.DestinationSnsClient;
import io.skylite.notifications.transport.DestinationTransport;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SnsDestinationTransport
implements DestinationTransport<SnsDestination> {
    private static final Logger log = LogManager.getLogger(SnsDestinationTransport.class);
    private final DestinationSnsClient destinationSNSClient;

    public SnsDestinationTransport() {
        this.destinationSNSClient = DestinationClientPool.SNS_CLIENT;
    }

    public SnsDestinationTransport(DestinationSnsClient destinationSnsClient) {
        this.destinationSNSClient = destinationSnsClient;
    }

    @Override
    public DestinationMessageResponse sendMessage(SnsDestination destination, MessageContent message, String referenceId) {
        try {
            return this.destinationSNSClient.execute(destination, message, referenceId);
        }
        catch (IOException exception) {
            log.error("Exception sending message id {} {}", (Object)referenceId, (Object)exception);
            return new DestinationMessageResponse(RestStatus.INTERNAL_SERVER_ERROR.getStatus(), "Failed to send SNS message " + exception.getMessage());
        }
        catch (Exception e) {
            log.error("Exception sending message id {} {}", (Object)referenceId, (Object)e);
            return new DestinationMessageResponse(RestStatus.INTERNAL_SERVER_ERROR.getStatus(), "Failed to send SNS message " + e.getMessage());
        }
    }
}

