/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.notifications.transport;

import io.skylite.core.notifications.model.DestinationMessageResponse;
import io.skylite.core.notifications.model.MessageContent;
import io.skylite.core.notifications.model.destination.WebhookDestination;
import io.skylite.core.rest.RestStatus;
import io.skylite.notifications.client.DestinationClientPool;
import io.skylite.notifications.client.DestinationHttpClient;
import io.skylite.notifications.transport.DestinationTransport;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WebhookDestinationTransport
implements DestinationTransport<WebhookDestination> {
    private static final Logger log = LogManager.getLogger(WebhookDestinationTransport.class);
    private final DestinationHttpClient destinationHttpClient;

    public WebhookDestinationTransport() {
        this.destinationHttpClient = DestinationClientPool.HTTP_CLIENT;
    }

    public WebhookDestinationTransport(DestinationHttpClient destinationHttpClient) {
        this.destinationHttpClient = destinationHttpClient;
    }

    @Override
    public DestinationMessageResponse sendMessage(WebhookDestination destination, MessageContent message, String referenceId) {
        try {
            String response = this.destinationHttpClient.execute(destination, message, referenceId);
            return new DestinationMessageResponse(RestStatus.OK.getStatus(), response);
        }
        catch (IOException exception) {
            log.error("Exception sending webhook message {}: {}, exception: {}", (Object)referenceId, (Object)message, (Object)exception);
            return new DestinationMessageResponse(RestStatus.INTERNAL_SERVER_ERROR.getStatus(), "Failed to send webhook message " + exception.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.error("Exception sending webhook message: message creation failed with status:{}", (Object)illegalArgumentException.getMessage());
            return new DestinationMessageResponse(RestStatus.BAD_REQUEST.getStatus(), "Webhook message creation failed with status:" + illegalArgumentException.getMessage());
        }
        catch (Exception e) {
            log.error("Exception sending webhook message {}: {}, exception: {}", (Object)referenceId, (Object)message, (Object)e);
            return new DestinationMessageResponse(RestStatus.INTERNAL_SERVER_ERROR.getStatus(), "Failed to send webhook message " + e.getMessage());
        }
    }
}

