/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.notifications.utils;

import inet.ipaddr.HostName;
import inet.ipaddr.IPAddressString;
import io.skylite.common.network.NetworkAddress;
import io.skylite.core.common.Strings;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ValidationHelpers {
    private static final Logger log = LogManager.getLogger(ValidationHelpers.class);
    private static final Pattern EMAIL_PATTERN = Pattern.compile("(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\\[(?:(?:(2(5[0-5]|[0-4][0-9])|1[0-9][0-9]|[1-9]?[0-9]))\\.){3}(?:(2(5[0-5]|[0-4][0-9])|1[0-9][0-9]|[1-9]?[0-9])|[a-z0-9-]*[a-z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)])", 2);
    private static final List<String> VALID_METHODS = Arrays.asList("POST", "PUT", "PATCH");

    private ValidationHelpers() {
    }

    public static void validateUrl(String urlString) {
        if (Strings.isNullOrEmpty((String)urlString)) {
            throw new IllegalArgumentException("url is null or empty");
        }
        if (!ValidationHelpers.isValidUrl(urlString)) {
            throw new IllegalArgumentException("Invalid URL or unsupported");
        }
    }

    public static void validateUrlHost(String urlString, List<String> hostDenyList) throws UnknownHostException {
        try {
            URL url = new URL(urlString);
            if (io.skylite.core.notifications.model.destination.ValidationHelpers.getResolvedIps((String)url.getHost()).isEmpty()) {
                throw new UnknownHostException("Host could not be resolved to a valid Ip address");
            }
            if (io.skylite.core.notifications.model.destination.ValidationHelpers.isHostInDenylist((String)urlString, hostDenyList)) {
                throw new IllegalArgumentException("Host of url is denied, based on plugin setting [notification.core.http.host_deny_list]");
            }
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid URL: " + e.getMessage());
        }
    }

    public static void validateEmail(String email) {
        if (Strings.isNullOrEmpty((String)email)) {
            throw new IllegalArgumentException("FromAddress and recipient should be provided");
        }
        if (!ValidationHelpers.isValidEmail(email)) {
            throw new IllegalArgumentException("Invalid email address");
        }
    }

    public static boolean isValidUrl(String urlString) {
        try {
            URL url = new URL(urlString);
            return "https".equals(url.getProtocol()) || "http".equals(url.getProtocol());
        }
        catch (Exception e) {
            return false;
        }
    }

    @Deprecated
    public static boolean isHostInDenylist(String urlString, List<String> hostDenyList) {
        try {
            URL url = new URL(urlString);
            if (url.getHost() != null) {
                InetAddress[] resolvedIps = InetAddress.getAllByName(url.getHost());
                IPAddressString[] resolvedIpStrings = (IPAddressString[])Arrays.stream(resolvedIps).map(inetAddress -> new IPAddressString(NetworkAddress.format((InetAddress)inetAddress))).toArray(IPAddressString[]::new);
                HostName hostStr = new HostName(url.getHost());
                for (String network : hostDenyList) {
                    IPAddressString denyIpStr = new IPAddressString(network);
                    HostName denyHostStr = new HostName(network);
                    boolean hostInDenyList = denyHostStr.equals((Object)hostStr);
                    boolean ipInDenyList = false;
                    for (IPAddressString ipStr : resolvedIpStrings) {
                        if (!denyIpStr.contains(ipStr)) continue;
                        ipInDenyList = true;
                        break;
                    }
                    if (!hostInDenyList && !ipInDenyList) continue;
                    log.error("{} is denied", (Object)url.getHost());
                    return true;
                }
            }
        }
        catch (UnknownHostException e) {
            log.error("Error checking denylist: Unknown host");
            return false;
        }
        catch (Exception e) {
            log.error("Error checking denylist: {} {}", (Object)e.getMessage(), (Object)e);
            return false;
        }
        return false;
    }

    public static boolean isValidEmail(String email) {
        return EMAIL_PATTERN.matcher(email).matches();
    }

    public static void validateMethod(String method) {
        if (Strings.isNullOrEmpty((String)method)) {
            throw new IllegalArgumentException("Method is null or empty");
        }
        boolean isValid = VALID_METHODS.stream().anyMatch(method::contains);
        if (!isValid) {
            throw new IllegalArgumentException("Invalid method supplied. Only POST, PUT and PATCH are allowed");
        }
    }
}

