/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.repositories.s3;

import io.lucenia.repositories.s3.async.AsyncExecutorContainer;
import io.skylite.common.Nullable;
import java.io.Closeable;
import java.io.IOException;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.services.s3.S3AsyncClient;

final class AmazonAsyncS3WithCredentials
implements Closeable {
    private final S3AsyncClient client;
    private final S3AsyncClient priorityClient;
    private final S3AsyncClient urgentClient;
    private final AwsCredentialsProvider credentials;
    private final AsyncExecutorContainer normalExecutorContainer;
    private final AsyncExecutorContainer priorityExecutorContainer;
    private final AsyncExecutorContainer urgentExecutorContainer;

    private AmazonAsyncS3WithCredentials(S3AsyncClient client, S3AsyncClient priorityClient, S3AsyncClient urgentClient, @Nullable AwsCredentialsProvider credentials, AsyncExecutorContainer normalExecutorContainer, AsyncExecutorContainer priorityExecutorContainer, AsyncExecutorContainer urgentExecutorContainer) {
        this.client = client;
        this.credentials = credentials;
        this.priorityClient = priorityClient;
        this.urgentClient = urgentClient;
        this.normalExecutorContainer = normalExecutorContainer;
        this.priorityExecutorContainer = priorityExecutorContainer;
        this.urgentExecutorContainer = urgentExecutorContainer;
    }

    S3AsyncClient client() {
        return this.client;
    }

    S3AsyncClient priorityClient() {
        return this.priorityClient;
    }

    S3AsyncClient urgentClient() {
        return this.urgentClient;
    }

    AwsCredentialsProvider credentials() {
        return this.credentials;
    }

    @Override
    public void close() throws IOException {
        this.client.close();
        this.priorityClient.close();
        this.urgentClient.close();
        if (this.normalExecutorContainer != null) {
            this.normalExecutorContainer.close();
        }
        if (this.priorityExecutorContainer != null) {
            this.priorityExecutorContainer.close();
        }
        if (this.urgentExecutorContainer != null) {
            this.urgentExecutorContainer.close();
        }
        if (this.credentials instanceof Closeable) {
            ((Closeable)this.credentials).close();
        }
    }

    static AmazonAsyncS3WithCredentials create(S3AsyncClient client, S3AsyncClient priorityClient, S3AsyncClient urgentClient, @Nullable AwsCredentialsProvider credentials, AsyncExecutorContainer normalExecutorContainer, AsyncExecutorContainer priorityExecutorContainer, AsyncExecutorContainer urgentExecutorContainer) {
        return new AmazonAsyncS3WithCredentials(client, priorityClient, urgentClient, credentials, normalExecutorContainer, priorityExecutorContainer, urgentExecutorContainer);
    }
}

