/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement;

import io.lucenia.indexmanagement.indexstatemanagement.settings.ManagedIndexSettings;
import io.lucenia.indexmanagement.util.IndexUtils;
import io.skylite.ResourceAlreadyExistsException;
import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.admin.indices.alias.Alias;
import io.skylite.core.action.admin.indices.create.CreateIndexRequest;
import io.skylite.core.action.admin.indices.create.CreateIndexResponse;
import io.skylite.core.action.admin.indices.exists.IndicesExistsRequest;
import io.skylite.core.action.admin.indices.exists.IndicesExistsResponse;
import io.skylite.core.action.clustermanager.AcknowledgedResponse;
import io.skylite.core.client.Client;
import io.skylite.core.client.IndicesAdminClient;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.settings.Settings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IndexManagementIndices {
    private static final Logger logger = LogManager.getLogger(IndexManagementIndices.class);
    public static final String HISTORY_INDEX_BASE = ".opendistro-ism-managed-index-history";
    public static final String HISTORY_WRITE_INDEX_ALIAS = ".opendistro-ism-managed-index-history-write";
    public static final String HISTORY_INDEX_PATTERN = "<.opendistro-ism-managed-index-history-{now/d{yyyy.MM.dd}}-1>";
    public static final String HISTORY_ALL = ".opendistro-ism-managed-index-history*";
    public static final String INDEX_HIDDEN = "index.hidden";
    public static final String INDEX_NUMBER_OF_SHARDS = "index.number_of_shards";
    public static final String INDEX_NUMBER_OF_REPLICAS = "index.number_of_replicas";
    public static final String indexManagementMappings = IndexManagementIndices.loadResource("mappings/opendistro-ism-config.json");
    public static final String indexStateManagementHistoryMappings = IndexManagementIndices.loadResource("mappings/opendistro-ism-history.json");
    public static final String rollupTargetMappings = IndexManagementIndices.loadResource("mappings/opendistro-rollup-target.json");
    public static final String transformTargetMappings = IndexManagementIndices.loadResource("mappings/opendistro-transform-target.json");
    private final IndicesAdminClient client;
    private final ClusterService clusterService;
    private volatile int historyNumberOfShards;
    private volatile int historyNumberOfReplicas;

    private static String loadResource(String resourcePath) {
        String string;
        block9: {
            InputStream is = IndexManagementIndices.class.getClassLoader().getResourceAsStream(resourcePath);
            try {
                if (is == null) {
                    throw new IllegalStateException("Resource not found: " + resourcePath);
                }
                string = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to load resource: " + resourcePath, e);
                }
            }
            is.close();
        }
        return string;
    }

    public IndexManagementIndices(Settings settings, IndicesAdminClient client, ClusterService clusterService) {
        this.client = client;
        this.clusterService = clusterService;
        this.historyNumberOfShards = (Integer)ManagedIndexSettings.HISTORY_NUMBER_OF_SHARDS.get(settings);
        this.historyNumberOfReplicas = (Integer)ManagedIndexSettings.HISTORY_NUMBER_OF_REPLICAS.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(ManagedIndexSettings.HISTORY_NUMBER_OF_SHARDS, value -> {
            this.historyNumberOfShards = value;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(ManagedIndexSettings.HISTORY_NUMBER_OF_REPLICAS, value -> {
            this.historyNumberOfReplicas = value;
        });
    }

    public void checkAndUpdateIMConfigIndex(final ActionListener<AcknowledgedResponse> actionListener) {
        if (!this.indexManagementIndexExists()) {
            CreateIndexRequest indexRequest = new CreateIndexRequest(".opendistro-ism-config").mapping(indexManagementMappings).settings(Settings.builder().put(INDEX_HIDDEN, true).build());
            this.client.create(indexRequest, (ActionListener)new ActionListener<CreateIndexResponse>(){

                public void onResponse(CreateIndexResponse response) {
                    actionListener.onResponse((Object)response);
                }

                public void onFailure(Exception e) {
                    actionListener.onFailure(e);
                }
            });
        } else {
            IndexUtils.checkAndUpdateConfigIndexMapping(this.clusterService.state(), this.client, actionListener);
        }
    }

    public CompletableFuture<Boolean> checkAndUpdateIMConfigIndex(final Logger logger) {
        final CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        this.checkAndUpdateIMConfigIndex(new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse response) {
                if (response.isAcknowledged()) {
                    future.complete(true);
                } else {
                    logger.error("Unable to create or update .opendistro-ism-config with newest mapping.");
                    future.completeExceptionally((Throwable)new SkyliteStatusException("Unable to create or update .opendistro-ism-config with newest mapping.", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                }
            }

            public void onFailure(Exception e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public boolean indexManagementIndexExists() {
        return this.clusterService.state().routingTable().hasIndex(".opendistro-ism-config");
    }

    public CompletableFuture<Boolean> attemptInitStateManagementIndex(Client client) {
        if (this.indexManagementIndexExists()) {
            return CompletableFuture.completedFuture(true);
        }
        final CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        this.checkAndUpdateIMConfigIndex(new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse response) {
                if (response.isAcknowledged()) {
                    future.complete(true);
                } else {
                    logger.error("Creating .opendistro-ism-config with mappings NOT acknowledged");
                    future.complete(false);
                }
            }

            public void onFailure(Exception e) {
                if (e instanceof ResourceAlreadyExistsException) {
                    future.complete(true);
                } else {
                    logger.error("Error trying to create .opendistro-ism-config", (Throwable)e);
                    future.complete(false);
                }
            }
        });
        return future;
    }

    public CompletableFuture<Boolean> attemptUpdateConfigIndexMapping() {
        final CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        IndexUtils.checkAndUpdateConfigIndexMapping(this.clusterService.state(), this.client, new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse response) {
                if (response.isAcknowledged()) {
                    future.complete(true);
                } else {
                    logger.error("Trying to update config index mapping not acknowledged.");
                    future.complete(false);
                }
            }

            public void onFailure(Exception e) {
                logger.error("Failed when trying to update config index mapping.", (Throwable)e);
                future.complete(false);
            }
        });
        return future;
    }

    public boolean indexStateManagementIndexHistoryExists() {
        return this.clusterService.state().metadata().hasAlias(HISTORY_WRITE_INDEX_ALIAS);
    }

    public CompletableFuture<Boolean> checkAndUpdateHistoryIndex() {
        if (!this.indexStateManagementIndexHistoryExists()) {
            return this.createHistoryIndex(HISTORY_INDEX_PATTERN, HISTORY_WRITE_INDEX_ALIAS);
        }
        final CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        IndexUtils.checkAndUpdateHistoryIndexMapping(this.clusterService.state(), this.client, new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse response) {
                if (response.isAcknowledged()) {
                    future.complete(true);
                } else {
                    logger.error("Updating .opendistro-ism-managed-index-history-write with new mappings NOT acknowledged");
                    future.complete(false);
                }
            }

            public void onFailure(Exception e) {
                logger.error("Failed to update history index mapping", (Throwable)e);
                future.complete(false);
            }
        });
        return future;
    }

    private CompletableFuture<Boolean> createHistoryIndex(final String index, final String alias) {
        final CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        this.client.exists((IndicesExistsRequest)new IndicesExistsRequest(new String[]{index}).local(true), (ActionListener)new ActionListener<IndicesExistsResponse>(){

            public void onResponse(IndicesExistsResponse existsResponse) {
                if (existsResponse.isExists()) {
                    future.complete(true);
                    return;
                }
                CreateIndexRequest request = new CreateIndexRequest(index).mapping(indexStateManagementHistoryMappings).settings(Settings.builder().put(IndexManagementIndices.INDEX_HIDDEN, true).put(IndexManagementIndices.INDEX_NUMBER_OF_SHARDS, IndexManagementIndices.this.historyNumberOfShards).put(IndexManagementIndices.INDEX_NUMBER_OF_REPLICAS, IndexManagementIndices.this.historyNumberOfReplicas).build());
                if (alias != null) {
                    request.alias(new Alias(alias));
                }
                IndexManagementIndices.this.client.create(request, (ActionListener)new ActionListener<CreateIndexResponse>(){

                    public void onResponse(CreateIndexResponse createIndexResponse) {
                        if (createIndexResponse.isAcknowledged()) {
                            future.complete(true);
                        } else {
                            logger.error("Creating " + index + " with mappings NOT acknowledged");
                            future.complete(false);
                        }
                    }

                    public void onFailure(Exception e) {
                        if (e instanceof ResourceAlreadyExistsException) {
                            future.complete(true);
                        } else {
                            logger.error("Error trying to create " + index, (Throwable)e);
                            future.complete(false);
                        }
                    }
                });
            }

            public void onFailure(Exception e) {
                logger.error("Error checking if index exists: " + index, (Throwable)e);
                future.complete(false);
            }
        });
        return future;
    }
}

