/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement;

import io.lucenia.indexmanagement.indexstatemanagement.ManagedIndexRunner;
import io.lucenia.indexmanagement.indexstatemanagement.model.ManagedIndexConfig;
import io.lucenia.indexmanagement.rollup.RollupRunner;
import io.lucenia.indexmanagement.rollup.model.Rollup;
import io.lucenia.indexmanagement.snapshotmanagement.SMRunner;
import io.lucenia.indexmanagement.snapshotmanagement.model.SMPolicy;
import io.lucenia.indexmanagement.transform.TransformRunner;
import io.lucenia.indexmanagement.transform.model.Transform;
import io.skylite.core.jobs.JobExecutionContext;
import io.skylite.core.jobs.ScheduledJobParameter;
import io.skylite.jobs.ScheduledJobRunner;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IndexManagementRunner
implements ScheduledJobRunner {
    public static final IndexManagementRunner INSTANCE = new IndexManagementRunner();
    private static final Logger logger = LogManager.getLogger(IndexManagementRunner.class);

    private IndexManagementRunner() {
    }

    public void runJob(ScheduledJobParameter job, JobExecutionContext context) {
        logger.info("IndexManagementRunner.runJob called with job type: {}, jobId: {}", (Object)job.getClass().getSimpleName(), (Object)context.getJobId());
        if (job instanceof ManagedIndexConfig) {
            logger.info("Delegating to ManagedIndexRunner.INSTANCE for ManagedIndexConfig");
            ManagedIndexRunner.INSTANCE.runJob(job, context);
        } else if (job instanceof Rollup) {
            RollupRunner.INSTANCE.runJob(job, context);
        } else if (job instanceof Transform) {
            TransformRunner.INSTANCE.runJob(job, context);
        } else if (job instanceof SMPolicy) {
            SMRunner.INSTANCE.runJob(job, context);
        } else {
            String errorMessage = "Invalid job type, found " + job.getClass().getSimpleName() + " with id: " + context.getJobId();
            logger.error(errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
    }
}

