/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.common.model.dimension;

import io.lucenia.indexmanagement.common.model.dimension.Dimension;
import io.lucenia.indexmanagement.util.IndexUtils;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.index.query.AbstractQueryBuilder;
import io.skylite.core.index.query.RangeQueryBuilder;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.time.ZoneId;
import java.util.Map;
import java.util.Objects;
import org.opensearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.opensearch.search.aggregations.bucket.composite.DateHistogramValuesSourceBuilder;
import org.opensearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.opensearch.search.aggregations.bucket.histogram.DateHistogramInterval;

public class DateHistogram
extends Dimension {
    public static final String UTC = "UTC";
    public static final String FIXED_INTERVAL_FIELD = "fixed_interval";
    public static final String CALENDAR_INTERVAL_FIELD = "calendar_interval";
    public static final String DATE_HISTOGRAM_TIMEZONE_FIELD = "timezone";
    public static final String FORMAT = "format";
    private final String fixedInterval;
    private final String calendarInterval;
    private final ZoneId timezone;
    private final String format;

    public DateHistogram(String sourceField, String targetField, String fixedInterval, String calendarInterval, ZoneId timezone, String format) {
        super(Dimension.Type.DATE_HISTOGRAM, sourceField, targetField);
        if (sourceField == null || sourceField.isEmpty() || targetField == null || targetField.isEmpty()) {
            throw new IllegalArgumentException("Source and target field must not be empty");
        }
        if (fixedInterval == null && calendarInterval == null) {
            throw new IllegalArgumentException("Must specify a fixed or calendar interval");
        }
        if (fixedInterval != null && calendarInterval != null) {
            throw new IllegalArgumentException("Can only specify a fixed or calendar interval");
        }
        this.fixedInterval = fixedInterval;
        this.calendarInterval = calendarInterval;
        this.timezone = timezone;
        this.format = format;
    }

    public DateHistogram(StreamInput sin) throws IOException {
        this(sin.readString(), sin.readString(), sin.readOptionalString(), sin.readOptionalString(), sin.readZoneId(), null);
    }

    public String getFixedInterval() {
        return this.fixedInterval;
    }

    public String getCalendarInterval() {
        return this.calendarInterval;
    }

    public ZoneId getTimezone() {
        return this.timezone;
    }

    public String getFormat() {
        return this.format;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject(this.getType().getType());
        if (this.fixedInterval != null) {
            builder.field(FIXED_INTERVAL_FIELD, this.fixedInterval);
        }
        if (this.calendarInterval != null) {
            builder.field(CALENDAR_INTERVAL_FIELD, this.calendarInterval);
        }
        builder.field("source_field", this.getSourceField());
        builder.field("target_field", this.getTargetField());
        builder.field(DATE_HISTOGRAM_TIMEZONE_FIELD, this.timezone.getId());
        builder.field(FORMAT, this.format);
        builder.endObject();
        return builder.endObject();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.getSourceField());
        out.writeString(this.getTargetField());
        out.writeOptionalString(this.fixedInterval);
        out.writeOptionalString(this.calendarInterval);
        out.writeZoneId(this.timezone);
    }

    @Override
    public CompositeValuesSourceBuilder<?> toSourceBuilder(boolean appendType) {
        String name = appendType ? this.getTargetField() + "." + Dimension.Type.DATE_HISTOGRAM.getType() : this.getTargetField();
        DateHistogramValuesSourceBuilder builder = ((DateHistogramValuesSourceBuilder)((DateHistogramValuesSourceBuilder)new DateHistogramValuesSourceBuilder(name).missingBucket(true)).field(this.getSourceField())).timeZone(this.timezone);
        if (this.calendarInterval != null) {
            builder.calendarInterval(new DateHistogramInterval(this.calendarInterval));
        }
        if (this.fixedInterval != null) {
            builder.fixedInterval(new DateHistogramInterval(this.fixedInterval));
        }
        if (this.format != null) {
            builder.format(this.format);
        }
        return builder;
    }

    @Override
    public AbstractQueryBuilder<?> toBucketQuery(Object bucketKey) {
        if (!(bucketKey instanceof Long)) {
            throw new IllegalArgumentException("Received invalid date histogram bucket key type [" + String.valueOf(bucketKey.getClass()) + "] when Long is expected.");
        }
        long bucketKeyLong = (Long)bucketKey;
        String intervalStr = this.fixedInterval != null ? this.fixedInterval : this.calendarInterval;
        long interval = new DateHistogramInterval(intervalStr).estimateMillis();
        return new RangeQueryBuilder(this.getSourceField()).from((Object)bucketKeyLong, true).to((Object)(bucketKeyLong + interval), false).timeZone(this.timezone.toString()).format("epoch_millis");
    }

    @Override
    public boolean canBeRealizedInMappings(Map<String, Object> mappings) {
        Map<?, ?> fieldMapping = IndexUtils.getFieldFromMappings(this.getSourceField(), mappings);
        if (fieldMapping == null) {
            return false;
        }
        Object fieldType = fieldMapping.get("type");
        return "date".equals(fieldType);
    }

    public DateHistogramAggregationBuilder getRewrittenAggregation(DateHistogramAggregationBuilder aggregationBuilder, AggregatorFactories.Builder subAggregations) {
        DateHistogramAggregationBuilder rewritten = new DateHistogramAggregationBuilder(aggregationBuilder.getName());
        if (aggregationBuilder.getCalendarInterval() != null) {
            rewritten.calendarInterval(aggregationBuilder.getCalendarInterval());
        }
        if (aggregationBuilder.getFixedInterval() != null) {
            rewritten.fixedInterval(aggregationBuilder.getFixedInterval());
        }
        if (aggregationBuilder.extendedBounds() != null) {
            rewritten.extendedBounds(aggregationBuilder.extendedBounds());
        }
        rewritten.keyed(aggregationBuilder.keyed());
        if (aggregationBuilder.minDocCount() >= 0L) {
            rewritten.minDocCount(aggregationBuilder.minDocCount());
        }
        rewritten.offset(aggregationBuilder.offset());
        if (aggregationBuilder.order() != null) {
            rewritten.order(aggregationBuilder.order());
        }
        rewritten.field(this.getTargetField() + ".date_histogram");
        rewritten.timeZone(this.timezone);
        rewritten.subAggregations(subAggregations);
        return rewritten;
    }

    public static DateHistogram parse(XContentParser xcp) throws IOException {
        String sourceField = null;
        String targetField = null;
        String fixedInterval = null;
        String calendarInterval = null;
        ZoneId timezone = ZoneId.of(UTC);
        String format = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        block16: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "fixed_interval": {
                    fixedInterval = xcp.text();
                    continue block16;
                }
                case "calendar_interval": {
                    calendarInterval = xcp.text();
                    continue block16;
                }
                case "timezone": {
                    timezone = ZoneId.of(xcp.text());
                    continue block16;
                }
                case "source_field": {
                    sourceField = xcp.text();
                    continue block16;
                }
                case "target_field": {
                    targetField = xcp.text();
                    continue block16;
                }
                case "format": {
                    format = xcp.textOrNull();
                    continue block16;
                }
            }
            throw new IllegalArgumentException("Invalid field [" + fieldName + "] found in date histogram");
        }
        if (targetField == null) {
            targetField = sourceField;
        }
        if (sourceField == null) {
            throw new IllegalArgumentException("Source field must not be null");
        }
        if (targetField == null) {
            throw new IllegalArgumentException("Target field must not be null");
        }
        return new DateHistogram(sourceField, targetField, fixedInterval, calendarInterval, timezone, format);
    }

    public static DateHistogram readFrom(StreamInput sin) throws IOException {
        return new DateHistogram(sin);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateHistogram that = (DateHistogram)o;
        return Objects.equals(this.getSourceField(), that.getSourceField()) && Objects.equals(this.getTargetField(), that.getTargetField()) && Objects.equals(this.fixedInterval, that.fixedInterval) && Objects.equals(this.calendarInterval, that.calendarInterval) && Objects.equals(this.timezone, that.timezone) && Objects.equals(this.format, that.format);
    }

    public int hashCode() {
        return Objects.hash(this.getSourceField(), this.getTargetField(), this.fixedInterval, this.calendarInterval, this.timezone, this.format);
    }
}

