/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.common.model.dimension;

import io.lucenia.indexmanagement.common.model.dimension.DateHistogram;
import io.lucenia.indexmanagement.common.model.dimension.Histogram;
import io.lucenia.indexmanagement.common.model.dimension.Terms;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.index.query.AbstractQueryBuilder;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.Map;
import org.opensearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;

public abstract class Dimension
implements ToXContentObject,
Writeable {
    public static final String DIMENSION_SOURCE_FIELD_FIELD = "source_field";
    public static final String DIMENSION_TARGET_FIELD_FIELD = "target_field";
    private final Type type;
    private final String sourceField;
    private final String targetField;

    protected Dimension(Type type, String sourceField, String targetField) {
        this.type = type;
        this.sourceField = sourceField;
        this.targetField = targetField;
    }

    public Type getType() {
        return this.type;
    }

    public String getSourceField() {
        return this.sourceField;
    }

    public String getTargetField() {
        return this.targetField;
    }

    public abstract CompositeValuesSourceBuilder<?> toSourceBuilder(boolean var1);

    public abstract AbstractQueryBuilder<?> toBucketQuery(Object var1);

    public abstract boolean canBeRealizedInMappings(Map<String, Object> var1);

    public static Dimension parse(XContentParser xcp) throws IOException {
        Dimension dimension = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        block10: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "date_histogram": {
                    dimension = DateHistogram.parse(xcp);
                    continue block10;
                }
                case "terms": {
                    dimension = Terms.parse(xcp);
                    continue block10;
                }
                case "histogram": {
                    dimension = Histogram.parse(xcp);
                    continue block10;
                }
            }
            throw new IllegalArgumentException("Invalid dimension type [" + fieldName + "] found in dimensions");
        }
        if (dimension == null) {
            throw new IllegalArgumentException("Dimension cannot be null");
        }
        return dimension;
    }

    public static enum Type {
        DATE_HISTOGRAM("date_histogram"),
        TERMS("terms"),
        HISTOGRAM("histogram");

        private final String type;

        private Type(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public String toString() {
            return this.type;
        }
    }
}

