/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.common.model.dimension;

import io.lucenia.indexmanagement.common.model.dimension.Dimension;
import io.lucenia.indexmanagement.util.IndexUtils;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.index.query.AbstractQueryBuilder;
import io.skylite.core.index.query.RangeQueryBuilder;
import io.skylite.core.mapper.NumberFieldMapper;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.opensearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.opensearch.search.aggregations.bucket.composite.HistogramValuesSourceBuilder;
import org.opensearch.search.aggregations.bucket.histogram.HistogramAggregationBuilder;

public class Histogram
extends Dimension {
    public static final String HISTOGRAM_INTERVAL_FIELD = "interval";
    private static final double BUCKET_ERROR = 5.0E-5;
    private final double interval;

    public Histogram(String sourceField, String targetField, double interval) {
        super(Dimension.Type.HISTOGRAM, sourceField, targetField);
        if (sourceField == null || sourceField.isEmpty() || targetField == null || targetField.isEmpty()) {
            throw new IllegalArgumentException("Source and target field must not be empty");
        }
        if (interval <= 0.0) {
            throw new IllegalArgumentException("Interval must be a positive decimal");
        }
        this.interval = interval;
    }

    public Histogram(StreamInput sin) throws IOException {
        this(sin.readString(), sin.readString(), sin.readDouble());
    }

    public double getInterval() {
        return this.interval;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject(this.getType().getType());
        builder.field("source_field", this.getSourceField());
        builder.field("target_field", this.getTargetField());
        builder.field(HISTOGRAM_INTERVAL_FIELD, this.interval);
        builder.endObject();
        return builder.endObject();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.getSourceField());
        out.writeString(this.getTargetField());
        out.writeDouble(this.interval);
    }

    @Override
    public CompositeValuesSourceBuilder<?> toSourceBuilder(boolean appendType) {
        String name = appendType ? this.getTargetField() + "." + Dimension.Type.HISTOGRAM.getType() : this.getTargetField();
        return ((HistogramValuesSourceBuilder)((HistogramValuesSourceBuilder)new HistogramValuesSourceBuilder(name).missingBucket(true)).field(this.getSourceField())).interval(this.interval);
    }

    @Override
    public AbstractQueryBuilder<?> toBucketQuery(Object bucketKey) {
        if (!(bucketKey instanceof Double)) {
            throw new IllegalArgumentException("Received invalid histogram bucket key type [" + String.valueOf(bucketKey.getClass()) + "] when Double is expected.");
        }
        double bucketKeyDouble = (Double)bucketKey;
        return new RangeQueryBuilder(this.getSourceField()).from((Object)(bucketKeyDouble - 5.0E-5), true).to((Object)(bucketKeyDouble + this.interval + 5.0E-5), true);
    }

    @Override
    public boolean canBeRealizedInMappings(Map<String, Object> mappings) {
        Map<?, ?> fieldMapping = IndexUtils.getFieldFromMappings(this.getSourceField(), mappings);
        if (fieldMapping == null) {
            return false;
        }
        Object fieldType = fieldMapping.get("type");
        HashSet<String> numberTypes = new HashSet<String>();
        for (NumberFieldMapper.NumberType numberType : NumberFieldMapper.NumberType.values()) {
            numberTypes.add(numberType.typeName());
        }
        return numberTypes.contains(fieldType);
    }

    public HistogramAggregationBuilder getRewrittenAggregation(HistogramAggregationBuilder aggregationBuilder, AggregatorFactories.Builder subAggregations) {
        HistogramAggregationBuilder rewritten = new HistogramAggregationBuilder(aggregationBuilder.getName());
        rewritten.interval(aggregationBuilder.interval());
        if (Double.isFinite(aggregationBuilder.minBound()) && Double.isFinite(aggregationBuilder.maxBound())) {
            rewritten.extendedBounds(aggregationBuilder.minBound(), aggregationBuilder.maxBound());
        }
        rewritten.keyed(aggregationBuilder.keyed());
        if (aggregationBuilder.minDocCount() >= 0L) {
            rewritten.minDocCount(aggregationBuilder.minDocCount());
        }
        rewritten.offset(aggregationBuilder.offset());
        if (aggregationBuilder.order() != null) {
            rewritten.order(aggregationBuilder.order());
        }
        rewritten.field(this.getTargetField() + ".histogram");
        rewritten.subAggregations(subAggregations);
        return rewritten;
    }

    public static Histogram parse(XContentParser xcp) throws IOException {
        String sourceField = null;
        String targetField = null;
        Double interval = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        block10: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "source_field": {
                    sourceField = xcp.text();
                    continue block10;
                }
                case "target_field": {
                    targetField = xcp.text();
                    continue block10;
                }
                case "interval": {
                    interval = xcp.doubleValue();
                    continue block10;
                }
            }
            throw new IllegalArgumentException("Invalid field [" + fieldName + "] found in histogram dimension.");
        }
        if (targetField == null) {
            targetField = sourceField;
        }
        if (sourceField == null) {
            throw new IllegalArgumentException("Source field must not be null");
        }
        if (targetField == null) {
            throw new IllegalArgumentException("Target field must not be null");
        }
        if (interval == null) {
            throw new IllegalArgumentException("Interval field must not be null");
        }
        return new Histogram(sourceField, targetField, interval);
    }

    public static Histogram readFrom(StreamInput sin) throws IOException {
        return new Histogram(sin);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Histogram histogram = (Histogram)o;
        return Double.compare(histogram.interval, this.interval) == 0 && Objects.equals(this.getSourceField(), histogram.getSourceField()) && Objects.equals(this.getTargetField(), histogram.getTargetField());
    }

    public int hashCode() {
        return Objects.hash(this.getSourceField(), this.getTargetField(), this.interval);
    }
}

