/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.common.model.dimension;

import io.lucenia.indexmanagement.common.model.dimension.Dimension;
import io.lucenia.indexmanagement.util.IndexUtils;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.index.query.AbstractQueryBuilder;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.opensearch.index.query.TermsQueryBuilder;
import org.opensearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.opensearch.search.aggregations.bucket.composite.TermsValuesSourceBuilder;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregationBuilder;

public class Terms
extends Dimension {
    public Terms(String sourceField, String targetField) {
        super(Dimension.Type.TERMS, sourceField, targetField);
        if (sourceField == null || sourceField.isEmpty() || targetField == null || targetField.isEmpty()) {
            throw new IllegalArgumentException("Source and target field must not be empty");
        }
    }

    public Terms(StreamInput sin) throws IOException {
        this(sin.readString(), sin.readString());
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject(this.getType().getType());
        builder.field("source_field", this.getSourceField());
        builder.field("target_field", this.getTargetField());
        builder.endObject();
        return builder.endObject();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.getSourceField());
        out.writeString(this.getTargetField());
    }

    @Override
    public CompositeValuesSourceBuilder<?> toSourceBuilder(boolean appendType) {
        String name = appendType ? this.getTargetField() + "." + Dimension.Type.TERMS.getType() : this.getTargetField();
        return ((TermsValuesSourceBuilder)new TermsValuesSourceBuilder(name).missingBucket(true)).field(this.getSourceField());
    }

    @Override
    public AbstractQueryBuilder<?> toBucketQuery(Object bucketKey) {
        return new TermsQueryBuilder(this.getSourceField(), new Object[]{bucketKey});
    }

    @Override
    public boolean canBeRealizedInMappings(Map<String, Object> mappings) {
        Map<?, ?> fieldMapping = IndexUtils.getFieldFromMappings(this.getSourceField(), mappings);
        if (fieldMapping == null) {
            return false;
        }
        Object fieldType = fieldMapping.get("type");
        return !"text".equals(fieldType);
    }

    public TermsAggregationBuilder getRewrittenAggregation(TermsAggregationBuilder aggregationBuilder, AggregatorFactories.Builder subAggregations) {
        TermsAggregationBuilder rewritten = new TermsAggregationBuilder(aggregationBuilder.getName());
        if (aggregationBuilder.collectMode() != null) {
            rewritten.collectMode(aggregationBuilder.collectMode());
        }
        rewritten.executionHint(aggregationBuilder.executionHint());
        rewritten.includeExclude(aggregationBuilder.includeExclude());
        if (aggregationBuilder.minDocCount() >= 0L) {
            rewritten.minDocCount(aggregationBuilder.minDocCount());
        }
        if (aggregationBuilder.order() != null) {
            rewritten.order(aggregationBuilder.order());
        }
        if (aggregationBuilder.shardMinDocCount() >= 0L) {
            rewritten.shardMinDocCount(aggregationBuilder.shardMinDocCount());
        }
        if (aggregationBuilder.shardSize() > 0) {
            rewritten.shardSize(aggregationBuilder.shardSize());
        }
        rewritten.showTermDocCountError(aggregationBuilder.showTermDocCountError());
        if (aggregationBuilder.size() > 0) {
            rewritten.size(aggregationBuilder.size());
        }
        rewritten.field(this.getTargetField() + ".terms");
        rewritten.subAggregations(subAggregations);
        return rewritten;
    }

    public static Terms parse(XContentParser xcp) throws IOException {
        String sourceField = null;
        String targetField = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        block8: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "source_field": {
                    sourceField = xcp.text();
                    continue block8;
                }
                case "target_field": {
                    targetField = xcp.text();
                    continue block8;
                }
            }
            throw new IllegalArgumentException("Invalid field [" + fieldName + "] found in terms dimension.");
        }
        if (targetField == null) {
            targetField = sourceField;
        }
        if (sourceField == null) {
            throw new IllegalArgumentException("Source field cannot be null");
        }
        if (targetField == null) {
            throw new IllegalArgumentException("Target field cannot be null");
        }
        return new Terms(sourceField, targetField);
    }

    public static Terms readFrom(StreamInput sin) throws IOException {
        return new Terms(sin);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Terms terms = (Terms)o;
        return Objects.equals(this.getSourceField(), terms.getSourceField()) && Objects.equals(this.getTargetField(), terms.getTargetField());
    }

    public int hashCode() {
        return Objects.hash(this.getSourceField(), this.getTargetField());
    }
}

