/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.common.model.notification;

import io.lucenia.indexmanagement.common.model.notification.NotificationUtils;
import io.lucenia.indexmanagement.util.SecurityUtils;
import io.skylite.common.action.ActionListener;
import io.skylite.core.client.Client;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.notifications.NotificationsPluginInterface;
import io.skylite.core.notifications.action.SendNotificationResponse;
import io.skylite.core.notifications.model.ChannelMessage;
import io.skylite.core.notifications.model.EventSource;
import io.skylite.core.security.auth.User;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class Channel
implements ToXContent,
Writeable {
    public static final String ID = "id";
    private final String id;

    public Channel(String id) {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("Channel ID cannot be empty");
        }
        this.id = id;
    }

    public Channel(StreamInput sin) throws IOException {
        this(sin.readString());
    }

    public String getId() {
        return this.id;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ID, this.id);
        return builder.endObject();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
    }

    public static Channel parse(XContentParser xcp) throws IOException {
        String id = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            if (ID.equals(fieldName)) {
                id = xcp.text();
                continue;
            }
            throw new IllegalStateException("Unexpected field: " + fieldName + ", while parsing Channel destination");
        }
        if (id == null) {
            throw new IllegalArgumentException("Channel ID is null");
        }
        return new Channel(id);
    }

    public CompletableFuture<Void> sendNotification(Client client, EventSource eventSource, String message, User user) {
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        String channel = this.id;
        try (ThreadContext.StoredContext context = client.threadPool().getThreadContext().stashContext();){
            client.threadPool().getThreadContext().putTransient("_opendistro_security_user_info", (Object)SecurityUtils.generateUserString(user));
            NotificationsPluginInterface.sendNotification((NodeClient)((NodeClient)client), (EventSource)eventSource, (ChannelMessage)new ChannelMessage(message, null, null), Collections.singletonList(channel), (ActionListener)new ActionListener<SendNotificationResponse>(){

                public void onResponse(SendNotificationResponse response) {
                    try {
                        NotificationUtils.validateResponseStatus(response.getStatus(), response.getNotificationEvent().getEventSource().getReferenceId());
                        future.complete(null);
                    }
                    catch (Exception e) {
                        future.completeExceptionally(e);
                    }
                }

                public void onFailure(Exception e) {
                    future.completeExceptionally(e);
                }
            });
        }
        return future;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Channel channel = (Channel)o;
        return Objects.equals(this.id, channel.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

