/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.common.model.rest;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.search.sort.FieldSortBuilder;
import io.skylite.core.search.sort.SortBuilders;
import io.skylite.core.search.sort.SortOrder;
import java.io.IOException;
import java.util.Objects;

public class SearchParams
implements Writeable {
    public static final int DEFAULT_PAGINATION_SIZE = 20;
    public static final int DEFAULT_PAGINATION_FROM = 0;
    public static final String DEFAULT_SORT_ORDER = "asc";
    public static final String SORT_ORDER_DESC = "desc";
    public static final String DEFAULT_QUERY_STRING = "*";
    private final int size;
    private final int from;
    private final String sortField;
    private final String sortOrder;
    private final String queryString;

    public SearchParams(int size, int from, String sortField, String sortOrder, String queryString) {
        this.size = size;
        this.from = from;
        this.sortField = sortField;
        this.sortOrder = sortOrder;
        this.queryString = queryString;
    }

    public SearchParams(StreamInput sin) throws IOException {
        this.size = sin.readInt();
        this.from = sin.readInt();
        this.sortField = sin.readString();
        this.sortOrder = sin.readString();
        this.queryString = sin.readString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeInt(this.size);
        out.writeInt(this.from);
        out.writeString(this.sortField);
        out.writeString(this.sortOrder);
        out.writeString(this.queryString);
    }

    public FieldSortBuilder getSortBuilder() {
        return (FieldSortBuilder)SortBuilders.fieldSort((String)this.sortField).order(SortOrder.fromString((String)this.sortOrder));
    }

    public int getSize() {
        return this.size;
    }

    public int getFrom() {
        return this.from;
    }

    public String getSortField() {
        return this.sortField;
    }

    public String getSortOrder() {
        return this.sortOrder;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchParams that = (SearchParams)o;
        return this.size == that.size && this.from == that.from && Objects.equals(this.sortField, that.sortField) && Objects.equals(this.sortOrder, that.sortOrder) && Objects.equals(this.queryString, that.queryString);
    }

    public int hashCode() {
        return Objects.hash(this.size, this.from, this.sortField, this.sortOrder, this.queryString);
    }

    public String toString() {
        return "SearchParams{size=" + this.size + ", from=" + this.from + ", sortField='" + this.sortField + "', sortOrder='" + this.sortOrder + "', queryString='" + this.queryString + "'}";
    }
}

