/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.common.retry;

import io.skylite.SkyliteException;
import io.skylite.common.action.ActionListener;
import io.skylite.common.unit.TimeValue;
import io.skylite.common.util.concurrent.SkyliteRejectedExecutionException;
import io.skylite.core.action.bulk.BackoffPolicy;
import io.skylite.core.rest.RestStatus;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.logging.log4j.Logger;

public final class RetryUtils {
    private RetryUtils() {
    }

    public static <T> void retry(Logger logger, BackoffPolicy backoffPolicy, Consumer<ActionListener<T>> operation, ActionListener<T> listener) {
        Iterator backoffIterator = backoffPolicy.iterator();
        RetryUtils.retryWithIterator(logger, backoffIterator, operation, listener);
    }

    private static <T> void retryWithIterator(final Logger logger, final Iterator<TimeValue> backoffIterator, final Consumer<ActionListener<T>> operation, final ActionListener<T> listener) {
        ActionListener retryListener = new ActionListener<T>(){

            public void onResponse(T response) {
                listener.onResponse(response);
            }

            public void onFailure(Exception e) {
                boolean shouldRetry = false;
                TimeValue backoff = null;
                if (e instanceof SkyliteException) {
                    SkyliteException osException = (SkyliteException)e;
                    if (backoffIterator.hasNext() && RetryUtils.isRetryable(osException)) {
                        shouldRetry = true;
                        backoff = (TimeValue)backoffIterator.next();
                        logger.warn("Operation failed. Retrying in " + String.valueOf(backoff) + ".", (Throwable)e);
                    }
                } else if (e instanceof SkyliteRejectedExecutionException && backoffIterator.hasNext()) {
                    shouldRetry = true;
                    backoff = (TimeValue)backoffIterator.next();
                    logger.warn("Rejected execution. Retrying in " + String.valueOf(backoff) + ".", (Throwable)e);
                }
                if (shouldRetry && backoff != null) {
                    TimeValue finalBackoff = backoff;
                    new Thread(() -> {
                        try {
                            TimeUnit.MILLISECONDS.sleep(finalBackoff.millis());
                            RetryUtils.retryWithIterator(logger, backoffIterator, operation, listener);
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                            listener.onFailure((Exception)new RuntimeException("Retry interrupted", ie));
                        }
                    }).start();
                } else {
                    listener.onFailure(e);
                }
            }
        };
        try {
            operation.accept(retryListener);
        }
        catch (Exception e) {
            retryListener.onFailure(e);
        }
    }

    /*
     * Loose catch block
     */
    public static <T> T retry(Logger logger, BackoffPolicy backoffPolicy, SupplierWithException<T> operation) throws Exception {
        Iterator backoffIterator = backoffPolicy.iterator();
        Throwable lastException = null;
        while (true) {
            TimeValue backoff;
            try {
                return operation.get();
            }
            catch (SkyliteException e) {
                lastException = e;
                if (backoffIterator.hasNext() && RetryUtils.isRetryable(e)) {
                    backoff = (TimeValue)backoffIterator.next();
                    logger.warn("Operation failed. Retrying in " + String.valueOf(backoff) + ".", (Throwable)e);
                    try {
                        TimeUnit.MILLISECONDS.sleep(backoff.millis());
                        continue;
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException("Retry interrupted", ie);
                    }
                }
                throw e;
            }
            catch (SkyliteRejectedExecutionException e) {
                lastException = e;
                if (backoffIterator.hasNext()) {
                    backoff = (TimeValue)backoffIterator.next();
                    logger.warn("Rejected execution. Retrying in " + String.valueOf(backoff) + ".", (Throwable)e);
                    try {
                        TimeUnit.MILLISECONDS.sleep(backoff.millis());
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException("Retry interrupted", ie);
                    }
                    continue;
                }
                throw e;
            }
            break;
        }
        catch (Exception e) {
            throw e;
        }
    }

    public static boolean isRetryable(SkyliteException e) {
        RestStatus status = e.status();
        return status == RestStatus.BAD_GATEWAY || status == RestStatus.SERVICE_UNAVAILABLE || status == RestStatus.GATEWAY_TIMEOUT;
    }

    @FunctionalInterface
    public static interface SupplierWithException<T> {
        public T get() throws Exception;
    }
}

