/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.controlcenter.notification;

import io.lucenia.indexmanagement.util.IndexUtils;
import io.skylite.ResourceAlreadyExistsException;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.admin.indices.create.CreateIndexRequest;
import io.skylite.core.action.admin.indices.create.CreateIndexResponse;
import io.skylite.core.action.clustermanager.AcknowledgedResponse;
import io.skylite.core.client.IndicesAdminClient;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.settings.Settings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;

public class ControlCenterIndices {
    private static final String CONTROL_CENTER_MAPPINGS;
    private final IndicesAdminClient client;
    private final ClusterService clusterService;

    public ControlCenterIndices(IndicesAdminClient client, ClusterService clusterService) {
        this.client = client;
        this.clusterService = clusterService;
    }

    public void checkAndUpdateControlCenterIndex(final ActionListener<AcknowledgedResponse> actionListener) throws IOException {
        if (!this.controlCenterIndexExists()) {
            CreateIndexRequest indexRequest = new CreateIndexRequest(".opensearch-control-center").mapping(CONTROL_CENTER_MAPPINGS).settings(Settings.builder().put("index.hidden", true).build());
            this.client.create(indexRequest, (ActionListener)new ActionListener<CreateIndexResponse>(){

                public void onResponse(CreateIndexResponse response) {
                    actionListener.onResponse((Object)response);
                }

                public void onFailure(Exception e) {
                    if (SkyliteExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceAlreadyExistsException) {
                        actionListener.onResponse((Object)new CreateIndexResponse(true, true, ".opensearch-control-center"));
                    } else {
                        actionListener.onFailure(e);
                    }
                }
            });
        } else {
            IndexUtils.checkAndUpdateIndexMapping(".opensearch-control-center", IndexUtils.getSchemaVersion(CONTROL_CENTER_MAPPINGS), CONTROL_CENTER_MAPPINGS, this.clusterService.state(), this.client, actionListener);
        }
    }

    private boolean controlCenterIndexExists() {
        return this.clusterService.state().routingTable().hasIndex(".opensearch-control-center");
    }

    public static String getControlCenterMappings() {
        return CONTROL_CENTER_MAPPINGS;
    }

    static {
        try (InputStream is = ControlCenterIndices.class.getClassLoader().getResourceAsStream("mappings/opensearch-control-center.json");){
            if (is == null) {
                throw new IllegalStateException("Cannot find control center mappings resource");
            }
            CONTROL_CENTER_MAPPINGS = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load control center mappings", e);
        }
    }
}

