/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.controlcenter.notification.action.delete;

import io.lucenia.indexmanagement.controlcenter.notification.action.delete.DeleteLRONConfigRequest;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.WriteRequest;
import io.skylite.core.action.delete.DeleteRequest;
import io.skylite.core.action.delete.DeleteResponse;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransportDeleteLRONConfigAction
extends HandledTransportAction<DeleteLRONConfigRequest, DeleteResponse> {
    private final Logger log = LogManager.getLogger(TransportDeleteLRONConfigAction.class);
    private final NodeClient client;

    @Inject
    public TransportDeleteLRONConfigAction(NodeClient client, TransportService transportService, ActionFilters actionFilters) {
        super("cluster:admin/lucenia/controlcenter/lron/delete", transportService, actionFilters, DeleteLRONConfigRequest::new);
        this.client = client;
    }

    protected void doExecute(Task task, DeleteLRONConfigRequest request, ActionListener<DeleteResponse> listener) {
        new DeleteLRONConfigHandler(this.client, listener, request).start();
    }

    class DeleteLRONConfigHandler {
        private final NodeClient client;
        private final ActionListener<DeleteResponse> actionListener;
        private final DeleteLRONConfigRequest request;
        private final String docId;

        DeleteLRONConfigHandler(NodeClient client, ActionListener<DeleteResponse> actionListener, DeleteLRONConfigRequest request) {
            this.client = client;
            this.actionListener = actionListener;
            this.request = request;
            this.docId = request.getDocId();
        }

        void start() {
            TransportDeleteLRONConfigAction.this.log.debug("User and roles string from thread context: {}", this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info"));
            try (ThreadContext.StoredContext ignored = this.client.threadPool().getThreadContext().stashContext();){
                DeleteRequest deleteRequest = (DeleteRequest)new DeleteRequest(".opensearch-control-center", this.docId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                this.client.delete(deleteRequest, this.actionListener);
            }
        }
    }
}

