/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.controlcenter.notification.action.get;

import io.lucenia.indexmanagement.common.model.rest.SearchParams;
import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.common.action.ValidateActions;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import java.io.IOException;

public class GetLRONConfigRequest
extends ActionRequest {
    private final String docId;
    private final SearchParams searchParams;

    public GetLRONConfigRequest(String docId, SearchParams searchParams) {
        this.docId = docId;
        this.searchParams = searchParams;
    }

    public GetLRONConfigRequest(StreamInput sin) throws IOException {
        this(sin.readOptionalString(), (SearchParams)sin.readOptionalWriteable(SearchParams::new));
    }

    public String getDocId() {
        return this.docId;
    }

    public SearchParams getSearchParams() {
        return this.searchParams;
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.docId == null && this.searchParams == null) {
            validationException = ValidateActions.addValidationError((String)"GetLRONConfigRequest must contain docId or searchParams", validationException);
        }
        if (this.docId != null && this.searchParams != null) {
            validationException = ValidateActions.addValidationError((String)"Get LRONConfig requires either docId or searchParams to be specified", (ActionRequestValidationException)validationException);
        }
        if (this.docId != null && !this.docId.startsWith("LRON:")) {
            validationException = ValidateActions.addValidationError((String)"Invalid LRONConfig ID", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.docId);
        out.writeOptionalWriteable((Writeable)this.searchParams);
    }
}

