/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.controlcenter.notification.action.get;

import io.lucenia.indexmanagement.common.model.rest.SearchParams;
import io.lucenia.indexmanagement.controlcenter.notification.LRONConfigResponse;
import io.lucenia.indexmanagement.controlcenter.notification.action.get.GetLRONConfigRequest;
import io.lucenia.indexmanagement.controlcenter.notification.action.get.GetLRONConfigResponse;
import io.lucenia.indexmanagement.controlcenter.notification.model.LRONConfig;
import io.lucenia.indexmanagement.controlcenter.notification.util.LRONUtils;
import io.lucenia.indexmanagement.luceniaapi.LuceniaExtensions;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.cluster.routing.Preference;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.search.SearchHit;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.core.search.sort.BaseSortBuilder;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContentHelper;
import io.skylite.core.xcontent.XContentParser;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.index.query.QueryBuilders;

public class TransportGetLRONConfigAction
extends HandledTransportAction<GetLRONConfigRequest, GetLRONConfigResponse> {
    private final Logger log = LogManager.getLogger(TransportGetLRONConfigAction.class);
    private final NodeClient client;
    private final NamedXContentRegistry xContentRegistry;

    @Inject
    public TransportGetLRONConfigAction(NodeClient client, TransportService transportService, ActionFilters actionFilters, NamedXContentRegistry xContentRegistry) {
        super("cluster:admin/lucenia/controlcenter/lron/get", transportService, actionFilters, GetLRONConfigRequest::new);
        this.client = client;
        this.xContentRegistry = xContentRegistry;
    }

    protected void doExecute(Task task, GetLRONConfigRequest request, ActionListener<GetLRONConfigResponse> listener) {
        new GetLRONConfigHandler(this.client, listener, request).start();
    }

    class GetLRONConfigHandler {
        private final NodeClient client;
        private final ActionListener<GetLRONConfigResponse> actionListener;
        private final GetLRONConfigRequest request;

        GetLRONConfigHandler(NodeClient client, ActionListener<GetLRONConfigResponse> actionListener, GetLRONConfigRequest request) {
            this.client = client;
            this.actionListener = actionListener;
            this.request = request;
        }

        void start() {
            TransportGetLRONConfigAction.this.log.debug("User and roles string from thread context: {}", this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info"));
            try (ThreadContext.StoredContext ignored = this.client.threadPool().getThreadContext().stashContext();){
                if (this.request.getDocId() != null) {
                    LRONUtils.getLRONConfigAndParse(this.client, this.request.getDocId(), TransportGetLRONConfigAction.this.xContentRegistry, new ActionListener<LRONConfigResponse>(){

                        public void onResponse(LRONConfigResponse response) {
                            GetLRONConfigHandler.this.actionListener.onResponse((Object)new GetLRONConfigResponse(List.of(response), 1));
                        }

                        public void onFailure(Exception e) {
                            GetLRONConfigHandler.this.actionListener.onFailure((Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)e));
                        }
                    });
                } else {
                    this.doSearch();
                }
            }
        }

        private void doSearch() {
            SearchParams params = this.request.getSearchParams();
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.existsQuery((String)"lron_config")).must((QueryBuilder)QueryBuilders.queryStringQuery((String)params.getQueryString()))).sort((BaseSortBuilder)params.getSortBuilder()).from(params.getFrom()).size(params.getSize());
            SearchRequest searchRequest = new SearchRequest().source(searchSourceBuilder).indices(new String[]{".opensearch-control-center"}).preference(Preference.PRIMARY_FIRST.type());
            this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

                public void onResponse(SearchResponse response) {
                    long totalNumber = response.getHits().getTotalHits() != null ? response.getHits().getTotalHits().value() : 0L;
                    ArrayList<LRONConfigResponse> lronConfigResponses = new ArrayList<LRONConfigResponse>();
                    for (SearchHit hit : response.getHits().getHits()) {
                        try {
                            XContentParser xcp = XContentHelper.createParser((NamedXContentRegistry)TransportGetLRONConfigAction.this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)hit.getSourceRef(), (MediaType)MediaTypeRegistry.JSON);
                            LRONConfig lronConfig = LuceniaExtensions.parseWithType(xcp, hit.getId(), hit.getSeqNo(), hit.getPrimaryTerm(), LRONConfig::parse);
                            lronConfigResponses.add(new LRONConfigResponse(hit.getId(), lronConfig));
                        }
                        catch (Exception e) {
                            TransportGetLRONConfigAction.this.log.error("Failed to parse LRONConfig", (Throwable)e);
                        }
                    }
                    GetLRONConfigHandler.this.actionListener.onResponse((Object)new GetLRONConfigResponse(lronConfigResponses, (int)totalNumber));
                }

                public void onFailure(Exception e) {
                    if (e instanceof IndexNotFoundException) {
                        GetLRONConfigHandler.this.actionListener.onResponse((Object)new GetLRONConfigResponse(List.of(), 0));
                        return;
                    }
                    GetLRONConfigHandler.this.actionListener.onFailure((Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)e));
                }
            });
        }
    }
}

