/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.controlcenter.notification.action.index;

import io.lucenia.indexmanagement.controlcenter.notification.ControlCenterIndices;
import io.lucenia.indexmanagement.controlcenter.notification.LRONConfigResponse;
import io.lucenia.indexmanagement.controlcenter.notification.action.index.IndexLRONConfigRequest;
import io.lucenia.indexmanagement.controlcenter.notification.model.LRONConfig;
import io.lucenia.indexmanagement.controlcenter.notification.util.LRONUtils;
import io.lucenia.indexmanagement.util.SecurityUtils;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.common.xcontent.XContentFactory;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.DocWriteRequest;
import io.skylite.core.action.WriteRequest;
import io.skylite.core.action.clustermanager.AcknowledgedResponse;
import io.skylite.core.action.index.IndexRequest;
import io.skylite.core.action.index.IndexResponse;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.security.auth.User;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.NamedXContentRegistry;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransportIndexLRONConfigAction
extends HandledTransportAction<IndexLRONConfigRequest, LRONConfigResponse> {
    private final Logger log = LogManager.getLogger(TransportIndexLRONConfigAction.class);
    private final NodeClient client;
    private final ClusterService clusterService;
    private final ControlCenterIndices controlCenterIndices;
    private final NamedXContentRegistry xContentRegistry;

    @Inject
    public TransportIndexLRONConfigAction(NodeClient client, TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, ControlCenterIndices controlCenterIndices, NamedXContentRegistry xContentRegistry) {
        super("cluster:admin/lucenia/controlcenter/lron/write", transportService, actionFilters, IndexLRONConfigRequest::new);
        this.client = client;
        this.clusterService = clusterService;
        this.controlCenterIndices = controlCenterIndices;
        this.xContentRegistry = xContentRegistry;
    }

    protected void doExecute(Task task, IndexLRONConfigRequest request, ActionListener<LRONConfigResponse> listener) {
        try {
            new IndexLRONConfigHandler(this.client, listener, request).start();
        }
        catch (IOException e) {
            listener.onFailure((Exception)e);
        }
    }

    class IndexLRONConfigHandler {
        private final NodeClient client;
        private final ActionListener<LRONConfigResponse> actionListener;
        private final IndexLRONConfigRequest request;
        private final User user;
        private final String docId;

        IndexLRONConfigHandler(NodeClient client, ActionListener<LRONConfigResponse> actionListener, IndexLRONConfigRequest request) {
            this.client = client;
            this.actionListener = actionListener;
            this.request = request;
            this.user = SecurityUtils.buildUser(client.threadPool().getThreadContext());
            this.docId = LRONUtils.getDocID(request.getLronConfig().getTaskId(), request.getLronConfig().getActionName());
        }

        void start() throws IOException {
            TransportIndexLRONConfigAction.this.log.debug("User and roles string from thread context: {}", this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info"));
            try (ThreadContext.StoredContext ignored = this.client.threadPool().getThreadContext().stashContext();){
                if (this.request.isDryRun()) {
                    this.validate();
                    return;
                }
                TransportIndexLRONConfigAction.this.controlCenterIndices.checkAndUpdateControlCenterIndex((ActionListener<AcknowledgedResponse>)ActionListener.wrap(this::onCreateMappingsResponse, arg_0 -> this.actionListener.onFailure(arg_0)));
            }
        }

        private void onCreateMappingsResponse(AcknowledgedResponse response) {
            if (response.isAcknowledged()) {
                TransportIndexLRONConfigAction.this.log.info("Successfully created or updated {} with newest mappings.", (Object)".opensearch-control-center");
                this.validate();
            } else {
                String message = "Unable to create or update .opensearch-control-center with newest mapping.";
                TransportIndexLRONConfigAction.this.log.error(message);
                this.actionListener.onFailure((Exception)new SkyliteStatusException(message, RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
            }
        }

        private void validate() {
            if (this.request.getLronConfig().getTaskId() != null && TransportIndexLRONConfigAction.this.clusterService.state().nodes().get(this.request.getLronConfig().getTaskId().getNodeId()) == null) {
                this.actionListener.onFailure((Exception)new IllegalArgumentException("Illegal taskID. NodeID not exists."));
                return;
            }
            this.putLRONConfig();
        }

        private void putLRONConfig() {
            final LRONConfig lronConfig = new LRONConfig.Builder(this.request.getLronConfig()).user(this.user).priority(LRONUtils.getPriority(this.request.getLronConfig().getTaskId(), this.request.getLronConfig().getActionName())).build();
            if (this.request.isDryRun()) {
                this.actionListener.onResponse((Object)new LRONConfigResponse(this.docId, lronConfig));
                return;
            }
            try {
                IndexRequest indexRequest = (IndexRequest)((IndexRequest)new IndexRequest(".opensearch-control-center").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(lronConfig.toXContent(XContentFactory.jsonBuilder(), null)).id(this.docId).timeout(IndexRequest.DEFAULT_TIMEOUT);
                if (!this.request.isUpdate()) {
                    indexRequest.opType(DocWriteRequest.OpType.CREATE);
                }
                this.client.index(indexRequest, (ActionListener)new ActionListener<IndexResponse>(){

                    public void onResponse(IndexResponse response) {
                        if (response.getShardInfo().getFailed() > 0) {
                            StringBuilder failureReasons = new StringBuilder();
                            for (int i = 0; i < response.getShardInfo().getFailures().length; ++i) {
                                if (i > 0) {
                                    failureReasons.append(",");
                                }
                                failureReasons.append(response.getShardInfo().getFailures()[i].reason());
                            }
                            IndexLRONConfigHandler.this.actionListener.onFailure((Exception)new SkyliteStatusException(failureReasons.toString(), response.status(), new Object[0]));
                        } else {
                            IndexLRONConfigHandler.this.actionListener.onResponse((Object)new LRONConfigResponse(response.getId(), lronConfig));
                        }
                    }

                    public void onFailure(Exception e) {
                        IndexLRONConfigHandler.this.actionListener.onFailure((Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)e));
                    }
                });
            }
            catch (Exception e) {
                this.actionListener.onFailure(e);
            }
        }
    }
}

