/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.controlcenter.notification.filter;

import io.lucenia.indexmanagement.controlcenter.notification.filter.NotificationActionListener;
import io.lucenia.indexmanagement.controlcenter.notification.util.LRONUtils;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilter;
import io.skylite.core.action.ActionFilterChain;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.support.ActiveShardsObserver;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.tasks.Task;
import io.skylite.core.tasks.TaskId;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IndexOperationActionFilter
implements ActionFilter {
    private final Logger logger = LogManager.getLogger(IndexOperationActionFilter.class);
    private final Client client;
    private final ClusterService clusterService;
    private final ActiveShardsObserver activeShardsObserver;
    private final IndexNameExpressionResolver indexNameExpressionResolver;

    public IndexOperationActionFilter(Client client, ClusterService clusterService, ActiveShardsObserver activeShardsObserver, IndexNameExpressionResolver indexNameExpressionResolver) {
        this.client = client;
        this.clusterService = clusterService;
        this.activeShardsObserver = activeShardsObserver;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
    }

    public int order() {
        return Integer.MAX_VALUE;
    }

    public <Request extends ActionRequest, Response extends ActionResponse> void apply(Task task, String action, Request request, ActionListener<Response> listener, ActionFilterChain<Request, Response> chain) {
        chain.proceed(task, action, request, this.wrapActionListener(task, action, request, listener));
    }

    public <Request extends ActionRequest, Response extends ActionResponse> ActionListener<Response> wrapActionListener(Task task, String action, Request request, ActionListener<Response> listener) {
        ActionListener<Response> wrappedListener = listener;
        if (LRONUtils.getSupportedActions().contains(action) && !task.getParentTaskId().isSet()) {
            TaskId taskId = new TaskId(this.clusterService.localNode().getId(), task.getId());
            this.logger.info("Add notification action listener for tasks: {} and action: {}", (Object)taskId.toString(), (Object)action);
            wrappedListener = new NotificationActionListener<Request, Response>(listener, this.client, this.clusterService, action, task, this.activeShardsObserver, request, this.indexNameExpressionResolver);
        }
        return wrappedListener;
    }
}

