/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.controlcenter.notification.filter;

import io.lucenia.indexmanagement.common.model.notification.Channel;
import io.lucenia.indexmanagement.common.model.rest.SearchParams;
import io.lucenia.indexmanagement.controlcenter.notification.LRONConfigResponse;
import io.lucenia.indexmanagement.controlcenter.notification.action.delete.DeleteLRONConfigAction;
import io.lucenia.indexmanagement.controlcenter.notification.action.delete.DeleteLRONConfigRequest;
import io.lucenia.indexmanagement.controlcenter.notification.action.get.GetLRONConfigAction;
import io.lucenia.indexmanagement.controlcenter.notification.action.get.GetLRONConfigRequest;
import io.lucenia.indexmanagement.controlcenter.notification.action.get.GetLRONConfigResponse;
import io.lucenia.indexmanagement.controlcenter.notification.filter.OperationResult;
import io.lucenia.indexmanagement.controlcenter.notification.filter.parser.ActionRespParseResult;
import io.lucenia.indexmanagement.controlcenter.notification.filter.parser.ForceMergeIndexRespParser;
import io.lucenia.indexmanagement.controlcenter.notification.filter.parser.OpenIndexRespParser;
import io.lucenia.indexmanagement.controlcenter.notification.filter.parser.ReindexRespParser;
import io.lucenia.indexmanagement.controlcenter.notification.filter.parser.ResizeIndexRespParser;
import io.lucenia.indexmanagement.controlcenter.notification.model.LRONCondition;
import io.lucenia.indexmanagement.controlcenter.notification.model.LRONConfig;
import io.lucenia.indexmanagement.controlcenter.notification.util.LRONUtils;
import io.lucenia.indexmanagement.luceniaapi.LuceniaExtensions;
import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.DocWriteResponse;
import io.skylite.core.action.admin.indices.forcemerge.ForceMergeRequest;
import io.skylite.core.action.admin.indices.forcemerge.ForceMergeResponse;
import io.skylite.core.action.admin.indices.open.OpenIndexRequest;
import io.skylite.core.action.admin.indices.open.OpenIndexResponse;
import io.skylite.core.action.admin.indices.shrink.ResizeRequest;
import io.skylite.core.action.admin.indices.shrink.ResizeResponse;
import io.skylite.core.action.bulk.BackoffPolicy;
import io.skylite.core.action.delete.DeleteResponse;
import io.skylite.core.action.support.ActiveShardsObserver;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.notifications.model.EventSource;
import io.skylite.core.notifications.model.SeverityType;
import io.skylite.core.tasks.Task;
import io.skylite.core.tasks.TaskId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.index.reindex.BulkByScrollResponse;
import org.opensearch.index.reindex.ReindexRequest;

public class NotificationActionListener<Request extends ActionRequest, Response extends ActionResponse>
implements ActionListener<Response> {
    public static final TimeValue MAX_WAIT_TIME = TimeValue.timeValueHours((long)1L);
    public static final String COMPLETED = "has been completed.";
    public static final String FAILED = "has failed.";
    public static final TimeValue DELAY = TimeValue.timeValueSeconds((long)5L);
    private final Logger logger = LogManager.getLogger(NotificationActionListener.class);
    private final ActionListener<Response> delegate;
    private final Client client;
    private final ClusterService clusterService;
    private final String action;
    private final Task task;
    private final ActiveShardsObserver activeShardsObserver;
    private final Request request;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final BackoffPolicy notificationRetryPolicy;

    public NotificationActionListener(ActionListener<Response> delegate, Client client, ClusterService clusterService, String action, Task task, ActiveShardsObserver activeShardsObserver, Request request, IndexNameExpressionResolver indexNameExpressionResolver) {
        this.delegate = delegate;
        this.client = client;
        this.clusterService = clusterService;
        this.action = action;
        this.task = task;
        this.activeShardsObserver = activeShardsObserver;
        this.request = request;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.notificationRetryPolicy = BackoffPolicy.exponentialBackoff((TimeValue)TimeValue.timeValueMillis((long)1000L), (int)3);
    }

    public void onResponse(Response response) {
        try {
            this.delegate.onResponse(response);
        }
        catch (Exception e) {
            this.delegate.onFailure(e);
        }
        finally {
            this.parseAndSendNotification((ActionResponse)response, null);
        }
    }

    public void onFailure(Exception e) {
        try {
            this.delegate.onFailure(e);
        }
        finally {
            this.parseAndSendNotification(null, e);
        }
    }

    public void parseAndSendNotification(ActionResponse response, Exception ex) {
        try {
            this.logger.debug("sending out notifications for action {}", (Object)this.action);
            Consumer<ActionRespParseResult> callback = result -> this.client.threadPool().schedule(() -> this.notify(this.action, (ActionRespParseResult)result), DELAY, "generic");
            switch (this.action) {
                case "indices:admin/resize": {
                    new ResizeIndexRespParser(this.activeShardsObserver, (ResizeRequest)this.request, this.clusterService).parseAndSendNotification(response == null ? null : (ResizeResponse)response, ex, callback);
                    break;
                }
                case "indices:data/write/reindex": {
                    new ReindexRespParser(this.task, (ReindexRequest)this.request, this.clusterService).parseAndSendNotification(response == null ? null : (BulkByScrollResponse)response, ex, callback);
                    break;
                }
                case "indices:admin/open": {
                    new OpenIndexRespParser(this.activeShardsObserver, (OpenIndexRequest)this.request, this.indexNameExpressionResolver, this.clusterService).parseAndSendNotification(response == null ? null : (OpenIndexResponse)response, ex, callback);
                    break;
                }
                case "indices:admin/forcemerge": {
                    new ForceMergeIndexRespParser((ForceMergeRequest)this.request, this.clusterService).parseAndSendNotification(response == null ? null : (ForceMergeResponse)response, ex, callback);
                    break;
                }
                default: {
                    this.logger.debug("Action: {} is not supported for notification!", (Object)this.action);
                    break;
                }
            }
        }
        catch (Throwable e) {
            this.logger.info("Sending out notification for action: {} failed {}", (Object)this.action, (Object)e);
        }
    }

    public void notify(final String action, final ActionRespParseResult result) {
        final TaskId taskId = new TaskId(this.clusterService.localNode().getId(), this.task.getId());
        String[] ids = new String[]{LRONUtils.getDocID(taskId, null), LRONUtils.getDocID(null, action)};
        String queryString = "_id:(" + String.join((CharSequence)" OR ", Arrays.stream(ids).map(this::escapeQueryString).collect(Collectors.toList())) + ")";
        SearchParams searchParam = new SearchParams(20, 0, "lron_config.priority", "desc", queryString);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.client.execute((ActionType)GetLRONConfigAction.INSTANCE, (ActionRequest)new GetLRONConfigRequest(null, searchParam), (ActionListener)new ActionListener<GetLRONConfigResponse>(){

                public void onResponse(GetLRONConfigResponse lronConfigResponse) {
                    NotificationActionListener.this.sendNotification(lronConfigResponse, taskId, action, result);
                }

                public void onFailure(Exception e) {
                    if (e instanceof IndexNotFoundException) {
                        NotificationActionListener.this.logger.debug("No notification policy configured for task: {} action: {}", (Object)taskId.toString(), (Object)action);
                    } else {
                        NotificationActionListener.this.logger.error("Can't get notification policy for action: {} {}", (Object)action, (Object)e);
                    }
                }
            });
        }
    }

    private void sendNotification(GetLRONConfigResponse lronConfigResponse, TaskId taskId, String action, ActionRespParseResult result) {
        if (lronConfigResponse.getTotalNumber() == 0) {
            this.logger.debug("No notification policy configured for task: {} action: {}", (Object)taskId.toString(), (Object)action);
            return;
        }
        Set<LRONConfigResponse> policies = this.getNotificationPolices(lronConfigResponse, result.getOperationResult());
        EventSource eventSource = new EventSource(result.getTitle(), taskId.toString(), SeverityType.INFO, null);
        HashSet<String> channelSent = new HashSet<String>();
        for (LRONConfigResponse policy : policies) {
            LRONConfig config = policy.getLronConfig();
            if (!config.getLronCondition().isEnabled() || config.getChannels() == null) continue;
            for (Channel channel : config.getChannels()) {
                try {
                    if (channelSent.contains(channel.getId())) continue;
                    LuceniaExtensions.retry(this.notificationRetryPolicy, this.logger, Collections.emptyList(), backoff -> {
                        channel.sendNotification(this.client, eventSource, result.getMessage(), config.getUser());
                        return null;
                    });
                    channelSent.add(channel.getId());
                }
                catch (SkyliteStatusException osse) {
                    this.logger.warn("Sending notification failed, restStatus {} {}", (Object)osse.status(), (Object)osse);
                }
                catch (Exception e) {
                    this.logger.error("Sending notification failed", (Throwable)e);
                }
            }
        }
        lronConfigResponse.getLronConfigResponses().stream().filter(r -> r.getLronConfig().getTaskId() != null).findFirst().ifPresent(r -> this.removeOneTimePolicy(r.getLronConfig()));
    }

    public void removeOneTimePolicy(LRONConfig config) {
        if (config.getTaskId() != null) {
            final TaskId taskId = config.getTaskId();
            this.client.execute((ActionType)DeleteLRONConfigAction.INSTANCE, (ActionRequest)new DeleteLRONConfigRequest(LRONUtils.getDocID(taskId, null)), (ActionListener)new ActionListener<DeleteResponse>(){

                public void onResponse(DeleteResponse response) {
                    if (response.getResult() == DocWriteResponse.Result.DELETED) {
                        NotificationActionListener.this.logger.info("One time notification policy for task: {} has been removed", (Object)taskId);
                    }
                }

                public void onFailure(Exception e) {
                    NotificationActionListener.this.logger.info("Remove one time notification policy failed", (Throwable)e);
                }
            });
        }
    }

    public Set<LRONConfigResponse> getNotificationPolices(GetLRONConfigResponse lronConfigResponse, OperationResult result) {
        LRONConfigResponse runtimeConfig = lronConfigResponse.getLronConfigResponses().stream().filter(r -> r.getLronConfig().getTaskId() != null).findFirst().orElse(null);
        LRONConfigResponse defaultConfig = lronConfigResponse.getLronConfigResponses().stream().filter(r -> r.getLronConfig().getActionName() != null && r.getLronConfig().getTaskId() == null).findFirst().orElse(lronConfigResponse.getLronConfigResponses().stream().filter(r -> r.getLronConfig().getActionName() == null && r.getLronConfig().getTaskId() == null).findFirst().orElse(null));
        ArrayList<LRONConfigResponse> channels = new ArrayList<LRONConfigResponse>();
        if (runtimeConfig != null) {
            channels.add(runtimeConfig);
        }
        if (defaultConfig != null) {
            channels.add(defaultConfig);
        }
        return channels.stream().filter(ch -> {
            LRONCondition condition = ch.getLronConfig().getLronCondition();
            return condition.getSuccess() && result == OperationResult.COMPLETE || condition.getFailure() && result != OperationResult.COMPLETE;
        }).collect(Collectors.toSet());
    }

    public String escapeQueryString(String query) {
        return query.replace("/", "\\/").replace(":", "\\:");
    }
}

