/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.controlcenter.notification.filter.parser;

import io.lucenia.indexmanagement.controlcenter.notification.filter.OperationResult;
import io.lucenia.indexmanagement.controlcenter.notification.filter.parser.ActionRespParseResult;
import io.lucenia.indexmanagement.controlcenter.notification.filter.parser.ResponseParser;
import io.skylite.SkyliteException;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.admin.indices.forcemerge.ForceMergeRequest;
import io.skylite.core.action.admin.indices.forcemerge.ForceMergeResponse;
import io.skylite.core.cluster.service.ClusterService;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class ForceMergeIndexRespParser
implements ResponseParser<ForceMergeResponse> {
    private final ForceMergeRequest request;
    private final ClusterService clusterService;
    private final String indexNameWithCluster;

    public ForceMergeIndexRespParser(ForceMergeRequest request, ClusterService clusterService) {
        this.request = request;
        this.clusterService = clusterService;
        this.indexNameWithCluster = this.getIndexName((ActionRequest)request, clusterService);
    }

    @Override
    public void parseAndSendNotification(ForceMergeResponse response, Exception ex, Consumer<ActionRespParseResult> callback) {
        boolean hasFailures;
        if (ex != null) {
            callback.accept(new ActionRespParseResult(OperationResult.FAILED, this.buildNotificationMessage((ForceMergeResponse)null, ex, false), this.buildNotificationTitle(OperationResult.FAILED)));
            return;
        }
        if (response == null) {
            throw new IllegalArgumentException("ForceMergeResponse must not be null");
        }
        boolean bl = hasFailures = response.getShardFailures() != null && response.getShardFailures().length > 0;
        if (hasFailures) {
            callback.accept(new ActionRespParseResult(OperationResult.FAILED, this.buildNotificationMessage(response, (Exception)null, false), this.buildNotificationTitle(OperationResult.FAILED)));
        } else {
            callback.accept(new ActionRespParseResult(OperationResult.COMPLETE, this.buildNotificationMessage(response, (Exception)null, false), this.buildNotificationTitle(OperationResult.COMPLETE)));
        }
    }

    @Override
    public String buildNotificationMessage(ForceMergeResponse response, Exception exception, boolean isTimeout) {
        if (exception != null) {
            if (exception instanceof SkyliteException) {
                SkyliteException ose = (SkyliteException)((Object)exception);
                return "index [" + ose.getIndex().getName() + "] " + exception.getMessage() + ".";
            }
            return exception.getMessage() != null ? exception.getMessage() : "";
        }
        if (response != null && response.getShardFailures() != null && response.getShardFailures().length > 0) {
            return Arrays.stream(response.getShardFailures()).map(failure -> "index [" + failure.index() + "] shard [" + failure.shardId() + "] " + failure.reason()).collect(Collectors.joining(","));
        }
        if (this.request.indices().length == 1) {
            return "The force merge operation on " + this.indexNameWithCluster + " has been completed.";
        }
        return this.indexNameWithCluster + " have been merged.";
    }

    @Override
    public String buildNotificationTitle(OperationResult operationResult) {
        if (this.request.indices().length == 1) {
            return "Force merge operation on " + this.indexNameWithCluster + " has " + this.getOperationResultTitleDesc(operationResult);
        }
        return "Force merge operation on " + this.request.indices().length + " indexes from [" + this.clusterService.getClusterName().value() + "] has " + this.getOperationResultTitleDesc(operationResult);
    }
}

