/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.controlcenter.notification.filter.parser;

import io.lucenia.indexmanagement.controlcenter.notification.filter.NotificationActionListener;
import io.lucenia.indexmanagement.controlcenter.notification.filter.OperationResult;
import io.lucenia.indexmanagement.controlcenter.notification.filter.parser.ActionRespParseResult;
import io.lucenia.indexmanagement.controlcenter.notification.filter.parser.ResponseParser;
import io.skylite.SkyliteException;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.IndicesRequest;
import io.skylite.core.action.admin.indices.open.OpenIndexRequest;
import io.skylite.core.action.admin.indices.open.OpenIndexResponse;
import io.skylite.core.action.support.ActiveShardCount;
import io.skylite.core.action.support.ActiveShardsObserver;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.service.ClusterService;
import java.util.function.Consumer;

public class OpenIndexRespParser
implements ResponseParser<OpenIndexResponse> {
    private final ActiveShardsObserver activeShardsObserver;
    private final OpenIndexRequest request;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final ClusterService clusterService;
    private final String indexNameWithCluster;
    private TimeValue totalWaitTime;

    public OpenIndexRespParser(ActiveShardsObserver activeShardsObserver, OpenIndexRequest request, IndexNameExpressionResolver indexNameExpressionResolver, ClusterService clusterService) {
        this.activeShardsObserver = activeShardsObserver;
        this.request = request;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.clusterService = clusterService;
        this.indexNameWithCluster = this.getIndexName((ActionRequest)request, clusterService);
        this.totalWaitTime = NotificationActionListener.MAX_WAIT_TIME;
    }

    @Override
    public void parseAndSendNotification(OpenIndexResponse response, Exception ex, Consumer<ActionRespParseResult> callback) {
        TimeValue elapsedTime;
        if (ex != null) {
            callback.accept(new ActionRespParseResult(OperationResult.FAILED, this.buildNotificationMessage((OpenIndexResponse)null, ex, false), this.buildNotificationTitle(OperationResult.FAILED)));
            return;
        }
        if (response == null) {
            throw new IllegalArgumentException("OpenIndexResponse must not be null");
        }
        boolean isAsync = this.request.getShouldStoreResult();
        this.totalWaitTime = elapsedTime = this.request.ackTimeout();
        long leftTimeInMillis = NotificationActionListener.MAX_WAIT_TIME.millis() - elapsedTime.millis();
        if (!response.isShardsAcknowledged()) {
            if (!isAsync && leftTimeInMillis > 0L) {
                this.totalWaitTime = NotificationActionListener.MAX_WAIT_TIME;
                String[] concreteIndices = this.indexNameExpressionResolver.concreteIndexNames(this.clusterService.state(), (IndicesRequest)this.request);
                this.activeShardsObserver.waitForActiveShards(concreteIndices, ActiveShardCount.DEFAULT, TimeValue.timeValueMillis((long)leftTimeInMillis), shardsAcknowledged -> callback.accept(new ActionRespParseResult(shardsAcknowledged != false ? OperationResult.COMPLETE : OperationResult.TIMEOUT, this.buildNotificationMessage(response, (Exception)null, shardsAcknowledged == false), this.buildNotificationTitle(shardsAcknowledged != false ? OperationResult.COMPLETE : OperationResult.TIMEOUT))), e -> callback.accept(new ActionRespParseResult(OperationResult.FAILED, this.buildNotificationMessage(response, (Exception)e, false), this.buildNotificationTitle(OperationResult.FAILED))));
            } else {
                callback.accept(new ActionRespParseResult(OperationResult.TIMEOUT, this.buildNotificationMessage(response, (Exception)null, true), this.buildNotificationTitle(OperationResult.TIMEOUT)));
            }
        } else {
            callback.accept(new ActionRespParseResult(OperationResult.COMPLETE, this.buildNotificationMessage(response, (Exception)null, false), this.buildNotificationTitle(OperationResult.COMPLETE)));
        }
    }

    @Override
    public String buildNotificationMessage(OpenIndexResponse response, Exception exception, boolean isTimeout) {
        String indexes = this.indexNameWithCluster + (this.request.indices().length == 1 ? " has" : " have");
        if (isTimeout) {
            return "Opening the index " + indexes + " taken more than " + this.totalWaitTime.toHumanReadableString(1) + " to complete. To see the latest status, use `GET /" + String.join((CharSequence)",", this.request.indices()) + "/_recovery`";
        }
        if (exception != null) {
            if (exception instanceof SkyliteException) {
                SkyliteException ose = (SkyliteException)((Object)exception);
                return "index [" + ose.getIndex().getName() + "] " + exception.getMessage() + ".";
            }
            return exception.getMessage() != null ? exception.getMessage() : "";
        }
        return indexes + " been set to open.";
    }

    @Override
    public String buildNotificationTitle(OperationResult operationResult) {
        String result = switch (operationResult) {
            case OperationResult.COMPLETE -> "been opened";
            case OperationResult.FAILED -> "failed to open";
            default -> "timed out to open";
        };
        if (this.request.indices().length == 1) {
            return this.indexNameWithCluster + " has " + result;
        }
        return this.request.indices().length + " indexes from [" + this.clusterService.getClusterName().value() + "] have " + result;
    }
}

