/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.controlcenter.notification.filter.parser;

import io.lucenia.indexmanagement.controlcenter.notification.filter.OperationResult;
import io.lucenia.indexmanagement.controlcenter.notification.filter.parser.ActionRespParseResult;
import io.lucenia.indexmanagement.controlcenter.notification.filter.parser.ResponseParser;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.tasks.Task;
import io.skylite.core.tasks.TaskId;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.opensearch.index.reindex.BulkByScrollResponse;
import org.opensearch.index.reindex.ReindexRequest;

public class ReindexRespParser
implements ResponseParser<BulkByScrollResponse> {
    private final Task task;
    private final ReindexRequest request;
    private final ClusterService clusterService;
    private final String sourceIndex;

    public ReindexRespParser(Task task, ReindexRequest request, ClusterService clusterService) {
        this.task = task;
        this.request = request;
        this.clusterService = clusterService;
        this.sourceIndex = this.getIndexName((ActionRequest)request, clusterService);
    }

    @Override
    public void parseAndSendNotification(BulkByScrollResponse response, Exception ex, Consumer<ActionRespParseResult> callback) {
        boolean hasFailures;
        if (ex != null) {
            callback.accept(new ActionRespParseResult(OperationResult.FAILED, this.buildNotificationMessage((BulkByScrollResponse)null, ex, false), this.buildNotificationTitle(OperationResult.FAILED)));
            return;
        }
        if (response == null) {
            throw new IllegalArgumentException("Reindex response must not be null");
        }
        boolean bl = hasFailures = response.getBulkFailures() != null && !response.getBulkFailures().isEmpty() || response.getSearchFailures() != null && !response.getSearchFailures().isEmpty();
        if (hasFailures) {
            callback.accept(new ActionRespParseResult(OperationResult.FAILED, this.buildNotificationMessage(response, (Exception)null, false), this.buildNotificationTitle(OperationResult.FAILED)));
        } else if (response.getReasonCancelled() != null && !response.getReasonCancelled().isEmpty()) {
            callback.accept(new ActionRespParseResult(OperationResult.FAILED, this.buildNotificationMessage(response, (Exception)null, false), this.buildNotificationTitle(OperationResult.CANCELLED)));
        } else {
            callback.accept(new ActionRespParseResult(OperationResult.COMPLETE, this.buildNotificationMessage(response, (Exception)null, false), this.buildNotificationTitle(OperationResult.COMPLETE)));
        }
    }

    @Override
    public String buildNotificationMessage(BulkByScrollResponse response, Exception exception, boolean isTimeout) {
        StringBuilder result = new StringBuilder("The reindex operation from " + this.sourceIndex + " to " + this.getIndexName((ActionRequest)this.request.getDestination(), this.clusterService) + " ");
        if (exception != null) {
            result.append("has failed.").append(" ").append(exception.getMessage());
            return result.toString();
        }
        if (response == null) {
            throw new IllegalArgumentException("Reindex response must not be null");
        }
        String reason = response.getReasonCancelled();
        ArrayList failures = new ArrayList();
        if (response.getBulkFailures() != null && !response.getBulkFailures().isEmpty()) {
            failures.addAll(response.getBulkFailures().stream().map(f -> f.getCause()).collect(Collectors.toList()));
        }
        if (response.getSearchFailures() != null && !response.getSearchFailures().isEmpty()) {
            failures.addAll(response.getSearchFailures().stream().map(f -> f.getReason()).collect(Collectors.toList()));
        }
        boolean failed = !failures.isEmpty();
        TaskId taskId = new TaskId(this.clusterService.localNode().getId(), this.task.getId());
        if (reason != null && !reason.isBlank()) {
            result.append("has been cancelled by user's request");
        } else if (failed) {
            result.append("has failed.").append(" \n\n ").append(failures.size()).append(" error(s) found, including: \n");
            result.append(failures.stream().map(Throwable::getMessage).distinct().limit(2L).collect(Collectors.joining(",")));
            result.append("\nTo see full errors, use `GET /_tasks/").append(taskId).append("`");
        } else {
            result.append("has been completed.");
        }
        result.append("\n\n");
        result.append("*Summary (number of documents)* \n");
        result.append("Total: ").append(response.getTotal()).append(", Created: ").append(response.getCreated()).append(", Updated: ").append(response.getUpdated()).append(", Deleted: ").append(response.getDeleted()).append(", Conflicts: ").append(response.getVersionConflicts());
        return result.toString();
    }

    @Override
    public String buildNotificationTitle(OperationResult operationResult) {
        return "Reindex operation on " + this.sourceIndex + " has " + this.getOperationResultTitleDesc(operationResult);
    }
}

