/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.controlcenter.notification.filter.parser;

import io.lucenia.indexmanagement.controlcenter.notification.filter.NotificationActionListener;
import io.lucenia.indexmanagement.controlcenter.notification.filter.OperationResult;
import io.lucenia.indexmanagement.controlcenter.notification.filter.parser.ActionRespParseResult;
import io.lucenia.indexmanagement.controlcenter.notification.filter.parser.ResponseParser;
import io.skylite.ResourceAlreadyExistsException;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.admin.indices.shrink.ResizeRequest;
import io.skylite.core.action.admin.indices.shrink.ResizeResponse;
import io.skylite.core.action.support.ActiveShardCount;
import io.skylite.core.action.support.ActiveShardsObserver;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.index.IndexNotFoundException;
import java.util.Locale;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResizeIndexRespParser
implements ResponseParser<ResizeResponse> {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final ActiveShardsObserver activeShardsObserver;
    private final ResizeRequest request;
    private final ClusterService clusterService;
    private final String indexWithCluster;
    private TimeValue totalWaitTime;

    public ResizeIndexRespParser(ActiveShardsObserver activeShardsObserver, ResizeRequest request, ClusterService clusterService) {
        this.activeShardsObserver = activeShardsObserver;
        this.request = request;
        this.clusterService = clusterService;
        this.indexWithCluster = this.getIndexName((ActionRequest)request, clusterService);
        this.totalWaitTime = NotificationActionListener.MAX_WAIT_TIME;
    }

    @Override
    public void parseAndSendNotification(ResizeResponse response, Exception ex, Consumer<ActionRespParseResult> callback) {
        boolean isAsync = this.request.getShouldStoreResult();
        if (ex != null) {
            callback.accept(new ActionRespParseResult(OperationResult.FAILED, this.buildNotificationMessage((ResizeResponse)null, ex, false), this.buildNotificationTitle(OperationResult.FAILED)));
            return;
        }
        if (response == null) {
            throw new IllegalArgumentException("ResizeResponse must not be null");
        }
        if (!response.isShardsAcknowledged()) {
            TimeValue elapsedTime;
            this.logger.debug("Not all shards are started, continue monitoring on shards status");
            this.totalWaitTime = elapsedTime = this.request.getTargetIndexRequest().timeout();
            long leftTimeInMillis = NotificationActionListener.MAX_WAIT_TIME.millis() - elapsedTime.millis();
            if (!isAsync && leftTimeInMillis > 0L) {
                this.totalWaitTime = NotificationActionListener.MAX_WAIT_TIME;
                this.activeShardsObserver.waitForActiveShards(new String[]{response.index()}, ActiveShardCount.DEFAULT, TimeValue.timeValueMillis((long)leftTimeInMillis), shardsAcknowledged -> {
                    OperationResult result = shardsAcknowledged != false ? OperationResult.COMPLETE : OperationResult.TIMEOUT;
                    callback.accept(new ActionRespParseResult(result, this.buildNotificationMessage(response, (Exception)null, shardsAcknowledged == false), this.buildNotificationTitle(result)));
                }, e -> callback.accept(new ActionRespParseResult(OperationResult.FAILED, this.buildNotificationMessage(response, (Exception)e, false), this.buildNotificationTitle(OperationResult.FAILED))));
            } else {
                callback.accept(new ActionRespParseResult(OperationResult.TIMEOUT, this.buildNotificationMessage(response, (Exception)null, true), this.buildNotificationTitle(OperationResult.TIMEOUT)));
            }
        } else {
            callback.accept(new ActionRespParseResult(OperationResult.COMPLETE, this.buildNotificationMessage(response, (Exception)null, false), this.buildNotificationTitle(OperationResult.COMPLETE)));
        }
    }

    @Override
    public String buildNotificationMessage(ResizeResponse response, Exception exception, boolean isTimeout) {
        StringBuilder result = new StringBuilder();
        String action = this.request.getResizeType().name().toLowerCase(Locale.ROOT);
        result.append("The ").append(action).append(" operation from ").append(this.indexWithCluster).append(" to ").append(this.getIndexName((ActionRequest)this.request.getTargetIndexRequest(), this.clusterService)).append(" ");
        if (isTimeout) {
            result.append("has taken more than ").append(this.totalWaitTime.toHumanReadableString(1)).append(" to complete. To see the latest status, use `GET /").append(this.request.getTargetIndexRequest().index()).append("/_recovery`");
        } else {
            if (exception != null) {
                String message;
                String string = message = exception.getMessage() != null ? exception.getMessage() : "";
                if (exception instanceof IllegalStateException) {
                    if (message.contains("must have all shards allocated on the same node")) {
                        return "You must allocate a copy of every shard of the source index to the same node before " + action + ". To allocate it to same node, try use PUT /" + this.request.getSourceIndex() + "/_settings\n{\n\"index.routing.allocation.require._name\":\"your_node_name\"\n}";
                    }
                    if (message.contains("must block write operations to resize index")) {
                        return this.indexWithCluster + " must be set to block write to " + action + " the index. To set it to block write, use `PUT /" + this.request.getSourceIndex() + "/_block/write` ";
                    }
                    return message;
                }
                if (exception instanceof ResourceAlreadyExistsException) {
                    return "The target index " + this.getIndexName((ActionRequest)this.request.getTargetIndexRequest(), this.clusterService) + " already exists.";
                }
                if (exception instanceof IndexNotFoundException) {
                    return "The " + this.indexWithCluster + " does not exist.";
                }
                return message;
            }
            result.append("has been completed.");
        }
        return result.toString();
    }

    @Override
    public String buildNotificationTitle(OperationResult operationResult) {
        StringBuilder builder = new StringBuilder();
        String action = this.request.getResizeType().name().toLowerCase(Locale.ROOT);
        builder.append(Character.toUpperCase(action.charAt(0))).append(action.substring(1)).append(" operation on ").append(this.indexWithCluster).append(" has ").append(this.getOperationResultTitleDesc(operationResult));
        return builder.toString();
    }
}

