/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.controlcenter.notification.filter.parser;

import io.lucenia.indexmanagement.controlcenter.notification.filter.OperationResult;
import io.lucenia.indexmanagement.controlcenter.notification.filter.parser.ActionRespParseResult;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.IndicesRequest;
import io.skylite.core.cluster.service.ClusterService;
import java.util.function.Consumer;
import org.opensearch.index.reindex.ReindexRequest;

public interface ResponseParser<Response extends ActionResponse> {
    public void parseAndSendNotification(Response var1, Exception var2, Consumer<ActionRespParseResult> var3);

    public String buildNotificationMessage(Response var1, Exception var2, boolean var3);

    public String buildNotificationTitle(OperationResult var1);

    default public String getIndexName(ActionRequest req, ClusterService clusterService) {
        String clusterName = clusterService.getClusterName().value();
        if (req instanceof IndicesRequest) {
            IndicesRequest indicesRequest = (IndicesRequest)req;
            if (indicesRequest.indices().length == 1) {
                return "[" + clusterName + "/" + String.join((CharSequence)",", indicesRequest.indices()) + "]";
            }
            return "[" + String.join((CharSequence)",", indicesRequest.indices()) + "] from [" + clusterName + "]";
        }
        if (req instanceof ReindexRequest) {
            ReindexRequest reindexRequest = (ReindexRequest)req;
            Object effectiveClusterName = clusterName;
            if (reindexRequest.getRemoteInfo() != null) {
                effectiveClusterName = "remote cluster " + reindexRequest.getRemoteInfo().getHost();
            }
            if (reindexRequest.getSearchRequest().indices().length == 1) {
                return "[" + (String)effectiveClusterName + "/" + String.join((CharSequence)",", reindexRequest.getSearchRequest().indices()) + "]";
            }
            return "[" + String.join((CharSequence)",", reindexRequest.getSearchRequest().indices()) + "] from [" + (String)effectiveClusterName + "]";
        }
        return "";
    }

    default public String getOperationResultTitleDesc(OperationResult result) {
        switch (result) {
            case COMPLETE: {
                return "completed";
            }
            case FAILED: {
                return "failed";
            }
            case TIMEOUT: {
                return "timed out";
            }
            case CANCELLED: {
                return "been cancelled";
            }
        }
        return "unknown";
    }
}

