/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.controlcenter.notification.model;

import io.lucenia.indexmanagement.common.model.notification.Channel;
import io.lucenia.indexmanagement.controlcenter.notification.model.LRONCondition;
import io.lucenia.indexmanagement.controlcenter.notification.util.LRONUtils;
import io.lucenia.indexmanagement.luceniaapi.LuceniaExtensions;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.security.auth.User;
import io.skylite.core.tasks.TaskId;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class LRONConfig
implements ToXContentObject,
Writeable {
    public static final String LRON_CONFIG_FIELD = "lron_config";
    public static final String LRON_CONFIG_FIELDS = "lron_configs";
    public static final String TASK_ID_FIELD = "task_id";
    public static final String ACTION_NAME_FIELD = "action_name";
    public static final String CHANNELS_FIELD = "channels";
    public static final String USER_FIELD = "user";
    public static final String PRIORITY_FIELD = "priority";
    public static final String CHANNEL_TITLE = "Long Running Operation Notification";
    private final LRONCondition lronCondition;
    private final TaskId taskId;
    private final String actionName;
    private final List<Channel> channels;
    private final User user;
    private final Integer priority;

    public LRONConfig(LRONCondition lronCondition, TaskId taskId, String actionName, List<Channel> channels, User user, Integer priority) {
        LRONUtils.validateTaskIdAndActionName(taskId, actionName);
        if (lronCondition.isEnabled() && (channels == null || channels.isEmpty())) {
            throw new IllegalArgumentException("Enabled LRONConfig must contain at least one channel");
        }
        this.lronCondition = lronCondition;
        this.taskId = taskId;
        this.actionName = actionName;
        this.channels = channels;
        this.user = user;
        this.priority = priority;
    }

    public LRONConfig(StreamInput sin) throws IOException {
        this.lronCondition = new LRONCondition(sin);
        this.taskId = sin.readBoolean() ? new TaskId(sin.readString()) : null;
        this.actionName = sin.readOptionalString();
        this.channels = sin.readBoolean() ? sin.readList(Channel::new) : null;
        this.user = (User)sin.readOptionalWriteable(User::new);
        this.priority = sin.readOptionalInt();
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.lronCondition.writeTo(out);
        if (this.taskId != null) {
            out.writeBoolean(true);
            out.writeString(this.taskId.toString());
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalString(this.actionName);
        if (this.channels != null) {
            out.writeBoolean(true);
            out.writeList(this.channels);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalWriteable((Writeable)this.user);
        out.writeOptionalInt(this.priority);
    }

    public XContentBuilder toXContent(XContentBuilder builder) throws IOException {
        return this.toXContent(builder, ToXContent.EMPTY_PARAMS);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (params == null) {
            params = ToXContent.EMPTY_PARAMS;
        }
        builder.startObject();
        if (params.paramAsBoolean("with_type", true)) {
            builder.startObject(LRON_CONFIG_FIELD);
        }
        builder.field("lron_condition", (ToXContent)this.lronCondition);
        if (this.taskId != null) {
            builder.field(TASK_ID_FIELD, this.taskId.toString());
        }
        if (this.actionName != null) {
            builder.field(ACTION_NAME_FIELD, this.actionName);
        }
        if (params.paramAsBoolean("with_user", true)) {
            LuceniaExtensions.optionalUserField(builder, USER_FIELD, this.user);
        }
        if (this.channels != null) {
            builder.startArray(CHANNELS_FIELD);
            for (Channel channel : this.channels) {
                channel.toXContent(builder, params);
            }
            builder.endArray();
        }
        if (params.paramAsBoolean("with_priority", true)) {
            builder.field(PRIORITY_FIELD, this.priority);
        }
        if (params.paramAsBoolean("with_type", true)) {
            builder.endObject();
        }
        return builder.endObject();
    }

    public static LRONConfig parse(XContentParser xcp, String id, long seqNo, long primaryTerm) throws IOException {
        return LRONConfig.parse(xcp);
    }

    public static LRONConfig parse(XContentParser xcp) throws IOException {
        LRONCondition lronCondition = new LRONCondition();
        TaskId taskId = null;
        String actionName = null;
        ArrayList<Channel> channels = null;
        User user = null;
        Integer priority = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        block16: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "lron_condition": {
                    lronCondition = LRONCondition.parse(xcp);
                    continue block16;
                }
                case "task_id": {
                    taskId = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : new TaskId(xcp.text());
                    continue block16;
                }
                case "action_name": {
                    actionName = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : xcp.text();
                    continue block16;
                }
                case "channels": {
                    if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) continue block16;
                    channels = new ArrayList<Channel>();
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        channels.add(Channel.parse(xcp));
                    }
                    continue block16;
                }
                case "user": {
                    user = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : User.parse((XContentParser)xcp);
                    continue block16;
                }
                case "priority": {
                    priority = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : Integer.valueOf(xcp.intValue());
                    continue block16;
                }
            }
            throw new IllegalArgumentException("Invalid field: [" + fieldName + "] found in LRONConfig.");
        }
        return new LRONConfig(lronCondition, taskId, actionName, channels, user, priority);
    }

    public LRONCondition getLronCondition() {
        return this.lronCondition;
    }

    public TaskId getTaskId() {
        return this.taskId;
    }

    public String getActionName() {
        return this.actionName;
    }

    public List<Channel> getChannels() {
        return this.channels;
    }

    public User getUser() {
        return this.user;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LRONConfig that = (LRONConfig)o;
        return Objects.equals(this.lronCondition, that.lronCondition) && Objects.equals(this.taskId, that.taskId) && Objects.equals(this.actionName, that.actionName) && Objects.equals(this.channels, that.channels) && Objects.equals(this.user, that.user) && Objects.equals(this.priority, that.priority);
    }

    public int hashCode() {
        return Objects.hash(this.lronCondition, this.taskId, this.actionName, this.channels, this.user, this.priority);
    }

    public static class Builder {
        private LRONCondition lronCondition;
        private TaskId taskId;
        private String actionName;
        private List<Channel> channels;
        private User user;
        private Integer priority;

        public Builder() {
        }

        public Builder(LRONConfig source) {
            this.lronCondition = source.lronCondition;
            this.taskId = source.taskId;
            this.actionName = source.actionName;
            this.channels = source.channels;
            this.user = source.user;
            this.priority = source.priority;
        }

        public Builder lronCondition(LRONCondition val) {
            this.lronCondition = val;
            return this;
        }

        public Builder taskId(TaskId val) {
            this.taskId = val;
            return this;
        }

        public Builder actionName(String val) {
            this.actionName = val;
            return this;
        }

        public Builder channels(List<Channel> val) {
            this.channels = val;
            return this;
        }

        public Builder user(User val) {
            this.user = val;
            return this;
        }

        public Builder priority(Integer val) {
            this.priority = val;
            return this;
        }

        public LRONConfig build() {
            return new LRONConfig(this.lronCondition, this.taskId, this.actionName, this.channels, this.user, this.priority);
        }
    }
}

