/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.controlcenter.notification.resthandler;

import io.lucenia.indexmanagement.controlcenter.notification.action.index.IndexLRONConfigAction;
import io.lucenia.indexmanagement.controlcenter.notification.action.index.IndexLRONConfigRequest;
import io.lucenia.indexmanagement.controlcenter.notification.model.LRONConfig;
import io.lucenia.indexmanagement.controlcenter.notification.util.LRONUtils;
import io.lucenia.indexmanagement.luceniaapi.LuceniaExtensions;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestIndexLRONConfigAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return Arrays.asList(new RestHandler.Route(RestRequest.Method.POST, "/_plugins/_im/lron"), new RestHandler.Route(RestRequest.Method.PUT, "/_plugins/_im/lron/{id}"));
    }

    public String getName() {
        return "create_lron_config_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        boolean isUpdate;
        String docId = request.param("id");
        boolean dryRun = request.paramAsBoolean("dry_run", false);
        XContentParser xcp = request.contentParser();
        LRONConfig lronConfig = LuceniaExtensions.parseWithType(xcp, LRONConfig::parse);
        boolean bl = isUpdate = docId != null;
        if (isUpdate && !LRONUtils.getDocID(lronConfig.getTaskId(), lronConfig.getActionName()).equals(docId)) {
            throw new IllegalArgumentException("docId isn't match with lron_config");
        }
        IndexLRONConfigRequest indexLRONConfigRequest = new IndexLRONConfigRequest(lronConfig, isUpdate, dryRun);
        return channel -> client.execute((ActionType)IndexLRONConfigAction.INSTANCE, (ActionRequest)indexLRONConfigRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

