/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.controlcenter.notification.util;

import io.lucenia.indexmanagement.controlcenter.notification.LRONConfigResponse;
import io.lucenia.indexmanagement.controlcenter.notification.model.LRONConfig;
import io.lucenia.indexmanagement.luceniaapi.LuceniaExtensions;
import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.get.GetRequest;
import io.skylite.core.action.get.GetResponse;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.tasks.TaskId;
import io.skylite.core.xcontent.NamedXContentRegistry;
import java.util.Set;

public final class LRONUtils {
    public static final String LRON_DOC_ID_PREFIX = "LRON:";
    public static final String WITH_PRIORITY = "with_priority";
    public static final int PRIORITY_TASK_ID = 200;
    public static final int PRIORITY_DEFAULT_ACTION = 100;
    public static final String DEFAULT_LRON_CONFIG_SORT_FIELD = "lron_config.priority";
    private static final Set<String> SUPPORTED_ACTIONS = Set.of("indices:data/write/reindex", "indices:admin/resize", "indices:admin/forcemerge", "indices:admin/open");

    private LRONUtils() {
    }

    public static Set<String> getSupportedActions() {
        return SUPPORTED_ACTIONS;
    }

    public static void validateTaskIdAndActionName(TaskId taskId, String actionName) {
        if (actionName == null && taskId == null) {
            throw new IllegalArgumentException("LRONConfig must contain taskID or actionName");
        }
        LRONUtils.validateActionName(actionName);
    }

    public static void validateActionName(String actionName) {
        if (actionName == null) {
            return;
        }
        if (!SUPPORTED_ACTIONS.contains(actionName)) {
            throw new IllegalArgumentException("Invalid action name. All supported actions: " + String.valueOf(SUPPORTED_ACTIONS));
        }
    }

    public static int getPriority(TaskId taskId, String actionName) {
        LRONUtils.validateTaskIdAndActionName(taskId, actionName);
        if (taskId != null) {
            return 200;
        }
        return 100;
    }

    public static String getDocID(TaskId taskId, String actionName) {
        LRONUtils.validateTaskIdAndActionName(taskId, actionName);
        String id = taskId != null ? taskId.toString() : actionName;
        return LRON_DOC_ID_PREFIX + id;
    }

    public static void getLRONConfigAndParse(NodeClient client, final String docId, final NamedXContentRegistry xContentRegistry, final ActionListener<LRONConfigResponse> actionListener) {
        GetRequest getRequest = new GetRequest(".opensearch-control-center", docId);
        client.get(getRequest, (ActionListener)new ActionListener<GetResponse>(){

            public void onResponse(GetResponse response) {
                LRONConfig lronConfig;
                if (!response.isExists()) {
                    actionListener.onFailure((Exception)((Object)new SkyliteStatusException("lronConfig " + docId + " not found", RestStatus.NOT_FOUND, new Object[0])));
                    return;
                }
                try {
                    lronConfig = LuceniaExtensions.parseFromGetResponse(response, xContentRegistry, LRONConfig::parse);
                }
                catch (Exception e) {
                    actionListener.onFailure(e);
                    return;
                }
                actionListener.onResponse((Object)new LRONConfigResponse(response.getId(), lronConfig));
            }

            public void onFailure(Exception t) {
                actionListener.onFailure(t);
            }
        });
    }
}

