/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement;

import io.skylite.common.action.ActionListener;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.admin.cluster.state.ClusterStateRequest;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.indexmanagement.IndexMetadataService;
import io.skylite.indexmanagement.model.ISMIndexMetadata;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class DefaultIndexMetadataService
implements IndexMetadataService {
    public static final long DEFAULT_GET_METADATA_TIMEOUT_IN_MILLIS = 30000L;
    private final String customUUIDSetting;

    public DefaultIndexMetadataService() {
        this(null);
    }

    public DefaultIndexMetadataService(String customUUIDSetting) {
        this.customUUIDSetting = customUUIDSetting;
    }

    public CompletableFuture<Map<String, ISMIndexMetadata>> getMetadata(List<String> indices, Client client, ClusterService clusterService) {
        CompletableFuture<Map<String, ISMIndexMetadata>> future = new CompletableFuture<Map<String, ISMIndexMetadata>>();
        HashMap indexNameToMetadata = new HashMap();
        IndicesOptions lenientExpandOptions = IndicesOptions.lenientExpandHidden();
        ClusterStateRequest clusterStateRequest = ((ClusterStateRequest)new ClusterStateRequest().clear().indices(indices.toArray(new String[0])).metadata(true).local(false)).waitForTimeout(TimeValue.timeValueMillis((long)30000L)).indicesOptions(lenientExpandOptions);
        client.admin().cluster().state(clusterStateRequest, ActionListener.wrap(response -> {
            for (Map.Entry entry : response.getState().metadata().indices().entrySet()) {
                String uuid = this.getIndexUUID((IndexMetadata)entry.getValue());
                ISMIndexMetadata indexMetadata = new ISMIndexMetadata(uuid, ((IndexMetadata)entry.getValue()).getCreationDate(), -1L);
                indexNameToMetadata.put((String)entry.getKey(), indexMetadata);
            }
            future.complete(indexNameToMetadata);
        }, future::completeExceptionally));
        return future;
    }

    public String getIndexUUID(IndexMetadata indexMetadata) {
        if (this.customUUIDSetting != null) {
            return indexMetadata.getSettings().get(this.customUUIDSetting, indexMetadata.getIndexUUID());
        }
        return indexMetadata.getIndexUUID();
    }

    public CompletableFuture<Map<String, ISMIndexMetadata>> getMetadataForAllIndices(Client client, ClusterService clusterService) {
        return this.getMetadata(List.of("*"), client, clusterService);
    }
}

