/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement;

import io.lucenia.indexmanagement.indexstatemanagement.action.AliasActionParser;
import io.lucenia.indexmanagement.indexstatemanagement.action.AllocationActionParser;
import io.lucenia.indexmanagement.indexstatemanagement.action.CloseActionParser;
import io.lucenia.indexmanagement.indexstatemanagement.action.ConvertIndexToRemoteActionParser;
import io.lucenia.indexmanagement.indexstatemanagement.action.DeleteActionParser;
import io.lucenia.indexmanagement.indexstatemanagement.action.ForceMergeActionParser;
import io.lucenia.indexmanagement.indexstatemanagement.action.IndexPriorityActionParser;
import io.lucenia.indexmanagement.indexstatemanagement.action.NotificationActionParser;
import io.lucenia.indexmanagement.indexstatemanagement.action.OpenActionParser;
import io.lucenia.indexmanagement.indexstatemanagement.action.ReadOnlyActionParser;
import io.lucenia.indexmanagement.indexstatemanagement.action.ReadWriteActionParser;
import io.lucenia.indexmanagement.indexstatemanagement.action.ReplicaCountActionParser;
import io.lucenia.indexmanagement.indexstatemanagement.action.RolloverActionParser;
import io.lucenia.indexmanagement.indexstatemanagement.action.RollupActionParser;
import io.lucenia.indexmanagement.indexstatemanagement.action.ShrinkActionParser;
import io.lucenia.indexmanagement.indexstatemanagement.action.SnapshotActionParser;
import io.lucenia.indexmanagement.indexstatemanagement.action.StopReplicationActionParser;
import io.lucenia.indexmanagement.indexstatemanagement.action.TransformActionParser;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.indexmanagement.Action;
import io.skylite.indexmanagement.ActionParser;
import io.skylite.indexmanagement.model.ActionRetry;
import io.skylite.indexmanagement.model.ActionTimeout;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ISMActionsParser {
    private final List<ActionParser> parsers = new ArrayList<ActionParser>();
    private final Map<String, String> customActionExtensionMap = new HashMap<String, String>();

    private ISMActionsParser() {
        this.parsers.add(new AliasActionParser());
        this.parsers.add(new AllocationActionParser());
        this.parsers.add(new CloseActionParser());
        this.parsers.add(new DeleteActionParser());
        this.parsers.add(new ForceMergeActionParser());
        this.parsers.add(new IndexPriorityActionParser());
        this.parsers.add(new NotificationActionParser());
        this.parsers.add(new OpenActionParser());
        this.parsers.add(new ReadOnlyActionParser());
        this.parsers.add(new ReadWriteActionParser());
        this.parsers.add(new ReplicaCountActionParser());
        this.parsers.add(new RollupActionParser());
        this.parsers.add(new RolloverActionParser());
        this.parsers.add(new ShrinkActionParser());
        this.parsers.add(new SnapshotActionParser());
        this.parsers.add(new TransformActionParser());
        this.parsers.add(new StopReplicationActionParser());
        this.parsers.add(new ConvertIndexToRemoteActionParser());
    }

    public static ISMActionsParser getInstance() {
        return Holder.INSTANCE;
    }

    public List<ActionParser> getParsers() {
        return this.parsers;
    }

    public Map<String, String> getCustomActionExtensionMap() {
        return this.customActionExtensionMap;
    }

    public void addParser(ActionParser parser, String extensionName) {
        for (ActionParser existingParser : this.parsers) {
            if (!existingParser.getActionType().equals(parser.getActionType())) continue;
            throw new IllegalArgumentException(ISMActionsParser.getDuplicateActionTypesMessage(parser.getActionType()));
        }
        parser.setCustomAction(true);
        this.parsers.add(parser);
        this.customActionExtensionMap.put(parser.getActionType(), extensionName);
    }

    public Action fromStreamInput(StreamInput sin) throws IOException {
        String type = sin.readString();
        ActionTimeout configTimeout = (ActionTimeout)sin.readOptionalWriteable(ActionTimeout::new);
        ActionRetry configRetry = (ActionRetry)sin.readOptionalWriteable(ActionRetry::new);
        ActionParser parser = null;
        for (ActionParser p : this.parsers) {
            if (!p.getActionType().equals(type)) continue;
            parser = p;
            break;
        }
        if (parser == null) {
            throw new IllegalArgumentException("Invalid field: [" + type + "] found in Actions.");
        }
        Action action = parser.fromStreamInput(sin);
        action.setConfigTimeout(configTimeout);
        action.setConfigRetry(configRetry);
        return action;
    }

    public Action parse(XContentParser xcp, int totalActions) throws IOException {
        Action action = null;
        ActionTimeout timeout = null;
        ActionRetry retry = new ActionRetry(3L);
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String type = xcp.currentName();
            xcp.nextToken();
            if ("timeout".equals(type)) {
                timeout = ActionTimeout.parse((XContentParser)xcp);
                continue;
            }
            if ("retry".equals(type)) {
                retry = ActionRetry.parse((XContentParser)xcp);
                continue;
            }
            if ("custom".equals(type)) {
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
                String customActionType = xcp.currentName();
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
                action = this.parseAction(xcp, totalActions, customActionType);
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
                continue;
            }
            action = this.parseAction(xcp, totalActions, type);
        }
        if (action == null) {
            throw new IllegalArgumentException("Action inside state is null");
        }
        action.setConfigTimeout(timeout);
        action.setConfigRetry(retry);
        return action;
    }

    private Action parseAction(XContentParser xcp, int totalActions, String type) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        ActionParser parser = null;
        for (ActionParser p : this.parsers) {
            if (!p.getActionType().equals(type)) continue;
            parser = p;
            break;
        }
        if (parser == null) {
            throw new IllegalArgumentException("Invalid field: [" + type + "] found in Actions.");
        }
        Action action = parser.fromXContent(xcp, totalActions);
        action.setCustomAction(parser.isCustomAction());
        return action;
    }

    public static String getDuplicateActionTypesMessage(String actionType) {
        return "Multiple action parsers attempted to register the same action type [" + actionType + "]";
    }

    private static final class Holder {
        private static final ISMActionsParser INSTANCE = new ISMActionsParser();

        private Holder() {
        }
    }
}

