/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement;

import io.lucenia.indexmanagement.indexstatemanagement.model.ISMTemplate;
import io.lucenia.indexmanagement.util.IndexManagementException;
import io.skylite.SkyliteException;
import io.skylite.common.ValidationException;
import io.skylite.core.common.Strings;
import io.skylite.core.common.regex.Regex;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;

public class ISMTemplateService {
    private ISMTemplateService() {
    }

    public static SkyliteException validateFormat(List<String> indexPatterns) {
        ArrayList<CallSite> indexPatternFormatErrors = new ArrayList<CallSite>();
        for (String indexPattern : indexPatterns) {
            if (indexPattern.contains("#")) {
                indexPatternFormatErrors.add((CallSite)((Object)("index_pattern [" + indexPattern + "] must not contain a '#'")));
            }
            if (indexPattern.contains(":")) {
                indexPatternFormatErrors.add((CallSite)((Object)("index_pattern [" + indexPattern + "] must not contain a ':'")));
            }
            if (indexPattern.startsWith("_")) {
                indexPatternFormatErrors.add((CallSite)((Object)("index_pattern [" + indexPattern + "] must not start with '_'")));
            }
            if (Strings.validFileNameExcludingAstrix((String)indexPattern)) continue;
            indexPatternFormatErrors.add((CallSite)((Object)("index_pattern [" + indexPattern + "] must not contain the following characters " + String.valueOf(Strings.INVALID_FILENAME_CHARS))));
        }
        if (indexPatternFormatErrors.size() > 0) {
            ValidationException validationException = new ValidationException();
            validationException.addValidationErrors(indexPatternFormatErrors);
            return IndexManagementException.wrap((Exception)validationException);
        }
        return null;
    }

    public static Map.Entry<List<String>, List<String>> findSelfConflictingTemplates(List<ISMTemplate> templates) {
        List templateList;
        HashMap priorityToTemplates = new HashMap();
        for (ISMTemplate iSMTemplate : templates) {
            templateList = (List)priorityToTemplates.get(iSMTemplate.getPriority());
            if (templateList != null) {
                templateList.add(iSMTemplate);
                continue;
            }
            ArrayList<ISMTemplate> newList = new ArrayList<ISMTemplate>();
            newList.add(iSMTemplate);
            priorityToTemplates.put(iSMTemplate.getPriority(), newList);
        }
        for (Map.Entry entry : priorityToTemplates.entrySet()) {
            templateList = (List)entry.getValue();
            ArrayList<List<String>> indexPatternsList = new ArrayList<List<String>>();
            for (ISMTemplate template : templateList) {
                indexPatternsList.add(template.getIndexPatterns());
            }
            if (indexPatternsList.size() <= 1) continue;
            for (int ind = 0; ind < indexPatternsList.size(); ++ind) {
                List indexPatterns = (List)indexPatternsList.get(ind);
                ArrayList<String> comparePatterns = new ArrayList<String>();
                for (int j = ind + 1; j < indexPatternsList.size(); ++j) {
                    comparePatterns.addAll((Collection)indexPatternsList.get(j));
                }
                if (!ISMTemplateService.overlapping(indexPatterns, comparePatterns)) continue;
                return Map.entry(indexPatterns, comparePatterns);
            }
        }
        return null;
    }

    public static boolean overlapping(List<String> p1, List<String> p2) {
        Automaton a2;
        if (p1.isEmpty() || p2.isEmpty()) {
            return false;
        }
        Automaton a1 = Regex.simpleMatchToAutomaton((String[])p1.toArray(new String[0]));
        return !Operations.isEmpty((Automaton)Operations.intersection((Automaton)a1, (Automaton)(a2 = Regex.simpleMatchToAutomaton((String[])p2.toArray(new String[0])))));
    }

    public static Map<String, List<String>> findConflictingPolicyTemplates(Map<String, List<ISMTemplate>> policyTemplates, String candidate, List<String> indexPatterns, int priority) {
        HashMap<String, List<String>> overlappingTemplates = new HashMap<String, List<String>>();
        for (Map.Entry<String, List<ISMTemplate>> entry : policyTemplates.entrySet()) {
            String policyID = entry.getKey();
            List<ISMTemplate> templateList = entry.getValue();
            for (ISMTemplate template : templateList) {
                List<String> templateIndexPatterns;
                if (template.getPriority() != priority || !ISMTemplateService.overlapping(indexPatterns, templateIndexPatterns = template.getIndexPatterns())) continue;
                overlappingTemplates.put(policyID, templateIndexPatterns);
            }
        }
        overlappingTemplates.remove(candidate);
        return overlappingTemplates;
    }
}

