/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement;

import io.lucenia.indexmanagement.indexstatemanagement.settings.ManagedIndexSettings;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.settings.Settings;
import io.skylite.indexmanagement.IndexMetadataService;
import io.skylite.indexmanagement.model.ISMIndexMetadata;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class IndexMetadataProvider {
    public static final String EVALUATION_FAILURE_MESSAGE = "Matches restricted index pattern defined in the cluster setting";
    public static final String MULTIPLE_INDICES_CUSTOM_INDEX_TYPE_ERROR = "Cannot get metadata for more than one index name/pattern when using a custom index type";
    private final Settings settings;
    private final Client client;
    private final ClusterService clusterService;
    private final Map<String, IndexMetadataService> services;
    private volatile String restrictedIndexPattern;

    public IndexMetadataProvider(Settings settings, Client client, ClusterService clusterService, Map<String, IndexMetadataService> services) {
        this.settings = settings;
        this.client = client;
        this.clusterService = clusterService;
        this.services = services;
        this.restrictedIndexPattern = (String)ManagedIndexSettings.RESTRICTED_INDEX_PATTERN.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(ManagedIndexSettings.RESTRICTED_INDEX_PATTERN, pattern -> {
            this.restrictedIndexPattern = pattern;
        });
    }

    public boolean isUnManageableIndex(String index) {
        return Pattern.matches(this.restrictedIndexPattern, index);
    }

    public CompletableFuture<Map<String, ISMIndexMetadata>> getISMIndexMetadataByType(String type, List<String> indexNames) {
        IndexMetadataService service = this.services.get(type);
        if (service == null) {
            return CompletableFuture.failedFuture(new IllegalArgumentException(IndexMetadataProvider.getTypeNotRecognizedMessage(type)));
        }
        if (!"_default".equals(type) && indexNames.size() > 1) {
            return CompletableFuture.failedFuture(new IllegalArgumentException(MULTIPLE_INDICES_CUSTOM_INDEX_TYPE_ERROR));
        }
        return service.getMetadata(indexNames, this.client, this.clusterService);
    }

    public CompletableFuture<Map<String, ISMIndexMetadata>> getISMIndexMetadataByType(List<String> indexNames) {
        return this.getISMIndexMetadataByType("_default", indexNames);
    }

    public CompletableFuture<Map<String, ISMIndexMetadata>> getAllISMIndexMetadataByType(String type) {
        IndexMetadataService service = this.services.get(type);
        if (service == null) {
            return CompletableFuture.failedFuture(new IllegalArgumentException(IndexMetadataProvider.getTypeNotRecognizedMessage(type)));
        }
        return service.getMetadataForAllIndices(this.client, this.clusterService);
    }

    public CompletableFuture<Map<String, ISMIndexMetadata>> getAllISMIndexMetadataByType() {
        return this.getAllISMIndexMetadataByType("_default");
    }

    public CompletableFuture<Map<String, Map<String, ISMIndexMetadata>>> getMultiTypeISMIndexMetadata(List<String> types, List<String> indexNames) {
        if (types.stream().anyMatch(t -> !"_default".equals(t)) && indexNames.size() > 1) {
            return CompletableFuture.failedFuture(new IllegalArgumentException(MULTIPLE_INDICES_CUSTOM_INDEX_TYPE_ERROR));
        }
        ArrayList<CompletionStage> requests = new ArrayList<CompletionStage>();
        for (String type : types) {
            CompletionStage future = this.getISMIndexMetadataByType(type, indexNames).thenApply(metadata -> Map.entry(type, metadata));
            requests.add(future);
        }
        return CompletableFuture.allOf(requests.toArray(new CompletableFuture[0])).thenApply(v -> requests.stream().map(CompletableFuture::join).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    public CompletableFuture<Map<String, Map<String, ISMIndexMetadata>>> getMultiTypeISMIndexMetadata(List<String> indexNames) {
        return this.getMultiTypeISMIndexMetadata(new ArrayList<String>(this.services.keySet()), indexNames);
    }

    public void addMetadataServices(Map<String, IndexMetadataService> newServices) {
        String duplicateIndexType = newServices.keySet().stream().filter(this.services::containsKey).findFirst().orElse(null);
        if (duplicateIndexType != null) {
            throw new IllegalArgumentException(IndexMetadataProvider.getDuplicateServicesMessage(duplicateIndexType));
        }
        this.services.putAll(newServices);
    }

    public CompletableFuture<Set<ISMIndexMetadata>> getAllISMIndexMetadata() {
        ArrayList<CompletableFuture> requests = new ArrayList<CompletableFuture>();
        for (IndexMetadataService service : this.services.values()) {
            requests.add(service.getMetadataForAllIndices(this.client, this.clusterService));
        }
        return CompletableFuture.allOf(requests.toArray(new CompletableFuture[0])).thenApply(v -> {
            HashSet metadata = new HashSet();
            for (CompletableFuture future : requests) {
                metadata.addAll(((Map)future.join()).values());
            }
            return metadata;
        });
    }

    public List<String> getIndexMetadataWriteOverrideSettings() {
        return this.services.values().stream().map(IndexMetadataService::getIndexMetadataWriteOverrideSetting).filter(setting -> setting != null).collect(Collectors.toList());
    }

    public Settings getSettings() {
        return this.settings;
    }

    public Client getClient() {
        return this.client;
    }

    public ClusterService getClusterService() {
        return this.clusterService;
    }

    public Map<String, IndexMetadataService> getServices() {
        return this.services;
    }

    public static String getTypeNotRecognizedMessage(String indexType) {
        return "Index type [type=" + indexType + "] was not recognized when trying to get index metadata";
    }

    public static String getDuplicateServicesMessage(String indexType) {
        return "Multiple metadata services attempted to assign a service to the index type [" + indexType + "]";
    }
}

