/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement;

import io.lucenia.indexmanagement.IndexManagementIndices;
import io.lucenia.indexmanagement.indexstatemanagement.settings.ManagedIndexSettings;
import io.skylite.common.action.ActionListener;
import io.skylite.common.unit.TimeValue;
import io.skylite.common.xcontent.XContentFactory;
import io.skylite.core.action.admin.cluster.state.ClusterStateRequest;
import io.skylite.core.action.admin.cluster.state.ClusterStateResponse;
import io.skylite.core.action.admin.indices.delete.DeleteIndexRequest;
import io.skylite.core.action.admin.indices.rollover.RolloverRequest;
import io.skylite.core.action.admin.indices.rollover.RolloverResponse;
import io.skylite.core.action.bulk.BulkItemResponse;
import io.skylite.core.action.bulk.BulkRequest;
import io.skylite.core.action.bulk.BulkResponse;
import io.skylite.core.action.clustermanager.AcknowledgedResponse;
import io.skylite.core.action.index.IndexRequest;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.service.LocalNodeClusterManagerListener;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.Scheduler;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.indexmanagement.Step;
import io.skylite.indexmanagement.model.ManagedIndexMetaData;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IndexStateManagementHistory
implements LocalNodeClusterManagerListener {
    private static final Logger logger = LogManager.getLogger(IndexStateManagementHistory.class);
    private final Client client;
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final IndexManagementIndices indexManagementIndices;
    private volatile Scheduler.Cancellable scheduledRollover;
    private volatile boolean historyEnabled;
    private volatile long historyMaxDocs;
    private volatile TimeValue historyMaxAge;
    private volatile TimeValue historyRolloverCheckPeriod;
    private volatile TimeValue historyRetentionPeriod;
    private volatile int historyNumberOfShards;
    private volatile int historyNumberOfReplicas;

    public IndexStateManagementHistory(Settings settings, Client client, ThreadPool threadPool, ClusterService clusterService, IndexManagementIndices indexManagementIndices) {
        this.client = client;
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.indexManagementIndices = indexManagementIndices;
        this.historyEnabled = (Boolean)ManagedIndexSettings.HISTORY_ENABLED.get(settings);
        this.historyMaxDocs = (Long)ManagedIndexSettings.HISTORY_MAX_DOCS.get(settings);
        this.historyMaxAge = (TimeValue)ManagedIndexSettings.HISTORY_INDEX_MAX_AGE.get(settings);
        this.historyRolloverCheckPeriod = (TimeValue)ManagedIndexSettings.HISTORY_ROLLOVER_CHECK_PERIOD.get(settings);
        this.historyRetentionPeriod = (TimeValue)ManagedIndexSettings.HISTORY_RETENTION_PERIOD.get(settings);
        this.historyNumberOfShards = (Integer)ManagedIndexSettings.HISTORY_NUMBER_OF_SHARDS.get(settings);
        this.historyNumberOfReplicas = (Integer)ManagedIndexSettings.HISTORY_NUMBER_OF_REPLICAS.get(settings);
        clusterService.addLocalNodeClusterManagerListener((LocalNodeClusterManagerListener)this);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(ManagedIndexSettings.HISTORY_ENABLED, value -> {
            this.historyEnabled = value;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(ManagedIndexSettings.HISTORY_MAX_DOCS, value -> {
            this.historyMaxDocs = value;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(ManagedIndexSettings.HISTORY_INDEX_MAX_AGE, value -> {
            this.historyMaxAge = value;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(ManagedIndexSettings.HISTORY_ROLLOVER_CHECK_PERIOD, value -> {
            this.historyRolloverCheckPeriod = value;
            this.rescheduleRollover();
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(ManagedIndexSettings.HISTORY_RETENTION_PERIOD, value -> {
            this.historyRetentionPeriod = value;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(ManagedIndexSettings.HISTORY_NUMBER_OF_SHARDS, value -> {
            this.historyNumberOfShards = value;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(ManagedIndexSettings.HISTORY_NUMBER_OF_REPLICAS, value -> {
            this.historyNumberOfReplicas = value;
        });
    }

    public void onClusterManager() {
        try {
            if (this.historyEnabled) {
                this.rolloverHistoryIndex();
            }
            this.scheduledRollover = this.threadPool.scheduleWithFixedDelay(this::rolloverAndDeleteHistoryIndex, this.historyRolloverCheckPeriod, "management");
        }
        catch (Exception e) {
            logger.error("Error creating ISM history index.", (Throwable)e);
        }
    }

    public void offClusterManager() {
        if (this.scheduledRollover != null) {
            this.scheduledRollover.cancel();
        }
    }

    private void rescheduleRollover() {
        if (this.clusterService.state().nodes().isLocalNodeElectedClusterManager()) {
            if (this.scheduledRollover != null) {
                this.scheduledRollover.cancel();
            }
            this.scheduledRollover = this.threadPool.scheduleWithFixedDelay(this::rolloverAndDeleteHistoryIndex, this.historyRolloverCheckPeriod, "management");
        }
    }

    private void rolloverAndDeleteHistoryIndex() {
        try (ThreadContext.StoredContext ctx = this.threadPool.getThreadContext().stashContext();){
            if (this.threadPool.getThreadContext().getTransient("_opendistro_security_protected_indices_conf_request") == null) {
                this.threadPool.getThreadContext().putTransient("_opendistro_security_protected_indices_conf_request", (Object)"true");
            }
            if (this.historyEnabled) {
                this.rolloverHistoryIndex();
            }
            this.deleteOldHistoryIndex();
        }
    }

    private void rolloverHistoryIndex() {
        if (!this.indexManagementIndices.indexStateManagementIndexHistoryExists()) {
            return;
        }
        RolloverRequest request = new RolloverRequest(".opendistro-ism-managed-index-history-write", null);
        request.getCreateIndexRequest().index("<.opendistro-ism-managed-index-history-{now/d{yyyy.MM.dd}}-1>").mapping(IndexManagementIndices.indexStateManagementHistoryMappings).settings(Settings.builder().put("index.hidden", true).put("index.number_of_shards", this.historyNumberOfShards).put("index.number_of_replicas", this.historyNumberOfReplicas));
        request.addMaxIndexDocsCondition(this.historyMaxDocs);
        request.addMaxIndexAgeCondition(this.historyMaxAge);
        this.client.admin().indices().rolloverIndex(request, (ActionListener)new ActionListener<RolloverResponse>(this){

            public void onResponse(RolloverResponse response) {
                if (response.isRolledOver()) {
                    logger.info(".opendistro-ism-managed-index-history-write rolled over.");
                } else {
                    logger.info(".opendistro-ism-managed-index-history-write not rolled over. Conditions were: " + String.valueOf(response.getConditionStatus()));
                }
            }

            public void onFailure(Exception e) {
                logger.error(".opendistro-ism-managed-index-history-write roll over failed.", (Throwable)e);
            }
        });
    }

    private void deleteOldHistoryIndex() {
        ClusterStateRequest clusterStateRequest = ((ClusterStateRequest)new ClusterStateRequest().clear().indices(new String[]{".opendistro-ism-managed-index-history*"}).metadata(true).local(true)).indicesOptions(IndicesOptions.strictExpand());
        this.client.admin().cluster().state(clusterStateRequest, (ActionListener)new ActionListener<ClusterStateResponse>(){

            public void onResponse(ClusterStateResponse clusterStateResponse) {
                if (!clusterStateResponse.getState().metadata().indices().isEmpty()) {
                    List<String> indicesToDelete = IndexStateManagementHistory.this.getIndicesToDelete(clusterStateResponse);
                    logger.info("Deleting old history indices viz " + String.valueOf(indicesToDelete));
                    IndexStateManagementHistory.this.deleteAllOldHistoryIndices(indicesToDelete);
                } else {
                    logger.info("No Old History Indices to delete");
                }
            }

            public void onFailure(Exception exception) {
                logger.error("Error fetching cluster state " + exception.getMessage());
            }
        });
    }

    private List<String> getIndicesToDelete(ClusterStateResponse clusterStateResponse) {
        ArrayList<String> indicesToDelete = new ArrayList<String>();
        long currentTime = Instant.now().toEpochMilli();
        for (Map.Entry entry : clusterStateResponse.getState().metadata().indices().entrySet()) {
            boolean hasWriteAlias;
            IndexMetadata indexMetadata = (IndexMetadata)entry.getValue();
            long creationTime = indexMetadata.getCreationDate();
            if (currentTime - creationTime <= this.historyRetentionPeriod.millis() || (hasWriteAlias = indexMetadata.getAliases().values().stream().anyMatch(alias -> ".opendistro-ism-managed-index-history-write".equals(alias.alias()))) && this.historyEnabled) continue;
            indicesToDelete.add(indexMetadata.getIndex().getName());
        }
        return indicesToDelete;
    }

    private void deleteAllOldHistoryIndices(final List<String> indicesToDelete) {
        if (indicesToDelete.isEmpty()) {
            return;
        }
        DeleteIndexRequest deleteRequest = new DeleteIndexRequest(indicesToDelete.toArray(new String[0]));
        this.client.admin().indices().delete(deleteRequest, (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse deleteIndicesResponse) {
                if (!deleteIndicesResponse.isAcknowledged()) {
                    logger.error("Could not delete one or more ISM history index. " + String.valueOf(indicesToDelete) + ". Retrying one by one.");
                    IndexStateManagementHistory.this.deleteOldHistoryIndexOneByOne(indicesToDelete);
                }
            }

            public void onFailure(Exception exception) {
                logger.error("Error deleting old history indices " + exception.getMessage());
                IndexStateManagementHistory.this.deleteOldHistoryIndexOneByOne(indicesToDelete);
            }
        });
    }

    private void deleteOldHistoryIndexOneByOne(List<String> indicesToDelete) {
        for (final String index : indicesToDelete) {
            DeleteIndexRequest singleDeleteRequest = new DeleteIndexRequest(index);
            this.client.admin().indices().delete(singleDeleteRequest, (ActionListener)new ActionListener<AcknowledgedResponse>(){

                public void onResponse(AcknowledgedResponse singleDeleteResponse) {
                    if (!singleDeleteResponse.isAcknowledged()) {
                        logger.error("Could not delete ISM history index: " + index);
                    }
                }

                public void onFailure(Exception exception) {
                    logger.debug("Exception " + exception.getMessage() + " while deleting the index " + index);
                }
            });
        }
    }

    public void addManagedIndexMetaDataHistory(List<ManagedIndexMetaData> managedIndexMetaData) {
        if (!this.historyEnabled) {
            logger.debug("Index State Management history is not enabled");
            return;
        }
        if (!this.indexManagementIndices.checkAndUpdateHistoryIndex().join().booleanValue()) {
            logger.error("Failed to create or update the ism history index:");
            return;
        }
        List docWriteRequests = managedIndexMetaData.stream().filter(this::shouldAddManagedIndexMetaDataToHistory).map(this::createManagedIndexMetaDataHistoryIndexRequest).collect(Collectors.toList());
        if (docWriteRequests.isEmpty()) {
            return;
        }
        BulkRequest bulkRequest = new BulkRequest().add(docWriteRequests);
        this.client.bulk(bulkRequest, (ActionListener)new ActionListener<BulkResponse>(this){

            public void onResponse(BulkResponse bulkResponse) {
                for (BulkItemResponse bulkItemResponse : bulkResponse) {
                    if (!bulkItemResponse.isFailed()) continue;
                    logger.error("Failed to add history. Id: " + bulkItemResponse.getId() + ", failureMessage: " + bulkItemResponse.getFailureMessage());
                }
            }

            public void onFailure(Exception e) {
                logger.error("Failed to index indexMetaData History.", (Throwable)e);
            }
        });
    }

    private boolean shouldAddManagedIndexMetaDataToHistory(ManagedIndexMetaData managedIndexMetaData) {
        Step.StepStatus stepStatus = managedIndexMetaData.getStepMetaData() != null ? managedIndexMetaData.getStepMetaData().getStepStatus() : null;
        return stepStatus != Step.StepStatus.STARTING && stepStatus != Step.StepStatus.CONDITION_NOT_MET;
    }

    private IndexRequest createManagedIndexMetaDataHistoryIndexRequest(ManagedIndexMetaData managedIndexMetaData) {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder().startObject().startObject("managed_index_meta_data");
            managedIndexMetaData.toXContent(builder, ToXContent.EMPTY_PARAMS);
            builder.field("history_timestamp", Instant.now().toEpochMilli()).endObject().endObject();
            return new IndexRequest(".opendistro-ism-managed-index-history-write").source(builder);
        }
        catch (Exception e) {
            logger.error("Failed to create history index request", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

