/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement;

import io.lucenia.indexmanagement.IndexManagementIndices;
import io.lucenia.indexmanagement.common.retry.RetryUtils;
import io.lucenia.indexmanagement.indexstatemanagement.DefaultIndexMetadataService;
import io.lucenia.indexmanagement.indexstatemanagement.ISMCoordinatorSearchException;
import io.lucenia.indexmanagement.indexstatemanagement.IndexMetadataProvider;
import io.lucenia.indexmanagement.indexstatemanagement.model.ISMTemplate;
import io.lucenia.indexmanagement.indexstatemanagement.model.ManagedIndexConfig;
import io.lucenia.indexmanagement.indexstatemanagement.model.Policy;
import io.lucenia.indexmanagement.indexstatemanagement.settings.LegacyOpenDistroManagedIndexSettings;
import io.lucenia.indexmanagement.indexstatemanagement.settings.ManagedIndexSettings;
import io.lucenia.indexmanagement.indexstatemanagement.transport.action.managedIndex.ManagedIndexAction;
import io.lucenia.indexmanagement.indexstatemanagement.transport.action.managedIndex.ManagedIndexRequest;
import io.lucenia.indexmanagement.indexstatemanagement.util.ManagedIndexCoordinatorUtils;
import io.lucenia.indexmanagement.luceniaapi.IndexManagementSecurityContext;
import io.lucenia.indexmanagement.luceniaapi.LuceniaExtensions;
import io.lucenia.indexmanagement.luceniaapi.ParseUtils;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.SkyliteSecurityException;
import io.skylite.common.action.ActionListener;
import io.skylite.common.lifecycle.LifecycleListener;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.DocWriteRequest;
import io.skylite.core.action.bulk.BackoffPolicy;
import io.skylite.core.action.bulk.BulkItemResponse;
import io.skylite.core.action.bulk.BulkRequest;
import io.skylite.core.action.bulk.BulkResponse;
import io.skylite.core.action.get.MultiGetItemResponse;
import io.skylite.core.action.get.MultiGetRequest;
import io.skylite.core.action.get.MultiGetResponse;
import io.skylite.core.action.search.ClearScrollAction;
import io.skylite.core.action.search.ClearScrollRequest;
import io.skylite.core.action.search.SearchPhaseExecutionException;
import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.action.search.SearchScrollRequest;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.metadata.IndexAbstraction;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.routing.Preference;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.ClusterStateChangedEvent;
import io.skylite.core.cluster.state.ClusterStateListener;
import io.skylite.core.common.concurrent.SkyliteExecutors;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.regex.Regex;
import io.skylite.core.index.Index;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.core.security.auth.User;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.Scheduler;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.indexmanagement.model.ISMIndexMetadata;
import io.skylite.indexmanagement.model.ManagedIndexMetaData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.index.query.QueryBuilders;

public class ManagedIndexCoordinator
extends LifecycleListener
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(ManagedIndexCoordinator.class);
    public static final int MAX_HITS = 10000;
    private static final long BUFFER = 20L;
    private final Settings settings;
    private final Client client;
    private final ClusterService clusterService;
    private final ThreadPool threadPool;
    private final IndexManagementIndices ismIndices;
    private final IndexMetadataProvider indexMetadataProvider;
    private final NamedXContentRegistry xContentRegistry;
    private final ExecutorService executorService;
    private volatile Scheduler.Cancellable scheduledFullSweep;
    private volatile long lastFullSweepTimeNano = System.nanoTime();
    private volatile boolean indexStateManagementEnabled;
    private volatile TimeValue sweepPeriod;
    private volatile BackoffPolicy retryPolicy;
    private volatile int jobInterval;
    private volatile double jobJitter;
    private volatile boolean isClusterManager = false;
    private volatile long onClusterManagerTimeStamp = 0L;
    private static final String ISM_TEMPLATE_FIELD = "policy.ism_template";

    public ManagedIndexCoordinator(Settings settings, Client client, ClusterService clusterService, ThreadPool threadPool, IndexManagementIndices indexManagementIndices, IndexMetadataProvider indexMetadataProvider, NamedXContentRegistry xContentRegistry) {
        this.settings = settings;
        this.client = client;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.ismIndices = indexManagementIndices;
        this.indexMetadataProvider = indexMetadataProvider;
        this.xContentRegistry = xContentRegistry;
        this.executorService = SkyliteExecutors.newScaling((String)"ism-coordinator", (int)0, (int)Runtime.getRuntime().availableProcessors(), (long)5L, (TimeUnit)TimeUnit.MINUTES, (ThreadFactory)SkyliteExecutors.daemonThreadFactory((String)"ism-coordinator"), (ThreadContext)threadPool.getThreadContext());
        this.indexStateManagementEnabled = (Boolean)ManagedIndexSettings.INDEX_STATE_MANAGEMENT_ENABLED.get(settings);
        this.sweepPeriod = (TimeValue)ManagedIndexSettings.SWEEP_PERIOD.get(settings);
        this.retryPolicy = BackoffPolicy.constantBackoff((TimeValue)((TimeValue)ManagedIndexSettings.COORDINATOR_BACKOFF_MILLIS.get(settings)), (int)((Integer)ManagedIndexSettings.COORDINATOR_BACKOFF_COUNT.get(settings)));
        this.jobInterval = (Integer)ManagedIndexSettings.JOB_INTERVAL.get(settings);
        this.jobJitter = (Double)ManagedIndexSettings.JITTER.get(settings);
        clusterService.addListener((ClusterStateListener)this);
        clusterService.addLifecycleListener((LifecycleListener)this);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(ManagedIndexSettings.SWEEP_PERIOD, value -> {
            this.sweepPeriod = value;
            this.initBackgroundSweep();
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(ManagedIndexSettings.JOB_INTERVAL, value -> {
            this.jobInterval = value;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(ManagedIndexSettings.JITTER, value -> {
            this.jobJitter = value;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(ManagedIndexSettings.INDEX_STATE_MANAGEMENT_ENABLED, value -> {
            this.indexStateManagementEnabled = value;
            if (!this.indexStateManagementEnabled) {
                this.disable();
            } else {
                this.enable();
            }
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(ManagedIndexSettings.COORDINATOR_BACKOFF_MILLIS, ManagedIndexSettings.COORDINATOR_BACKOFF_COUNT, (millis, count) -> {
            this.retryPolicy = BackoffPolicy.constantBackoff((TimeValue)millis, (int)count);
        });
    }

    private String executorName() {
        return "management";
    }

    public void onClusterManager() {
        this.onClusterManagerTimeStamp = System.currentTimeMillis();
        logger.info("Cache cluster manager node onClusterManager time: " + this.onClusterManagerTimeStamp);
        this.initBackgroundSweep();
    }

    public void offClusterManager() {
        if (this.scheduledFullSweep != null) {
            this.scheduledFullSweep.cancel();
        }
    }

    public void clusterChanged(ClusterStateChangedEvent event) {
        if (this.isClusterManager != event.localNodeClusterManager()) {
            this.isClusterManager = event.localNodeClusterManager();
            if (this.isClusterManager) {
                this.onClusterManager();
            } else {
                this.offClusterManager();
            }
        }
        if (!this.isIndexStateManagementEnabled()) {
            return;
        }
        if (event.isNewCluster()) {
            return;
        }
        if (!event.localNodeClusterManager()) {
            return;
        }
        if (!event.metadataChanged()) {
            return;
        }
        CompletableFuture.runAsync(() -> this.sweepClusterChangedEvent(event), this.executorService);
    }

    public void afterStart() {
        this.initBackgroundSweep();
    }

    public void beforeStop() {
        if (this.scheduledFullSweep != null) {
            this.scheduledFullSweep.cancel();
        }
    }

    private void enable() {
        this.initBackgroundSweep();
        this.indexStateManagementEnabled = true;
        CompletableFuture.runAsync(() -> {
            try {
                logger.debug("Re-enabling jobs for managed indices");
                this.reenableJobs();
            }
            catch (Exception e) {
                logger.error("Failed to re-enable jobs for managed indices", (Throwable)e);
            }
        }, this.executorService);
    }

    private void disable() {
        if (this.scheduledFullSweep != null) {
            this.scheduledFullSweep.cancel();
        }
        this.indexStateManagementEnabled = false;
    }

    private void reenableJobs() {
        if (!this.ismIndices.indexManagementIndexExists()) {
            return;
        }
        List<String> currentManagedIndexUuids = this.sweepManagedIndexJobs(this.client);
        List<LuceniaExtensions.Pair<ManagedIndexMetaData, Exception>> metadataList = LuceniaExtensions.mgetManagedIndexMetadata(this.client, currentManagedIndexUuids).join();
        ArrayList managedIndicesToEnableReq = new ArrayList();
        for (LuceniaExtensions.Pair<ManagedIndexMetaData, Exception> pair : metadataList) {
            ManagedIndexMetaData metadata = pair.getFirst();
            if (metadata == null || ManagedIndexCoordinatorUtils.isPolicyCompleted(metadata) || ManagedIndexCoordinatorUtils.isFailed(metadata)) continue;
            managedIndicesToEnableReq.add((DocWriteRequest<?>)ManagedIndexCoordinatorUtils.updateEnableManagedIndexRequest(metadata.getIndexUuid()));
        }
        this.updateManagedIndices(managedIndicesToEnableReq);
    }

    private boolean isIndexStateManagementEnabled() {
        return this.indexStateManagementEnabled;
    }

    public void sweepClusterChangedEvent(ClusterStateChangedEvent event) {
        if (!this.ismIndices.indexManagementIndexExists()) {
            logger.debug("[.opendistro-ism-config] config index does not exist");
            return;
        }
        List<Object> removeManagedIndexReq = new ArrayList();
        List<Object> indicesToClean = new ArrayList();
        if (!event.indicesDeleted().isEmpty()) {
            List<String> deletedUuids = event.indicesDeleted().stream().map(Index::getUUID).collect(Collectors.toList());
            Map<String, ManagedIndexConfig> managedIndices = this.getManagedIndices(deletedUuids);
            List<String> deletedNames = event.indicesDeleted().stream().map(Index::getName).collect(Collectors.toList());
            Set allIndicesUuid = this.indexMetadataProvider.getMultiTypeISMIndexMetadata(Collections.emptyList(), deletedNames).join().values().stream().flatMap(metadataMap -> metadataMap.values().stream()).map(ISMIndexMetadata::getIndexUuid).collect(Collectors.toSet());
            indicesToClean = event.indicesDeleted().stream().filter(index -> managedIndices.containsKey(index.getUUID()) && !allIndicesUuid.contains(index.getUUID())).collect(Collectors.toList());
            removeManagedIndexReq = indicesToClean.stream().map(index -> ManagedIndexCoordinatorUtils.deleteManagedIndexRequest(index.getUUID())).collect(Collectors.toList());
        }
        List<DocWriteRequest<?>> updateMatchingIndexReq = this.createManagedIndexRequests(event.state(), event.indicesCreated());
        ArrayList allRequests = new ArrayList();
        allRequests.addAll(updateMatchingIndexReq);
        allRequests.addAll(removeManagedIndexReq);
        this.updateManagedIndices(allRequests);
        List<DocWriteRequest<?>> clearMetadataRequests = indicesToClean.stream().map(index -> ManagedIndexCoordinatorUtils.deleteManagedIndexMetadataRequest(index.getUUID())).collect(Collectors.toList());
        this.clearManagedIndexMetaData(clearMetadataRequests);
    }

    private List<DocWriteRequest<?>> createManagedIndexRequests(ClusterState clusterState, List<String> indexNames) {
        ArrayList updateManagedIndexReqs = new ArrayList();
        if (indexNames.isEmpty()) {
            return updateManagedIndexReqs;
        }
        List<Policy> policiesWithTemplates = this.getPoliciesWithISMTemplates();
        Map<String, ISMIndexMetadata> ismIndicesMetadata = this.indexMetadataProvider.getISMIndexMetadataByType(indexNames).join();
        for (String indexName : indexNames) {
            DefaultIndexMetadataService defaultService = (DefaultIndexMetadataService)this.indexMetadataProvider.getServices().get("_default");
            IndexMetadata indexMetadata = clusterState.metadata().index(indexName);
            if (indexMetadata == null) continue;
            boolean wasOffCluster = !defaultService.getIndexUUID(indexMetadata).equals(indexMetadata.getIndexUUID());
            ISMIndexMetadata ismIndexMetadata = ismIndicesMetadata.get(indexName);
            String lookupName = this.findIndexLookupName(indexName, clusterState);
            if (lookupName == null || this.indexMetadataProvider.isUnManageableIndex(lookupName) || ismIndexMetadata == null || wasOffCluster) continue;
            long creationDate = ismIndexMetadata.getIndexCreationDate();
            String indexUuid = ismIndexMetadata.getIndexUuid();
            Policy matchingPolicy = this.findMatchingPolicy(lookupName, creationDate, policiesWithTemplates);
            if (matchingPolicy == null) continue;
            logger.info("Index [" + indexName + "] matched ISM policy template and will be managed by " + matchingPolicy.getId());
            updateManagedIndexReqs.add((DocWriteRequest<?>)ManagedIndexCoordinatorUtils.managedIndexConfigIndexRequest(indexName, indexUuid, matchingPolicy.getId(), this.jobInterval, matchingPolicy, this.jobJitter));
        }
        return updateManagedIndexReqs;
    }

    private String findIndexLookupName(String indexName, ClusterState clusterState) {
        boolean isDataStreamIndex;
        if (!clusterState.metadata().hasIndex(indexName)) {
            return null;
        }
        IndexMetadata indexMetadata = clusterState.metadata().index(indexName);
        String autoManageSetting = indexMetadata.getSettings().get(ManagedIndexSettings.AUTO_MANAGE.getKey());
        boolean autoManage = autoManageSetting == null || autoManageSetting.isBlank() ? ((Boolean)LegacyOpenDistroManagedIndexSettings.AUTO_MANAGE.get(indexMetadata.getSettings())).booleanValue() : ((Boolean)ManagedIndexSettings.AUTO_MANAGE.get(indexMetadata.getSettings())).booleanValue();
        if (!autoManage) {
            return null;
        }
        boolean isHiddenIndex = (Boolean)IndexMetadata.INDEX_HIDDEN_SETTING.get(indexMetadata.getSettings()) != false || indexName.startsWith(".");
        IndexAbstraction indexAbstraction = (IndexAbstraction)clusterState.metadata().getIndicesLookup().get(indexName);
        boolean bl = isDataStreamIndex = indexAbstraction != null && indexAbstraction.getParentDataStream() != null;
        if (!isDataStreamIndex && isHiddenIndex) {
            return null;
        }
        if (isDataStreamIndex) {
            return indexAbstraction.getParentDataStream().getName();
        }
        return indexName;
    }

    private Policy findMatchingPolicy(String indexName, long creationDate, List<Policy> policies) {
        HashMap<Integer, Policy> priorityPolicyMap = new HashMap<Integer, Policy>();
        for (Policy policy : policies) {
            int highestPriorityForPolicy = -1;
            if (policy.getISMTemplate() != null) {
                for (ISMTemplate template : policy.getISMTemplate()) {
                    boolean matches;
                    if (template.getLastUpdatedTime().toEpochMilli() >= creationDate || !(matches = template.getIndexPatterns().stream().anyMatch(pattern -> Regex.simpleMatch((String)pattern, (String)indexName))) || highestPriorityForPolicy >= template.getPriority()) continue;
                    highestPriorityForPolicy = template.getPriority();
                }
            }
            if (highestPriorityForPolicy <= -1) continue;
            priorityPolicyMap.put(highestPriorityForPolicy, policy);
        }
        HashSet<User> previouslyCheckedUsers = new HashSet<User>();
        List sortedPriorities = priorityPolicyMap.keySet().stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList());
        for (Integer priority : sortedPriorities) {
            Policy policy = (Policy)priorityPolicyMap.get(priority);
            if (!previouslyCheckedUsers.contains(policy.getUser()) && this.canPolicyManagedIndex(policy, indexName)) {
                return policy;
            }
            if (policy.getUser() == null) continue;
            previouslyCheckedUsers.add(policy.getUser());
        }
        logger.debug("Couldn't find any matching policy with appropriate permissions that can manage index " + indexName);
        return null;
    }

    private boolean canPolicyManagedIndex(Policy policy, String indexName) {
        if (policy.getUser() != null) {
            try {
                ManagedIndexRequest request = (ManagedIndexRequest)new ManagedIndexRequest(new String[0]).indices(new String[]{indexName});
                try (IndexManagementSecurityContext ignored = new IndexManagementSecurityContext("ApplyPolicyOnIndexCreation", this.settings, this.threadPool.getThreadContext(), policy.getUser());){
                    this.client.execute((ActionType)ManagedIndexAction.INSTANCE, (ActionRequest)request).actionGet();
                }
            }
            catch (SkyliteSecurityException e) {
                logger.debug("Skipping applying policy " + policy.getId() + " on " + indexName + " as the policy user is missing permissions", (Throwable)e);
                return false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    private List<Policy> getPoliciesWithISMTemplates() {
        String errorMessage = "Failed to get ISM policies with templates";
        SearchRequest searchRequest = new SearchRequest().source(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.existsQuery((String)ISM_TEMPLATE_FIELD)).size(10000).seqNoAndPrimaryTerm(Boolean.valueOf(true))).indices(new String[]{".opendistro-ism-config"}).preference(Preference.PRIMARY_FIRST.type());
        try {
            SearchResponse response = (SearchResponse)this.client.search(searchRequest).actionGet();
            return LuceniaExtensions.parseFromSearchResponse(response, this.xContentRegistry, Policy::parse);
        }
        catch (IndexNotFoundException ex) {
            return Collections.emptyList();
        }
        catch (ClusterBlockException ex) {
            logger.error(errorMessage);
            return Collections.emptyList();
        }
        catch (SearchPhaseExecutionException e) {
            logger.error(errorMessage + ": " + String.valueOf((Object)e));
            return Collections.emptyList();
        }
        catch (Exception e) {
            logger.error(errorMessage, (Throwable)e);
            return Collections.emptyList();
        }
    }

    public void initBackgroundSweep() {
        if (!this.isIndexStateManagementEnabled()) {
            return;
        }
        if (!this.clusterService.state().nodes().isLocalNodeElectedClusterManager()) {
            return;
        }
        if (this.scheduledFullSweep != null) {
            this.scheduledFullSweep.cancel();
        }
        Runnable scheduledSweep = () -> {
            TimeValue elapsedTime = this.getFullSweepElapsedTime();
            long delta = this.sweepPeriod.millis() - elapsedTime.millis();
            if (delta < 20L) {
                CompletableFuture.runAsync(() -> {
                    try {
                        logger.debug("Performing background sweep of managed indices");
                        this.sweep();
                    }
                    catch (Exception e) {
                        logger.error("Failed to sweep managed indices", (Throwable)e);
                    }
                }, this.executorService);
            }
        };
        this.scheduledFullSweep = this.threadPool.scheduleWithFixedDelay(scheduledSweep, this.sweepPeriod, this.executorName());
    }

    private TimeValue getFullSweepElapsedTime() {
        return TimeValue.timeValueNanos((long)(System.nanoTime() - this.lastFullSweepTimeNano));
    }

    public void sweep() {
        if (!this.ismIndices.indexManagementIndexExists()) {
            return;
        }
        List<String> currentManagedIndexUuids = this.sweepManagedIndexJobs(this.client);
        Map<String, ISMIndexMetadata> currentIndices = this.indexMetadataProvider.getISMIndexMetadataByType(List.of("*")).join();
        Map<String, ISMIndexMetadata> unManagedIndices = this.getUnManagedIndices(currentIndices, new HashSet<String>(currentManagedIndexUuids));
        List<DocWriteRequest<?>> updateMatchingIndicesReqs = this.createManagedIndexRequests(this.clusterService.state(), new ArrayList<String>(unManagedIndices.keySet()));
        List<String> allIndicesUuids = this.indexMetadataProvider.getAllISMIndexMetadata().join().stream().map(ISMIndexMetadata::getIndexUuid).collect(Collectors.toList());
        List<String> managedIndicesToDelete = ManagedIndexCoordinatorUtils.getManagedIndicesToDelete(allIndicesUuids, currentManagedIndexUuids);
        List deleteManagedIndexRequests = managedIndicesToDelete.stream().map(uuid -> ManagedIndexCoordinatorUtils.deleteManagedIndexRequest(uuid)).collect(Collectors.toList());
        ArrayList allRequests = new ArrayList();
        allRequests.addAll(updateMatchingIndicesReqs);
        allRequests.addAll(deleteManagedIndexRequests);
        this.updateManagedIndices(allRequests);
        ArrayList<String> indicesToDeleteMetadataFrom = new ArrayList<String>();
        indicesToDeleteMetadataFrom.addAll(unManagedIndices.values().stream().map(ISMIndexMetadata::getIndexUuid).collect(Collectors.toList()));
        indicesToDeleteMetadataFrom.addAll(managedIndicesToDelete);
        List<DocWriteRequest<?>> clearMetadataRequests = indicesToDeleteMetadataFrom.stream().map(uuid -> ManagedIndexCoordinatorUtils.deleteManagedIndexMetadataRequest(uuid)).collect(Collectors.toList());
        this.clearManagedIndexMetaData(clearMetadataRequests);
        this.lastFullSweepTimeNano = System.nanoTime();
    }

    private Map<String, ISMIndexMetadata> getUnManagedIndices(Map<String, ISMIndexMetadata> allIndices, Set<String> managedIndexUuids) {
        HashMap<String, ISMIndexMetadata> unManagedIndices = new HashMap<String, ISMIndexMetadata>();
        for (Map.Entry<String, ISMIndexMetadata> entry : allIndices.entrySet()) {
            if (managedIndexUuids.contains(entry.getValue().getIndexUuid())) continue;
            unManagedIndices.put(entry.getKey(), entry.getValue());
        }
        return unManagedIndices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> sweepManagedIndexJobs(Client client) {
        long totalHits;
        ArrayList<String> managedIndexUuids = new ArrayList<String>();
        SearchRequest countReq = ManagedIndexCoordinatorUtils.getSweptManagedIndexSearchRequest(0, false);
        SearchResponse countRes = (SearchResponse)client.search(countReq).actionGet();
        long l = totalHits = countRes.getHits().getTotalHits() != null ? countRes.getHits().getTotalHits().value() : 0L;
        if (totalHits >= 10000L) {
            HashSet<String> scrollIDsToClear = new HashSet<String>();
            try {
                SearchRequest managedIndexSearchRequest = ManagedIndexCoordinatorUtils.getSweptManagedIndexSearchRequest(10000, true);
                SearchResponse response = (SearchResponse)client.search(managedIndexSearchRequest).actionGet();
                List<String> uuids = this.transformManagedIndexSearchRes(response);
                while (!uuids.isEmpty()) {
                    managedIndexUuids.addAll(uuids);
                    String scrollID = response.getScrollId();
                    scrollIDsToClear.add(scrollID);
                    SearchScrollRequest scrollRequest = new SearchScrollRequest().scrollId(scrollID).scroll(TimeValue.timeValueMinutes((long)1L));
                    response = (SearchResponse)client.searchScroll(scrollRequest).actionGet();
                    uuids = this.transformManagedIndexSearchRes(response);
                }
            }
            finally {
                if (!scrollIDsToClear.isEmpty()) {
                    ClearScrollRequest clearScrollRequest = new ClearScrollRequest();
                    clearScrollRequest.scrollIds(new ArrayList(scrollIDsToClear));
                    client.execute((ActionType)ClearScrollAction.INSTANCE, (ActionRequest)clearScrollRequest).actionGet();
                }
            }
            return managedIndexUuids;
        }
        SearchResponse response = (SearchResponse)client.search(ManagedIndexCoordinatorUtils.getSweptManagedIndexSearchRequest(10000, false)).actionGet();
        return this.transformManagedIndexSearchRes(response);
    }

    public List<String> transformManagedIndexSearchRes(SearchResponse response) {
        if (response.isTimedOut() || response.getFailedShards() > 0 || response.getSkippedShards() > 0) {
            String errorMsg = "Sweep managed indices failed. Timed out: " + response.isTimedOut() + " | Failed shards: " + response.getFailedShards() + " | Skipped shards: " + response.getSkippedShards() + ".";
            logger.error(errorMsg);
            throw new ISMCoordinatorSearchException(errorMsg);
        }
        return Arrays.stream(response.getHits().getHits()).map(hit -> hit.getId()).collect(Collectors.toList());
    }

    private Map<String, ManagedIndexConfig> getManagedIndices(List<String> indexUuids) {
        if (indexUuids.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, ManagedIndexConfig> result = new HashMap<String, ManagedIndexConfig>();
        MultiGetRequest mReq = new MultiGetRequest();
        indexUuids.forEach(uuid -> mReq.add(".opendistro-ism-config", uuid));
        MultiGetResponse mRes = (MultiGetResponse)this.client.multiGet(mReq).actionGet();
        if (mRes.getResponses().length > 0 && mRes.getResponses()[0].isFailed()) {
            logger.error("Get managed-index failed: " + String.valueOf(mRes.getResponses()[0].getFailure().getFailure()));
            return result;
        }
        for (MultiGetItemResponse item : mRes.getResponses()) {
            if (!item.getResponse().isExists()) continue;
            try {
                ManagedIndexConfig config = ParseUtils.parseWithType(LuceniaExtensions.contentParser(item.getResponse().getSourceAsBytesRef(), this.xContentRegistry), item.getResponse().getId(), item.getResponse().getSeqNo(), item.getResponse().getPrimaryTerm(), ManagedIndexConfig::parse);
                result.put(item.getId(), config);
            }
            catch (Exception e) {
                logger.error("Failed to parse managed index config", (Throwable)e);
            }
        }
        return result;
    }

    public void updateManagedIndices(List<DocWriteRequest<?>> requests) {
        final ArrayList requestsToRetry = new ArrayList(requests);
        if (requestsToRetry.isEmpty()) {
            return;
        }
        try {
            RetryUtils.retry(logger, this.retryPolicy, listener -> {
                final BulkRequest bulkRequest = new BulkRequest().add((Iterable)requestsToRetry);
                this.client.bulk(bulkRequest, (ActionListener)new ActionListener<BulkResponse>(this){

                    public void onResponse(BulkResponse bulkResponse) {
                        Optional<BulkItemResponse> firstFailed;
                        ArrayList<Integer> failedIndices = new ArrayList<Integer>();
                        for (int i = 0; i < bulkResponse.getItems().length; ++i) {
                            if (!bulkResponse.getItems()[i].isFailed() || bulkResponse.getItems()[i].status() != RestStatus.TOO_MANY_REQUESTS) continue;
                            failedIndices.add(i);
                        }
                        requestsToRetry.clear();
                        for (Integer idx : failedIndices) {
                            requestsToRetry.add((DocWriteRequest)bulkRequest.requests().get(idx));
                        }
                        if (!requestsToRetry.isEmpty() && (firstFailed = Arrays.stream(bulkResponse.getItems()).filter(item -> item.status() == RestStatus.TOO_MANY_REQUESTS).findFirst()).isPresent()) {
                            listener.onFailure((Exception)((Object)SkyliteExceptionsHelper.convertToOpenSearchException((Exception)firstFailed.get().getFailure().getCause())));
                            return;
                        }
                        listener.onResponse((Object)bulkResponse);
                    }

                    public void onFailure(Exception e) {
                        listener.onFailure(e);
                    }
                });
            }, new ActionListener<BulkResponse>(this){

                public void onResponse(BulkResponse response) {
                }

                public void onFailure(Exception e) {
                    logger.error("Failed to update managed indices", (Throwable)e);
                }
            });
        }
        catch (Exception e) {
            logger.error("Failed to update managed indices", (Throwable)e);
        }
    }

    public void clearManagedIndexMetaData(List<DocWriteRequest<?>> deleteRequests) {
        if (!this.ismIndices.indexManagementIndexExists()) {
            return;
        }
        try {
            if (deleteRequests.isEmpty()) {
                return;
            }
            RetryUtils.retry(logger, this.retryPolicy, listener -> {
                BulkRequest bulkRequest = new BulkRequest().add((Iterable)deleteRequests);
                this.client.bulk(bulkRequest, listener);
            }, new ActionListener<BulkResponse>(this){

                public void onResponse(BulkResponse bulkResponse) {
                    for (BulkItemResponse item : bulkResponse) {
                        if (!item.isFailed()) continue;
                        logger.error("Failed to clear ManagedIndexMetadata for index uuid: [" + item.getId() + "], failureMessage: " + item.getFailureMessage());
                    }
                }

                public void onFailure(Exception e) {
                    logger.error("Failed to clear ManagedIndexMetadata", (Throwable)e);
                }
            });
        }
        catch (Exception e) {
            logger.error("Failed to clear ManagedIndexMetadata", (Throwable)e);
        }
    }

    public static class Pair<F, S> {
        private final F first;
        private final S second;

        public Pair(F first, S second) {
            this.first = first;
            this.second = second;
        }

        public F getFirst() {
            return this.first;
        }

        public S getSecond() {
            return this.second;
        }
    }
}

