/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement;

import io.lucenia.indexmanagement.IndexManagementIndices;
import io.lucenia.indexmanagement.common.retry.RetryUtils;
import io.lucenia.indexmanagement.indexstatemanagement.DefaultIndexMetadataService;
import io.lucenia.indexmanagement.indexstatemanagement.ExtensionStatusChecker;
import io.lucenia.indexmanagement.indexstatemanagement.ISMActionsParser;
import io.lucenia.indexmanagement.indexstatemanagement.IndexMetadataProvider;
import io.lucenia.indexmanagement.indexstatemanagement.IndexStateManagementHistory;
import io.lucenia.indexmanagement.indexstatemanagement.SkipExecution;
import io.lucenia.indexmanagement.indexstatemanagement.model.ChangePolicy;
import io.lucenia.indexmanagement.indexstatemanagement.model.ErrorNotification;
import io.lucenia.indexmanagement.indexstatemanagement.model.ManagedIndexConfig;
import io.lucenia.indexmanagement.indexstatemanagement.model.Policy;
import io.lucenia.indexmanagement.indexstatemanagement.model.State;
import io.lucenia.indexmanagement.indexstatemanagement.settings.ManagedIndexSettings;
import io.lucenia.indexmanagement.indexstatemanagement.util.ManagedIndexUtils;
import io.lucenia.indexmanagement.indexstatemanagement.util.NotificationUtils;
import io.lucenia.indexmanagement.indexstatemanagement.validation.ActionValidation;
import io.lucenia.indexmanagement.luceniaapi.IndexManagementSecurityContext;
import io.lucenia.indexmanagement.luceniaapi.LuceniaExtensions;
import io.lucenia.indexmanagement.luceniaapi.ParseUtils;
import io.skylite.common.action.ActionListener;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.admin.cluster.state.ClusterStateRequest;
import io.skylite.core.action.admin.cluster.state.ClusterStateResponse;
import io.skylite.core.action.bulk.BackoffPolicy;
import io.skylite.core.action.bulk.BulkItemResponse;
import io.skylite.core.action.bulk.BulkRequest;
import io.skylite.core.action.bulk.BulkResponse;
import io.skylite.core.action.get.GetRequest;
import io.skylite.core.action.get.GetResponse;
import io.skylite.core.action.index.IndexRequest;
import io.skylite.core.action.index.IndexResponse;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.action.update.UpdateRequest;
import io.skylite.core.action.update.UpdateResponse;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.health.ClusterHealthStatus;
import io.skylite.core.cluster.health.ClusterStateHealth;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.concurrent.SkyliteExecutors;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.jobs.JobExecutionContext;
import io.skylite.core.jobs.LockModel;
import io.skylite.core.jobs.LockServiceInterface;
import io.skylite.core.jobs.ScheduledJobParameter;
import io.skylite.core.jobs.schedule.Schedule;
import io.skylite.core.notifications.legacy.destination.message.LegacyBaseMessage;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.script.Script;
import io.skylite.core.script.ScriptService;
import io.skylite.core.script.TemplateScript;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentHelper;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.indexmanagement.Action;
import io.skylite.indexmanagement.Step;
import io.skylite.indexmanagement.Validate;
import io.skylite.indexmanagement.metrics.IndexManagementActionsMetrics;
import io.skylite.indexmanagement.model.ActionMetaData;
import io.skylite.indexmanagement.model.ISMIndexMetadata;
import io.skylite.indexmanagement.model.ManagedIndexMetaData;
import io.skylite.indexmanagement.model.PolicyRetryInfoMetaData;
import io.skylite.indexmanagement.model.StateMetaData;
import io.skylite.indexmanagement.model.StepContext;
import io.skylite.indexmanagement.model.StepMetaData;
import io.skylite.indexmanagement.model.ValidationResult;
import io.skylite.jobs.ScheduledJobRunner;
import io.skylite.jobs.schedule.IntervalSchedule;
import java.lang.invoke.CallSite;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ManagedIndexRunner
implements ScheduledJobRunner {
    private static final Logger logger = LogManager.getLogger(ManagedIndexRunner.class);
    public static final ManagedIndexRunner INSTANCE = new ManagedIndexRunner();
    private final BackoffPolicy savePolicyRetryPolicy = BackoffPolicy.exponentialBackoff((TimeValue)TimeValue.timeValueMillis((long)250L), (int)3);
    private final BackoffPolicy updateMetaDataRetryPolicy = BackoffPolicy.exponentialBackoff((TimeValue)TimeValue.timeValueMillis((long)250L), (int)3);
    private final BackoffPolicy errorNotificationRetryPolicy = BackoffPolicy.exponentialBackoff((TimeValue)TimeValue.timeValueMillis((long)250L), (int)3);
    private ExecutorService executorService;
    private ClusterService clusterService;
    private Client client;
    private NamedXContentRegistry xContentRegistry;
    private ScriptService scriptService;
    private Settings settings;
    private IndexManagementIndices imIndices;
    public ActionValidation actionValidation;
    private IndexStateManagementHistory ismHistory;
    private SkipExecution skipExecFlag;
    private ThreadPool threadPool;
    private ExtensionStatusChecker extensionStatusChecker;
    public IndexManagementActionsMetrics indexManagementActionMetrics;
    private IndexMetadataProvider indexMetadataProvider;
    private volatile boolean indexStateManagementEnabled = true;
    private volatile boolean validationServiceEnabled = false;
    private volatile int jobInterval = 5;
    private volatile List<String> allowList = ManagedIndexSettings.ALLOW_LIST_NONE;

    private ManagedIndexRunner() {
    }

    public ManagedIndexRunner registerClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
        return this;
    }

    public ManagedIndexRunner registerClient(Client client) {
        this.client = client;
        return this;
    }

    public ManagedIndexRunner registerNamedXContentRegistry(NamedXContentRegistry xContentRegistry) {
        this.xContentRegistry = xContentRegistry;
        return this;
    }

    public ManagedIndexRunner registerScriptService(ScriptService scriptService) {
        this.scriptService = scriptService;
        return this;
    }

    public ManagedIndexRunner registerSettings(Settings settings) {
        this.settings = settings;
        return this;
    }

    public ManagedIndexRunner registerConsumers() {
        if (this.executorService == null) {
            this.executorService = SkyliteExecutors.newScaling((String)"ism-runner", (int)0, (int)Math.max(4, Runtime.getRuntime().availableProcessors()), (long)30L, (TimeUnit)TimeUnit.SECONDS, (ThreadFactory)SkyliteExecutors.daemonThreadFactory((String)"ism-runner"), (ThreadContext)this.threadPool.getThreadContext());
        }
        this.jobInterval = (Integer)ManagedIndexSettings.JOB_INTERVAL.get(this.settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(ManagedIndexSettings.JOB_INTERVAL, value -> {
            this.jobInterval = value;
        });
        this.indexStateManagementEnabled = (Boolean)ManagedIndexSettings.INDEX_STATE_MANAGEMENT_ENABLED.get(this.settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(ManagedIndexSettings.INDEX_STATE_MANAGEMENT_ENABLED, value -> {
            this.indexStateManagementEnabled = value;
        });
        this.validationServiceEnabled = (Boolean)ManagedIndexSettings.ACTION_VALIDATION_ENABLED.get(this.settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(ManagedIndexSettings.ACTION_VALIDATION_ENABLED, value -> {
            this.validationServiceEnabled = value;
        });
        this.allowList = (List)ManagedIndexSettings.ALLOW_LIST.get(this.settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(ManagedIndexSettings.ALLOW_LIST, value -> {
            this.allowList = value;
        });
        return this;
    }

    public ManagedIndexRunner registerIMIndex(IndexManagementIndices imIndices) {
        this.imIndices = imIndices;
        return this;
    }

    public ManagedIndexRunner registerValidationService(ActionValidation actionValidation) {
        this.actionValidation = actionValidation;
        return this;
    }

    public ManagedIndexRunner registerHistoryIndex(IndexStateManagementHistory ismHistory) {
        this.ismHistory = ismHistory;
        return this;
    }

    public ManagedIndexRunner registerSkipFlag(SkipExecution flag) {
        this.skipExecFlag = flag;
        return this;
    }

    public ManagedIndexRunner registerThreadPool(ThreadPool threadPool) {
        this.threadPool = threadPool;
        return this;
    }

    public ManagedIndexRunner registerIndexMetadataProvider(IndexMetadataProvider indexMetadataProvider) {
        this.indexMetadataProvider = indexMetadataProvider;
        return this;
    }

    public ManagedIndexRunner registerExtensionChecker(ExtensionStatusChecker extensionStatusChecker) {
        this.extensionStatusChecker = extensionStatusChecker;
        return this;
    }

    public ManagedIndexRunner registerIndexManagementActionMetrics(IndexManagementActionsMetrics indexManagementActionsMetrics) {
        this.indexManagementActionMetrics = indexManagementActionsMetrics;
        return this;
    }

    public void runJob(ScheduledJobParameter job, final JobExecutionContext context) {
        if (!(job instanceof ManagedIndexConfig)) {
            throw new IllegalArgumentException("Invalid job type, found " + job.getClass().getSimpleName() + " with id: " + context.getJobId());
        }
        final ManagedIndexConfig managedIndexConfig = (ManagedIndexConfig)job;
        logger.info("ManagedIndexRunner.runJob starting for index: {}, jobId: {}", (Object)managedIndexConfig.getIndex(), (Object)context.getJobId());
        final CompletableFuture jobFuture = new CompletableFuture();
        if (this.skipExecFlag.getFlag()) {
            logger.info("Cluster still has nodes running old version ISM plugin, skip execution on new nodes until all nodes upgraded");
            jobFuture.complete(null);
        } else {
            logger.info("ManagedIndexRunner: About to acquire lock for index: {}", (Object)managedIndexConfig.getIndex());
            context.getLockService().acquireLock(job, context, (ActionListener)new ActionListener<LockModel>(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void onResponse(LockModel lock) {
                    logger.info("ManagedIndexRunner: Lock acquisition onResponse called for index: {}, lock: {}", (Object)managedIndexConfig.getIndex(), (Object)lock);
                    if (lock == null) {
                        logger.info("Could not acquire lock for " + managedIndexConfig.getIndex());
                        jobFuture.complete(null);
                        return;
                    }
                    logger.info("ManagedIndexRunner: Lock acquired successfully for index: {}, lockId: {}", (Object)managedIndexConfig.getIndex(), (Object)lock.getLockId());
                    try {
                        ManagedIndexRunner.this.runManagedIndexConfig(managedIndexConfig, context);
                    }
                    catch (Exception e) {
                        try {
                            logger.error("Error running managed index config", (Throwable)e);
                        }
                        catch (Throwable throwable) {
                            context.getLockService().release(lock, (ActionListener)new ActionListener<Boolean>(){
                                final /* synthetic */ LockModel val$lock;
                                {
                                    this.val$lock = lockModel;
                                }

                                public void onResponse(Boolean released) {
                                    if (!released.booleanValue()) {
                                        logger.debug("Could not release lock [" + this.val$lock.getLockId() + "] for " + managedIndexConfig.getIndex());
                                    }
                                    jobFuture.complete(null);
                                }

                                public void onFailure(Exception e) {
                                    logger.error("Failed to release lock [" + this.val$lock.getLockId() + "] for " + managedIndexConfig.getIndex(), (Throwable)e);
                                    jobFuture.completeExceptionally(e);
                                }
                            });
                            throw throwable;
                        }
                        context.getLockService().release(lock, (ActionListener)new /* invalid duplicate definition of identical inner class */);
                        return;
                    }
                    context.getLockService().release(lock, (ActionListener)new /* invalid duplicate definition of identical inner class */);
                    return;
                }

                public void onFailure(Exception e) {
                    logger.error("ManagedIndexRunner: Lock acquisition onFailure called for index: " + managedIndexConfig.getIndex(), (Throwable)e);
                    jobFuture.completeExceptionally(e);
                }
            });
        }
        try {
            jobFuture.join();
            logger.info("ManagedIndexRunner.runJob completed for index: {}", (Object)managedIndexConfig.getIndex());
        }
        catch (CompletionException e) {
            Throwable cause = e.getCause() != null ? e.getCause() : e;
            logger.error("Error waiting for job completion for index: " + managedIndexConfig.getIndex(), cause);
        }
        catch (Exception e) {
            logger.error("Error waiting for job completion for index: " + managedIndexConfig.getIndex(), (Throwable)e);
        }
    }

    private void runManagedIndexConfig(ManagedIndexConfig managedIndexConfig, JobExecutionContext jobContext) {
        String actionExtensionName;
        Pair<Boolean, Long> shouldBackOff;
        ActionMetaData currentActionMetaData;
        List<String> nonDefaultTypes;
        Map<String, Map<String, ISMIndexMetadata>> multiTypeMetadata;
        boolean someTypeMatchedUuid;
        String clusterStateIndexUUID;
        logger.info("ManagedIndexRunner.runManagedIndexConfig starting for index: {}", (Object)managedIndexConfig.getIndex());
        if (this.clusterIsRed()) {
            logger.debug("Skipping current execution of " + managedIndexConfig.getIndex() + " because of red cluster health");
            return;
        }
        logger.info("ManagedIndexRunner: About to call getManagedIndexMetadata for index {}", (Object)managedIndexConfig.getIndex());
        LuceniaExtensions.Pair<ManagedIndexMetaData, Boolean> metadataResult = LuceniaExtensions.getManagedIndexMetadata(this.client, managedIndexConfig.getIndexUuid()).join();
        logger.info("ManagedIndexRunner: getManagedIndexMetadata returned for index {}, success: {}", (Object)managedIndexConfig.getIndex(), (Object)metadataResult.getSecond());
        ManagedIndexMetaData managedIndexMetaData = metadataResult.getFirst();
        boolean getMetadataSuccess = metadataResult.getSecond();
        if (!getMetadataSuccess) {
            logger.info("Failed to retrieve managed index metadata of index [" + managedIndexConfig.getIndex() + "] from config index, abort this run.");
            return;
        }
        logger.info("ManagedIndexRunner: Checking index metadata for index {}", (Object)managedIndexConfig.getIndex());
        IndexMetadata clusterStateIndexMetadata = this.getIndexMetadata(managedIndexConfig.getIndex());
        DefaultIndexMetadataService defaultService = (DefaultIndexMetadataService)this.indexMetadataProvider.getServices().get("_default");
        String string = clusterStateIndexUUID = clusterStateIndexMetadata != null ? defaultService.getIndexUUID(clusterStateIndexMetadata) : null;
        if (!(clusterStateIndexMetadata != null && clusterStateIndexUUID.equals(managedIndexConfig.getIndexUuid()) || (someTypeMatchedUuid = (multiTypeMetadata = this.indexMetadataProvider.getMultiTypeISMIndexMetadata(nonDefaultTypes = this.indexMetadataProvider.getServices().keySet().stream().filter(type -> !type.equals("_default")).collect(Collectors.toList()), List.of(managedIndexConfig.getIndex())).join()).values().stream().anyMatch(map -> {
            ISMIndexMetadata metadata = (ISMIndexMetadata)map.get(managedIndexConfig.getIndex());
            return metadata != null && metadata.getIndexUuid().equals(managedIndexConfig.getIndexUuid());
        })))) {
            logger.warn("Failed to find IndexMetadata for " + managedIndexConfig.getIndex());
            return;
        }
        if (managedIndexMetaData == null) {
            logger.info("ManagedIndexRunner: metadata is null for index {}, calling initManagedIndex", (Object)managedIndexConfig.getIndex());
            this.initManagedIndex(managedIndexConfig);
            return;
        }
        logger.info("ManagedIndexRunner: metadata exists for index {}, proceeding with policy execution", (Object)managedIndexConfig.getIndex());
        if (Boolean.TRUE.equals(managedIndexMetaData.getPolicyCompleted()) || ManagedIndexUtils.isFailed(managedIndexMetaData)) {
            logger.info("ManagedIndexRunner: calling disableManagedIndexConfig for index {}", (Object)managedIndexConfig.getIndex());
            this.disableManagedIndexConfig(managedIndexConfig);
            return;
        }
        Policy policy = managedIndexConfig.getPolicy();
        if (ManagedIndexUtils.hasDifferentPolicyVersion(managedIndexMetaData, managedIndexConfig)) {
            Map<String, String> info = Map.of("message", "There is a version conflict between your previous execution and your managed index");
            ManagedIndexMetaData updatedMetadata = new ManagedIndexMetaData.Builder(managedIndexMetaData).policyRetryInfo(new PolicyRetryInfoMetaData(true, 0)).info(info).build();
            UpdateMetadataResult result = this.updateManagedIndexMetaData(updatedMetadata, null, false);
            if (result.metadataSaved) {
                this.disableManagedIndexConfig(managedIndexConfig);
                this.publishErrorNotification(policy, managedIndexMetaData);
            }
            logger.info("ManagedIndexRunner: There's a version conflict between previous execution and managed index {}", (Object)managedIndexConfig.getIndex());
            return;
        }
        State state = policy.getStateToExecute(managedIndexMetaData);
        logger.info("ManagedIndexRunner: state={} for index={}", (Object)(state != null ? state.getName() : "null"), (Object)managedIndexConfig.getIndex());
        Action action = state != null ? state.getActionToExecute(managedIndexMetaData, this.indexMetadataProvider) : null;
        logger.info("ManagedIndexRunner: action={} for index={}", (Object)(action != null ? action.getType() : "null"), (Object)managedIndexConfig.getIndex());
        StepContext stepContext = new StepContext(managedIndexMetaData, this.clusterService, this.client, this.threadPool.getThreadContext(), policy.getUser(), this.scriptService, this.settings, (LockServiceInterface)jobContext.getLockService());
        Step step = action != null ? action.getStepToExecute(stepContext) : null;
        logger.info("ManagedIndexRunner: step={} for index={}", (Object)(step != null ? step.getName() : "null"), (Object)managedIndexConfig.getIndex());
        ActionMetaData actionMetaData = currentActionMetaData = action != null ? action.getUpdatedActionMetadata(managedIndexMetaData, state.getName()) : null;
        if (!this.indexStateManagementEnabled && step != null && step.isSafeToDisableOn()) {
            this.disableManagedIndexConfig(managedIndexConfig);
            return;
        }
        if (action != null && ManagedIndexUtils.hasTimedOut(action, currentActionMetaData)) {
            Map<String, String> info = Map.of("message", "Action timed out");
            logger.error("Action=" + action.getType() + " has timed out");
            ActionMetaData updatedActionMetaData = currentActionMetaData != null ? new ActionMetaData.Builder(currentActionMetaData).failed(true).build() : null;
            ManagedIndexMetaData updatedIndexMetaData = new ManagedIndexMetaData.Builder(managedIndexMetaData).actionMetaData(updatedActionMetaData).stepMetaData(step != null ? new StepMetaData(step.getName(), System.currentTimeMillis(), Step.StepStatus.TIMED_OUT) : null).info(info).build();
            UpdateMetadataResult updated = this.updateManagedIndexMetaData(updatedIndexMetaData, null, false);
            if (updated.metadataSaved) {
                this.disableManagedIndexConfig(managedIndexConfig);
                this.publishErrorNotification(policy, updatedIndexMetaData);
            }
            return;
        }
        if (ManagedIndexUtils.shouldChangePolicy(managedIndexConfig, action)) {
            logger.info("ManagedIndexRunner: policy change is needed for index {}", (Object)managedIndexConfig.getIndex());
            this.initChangePolicy(managedIndexConfig, managedIndexMetaData, action);
            return;
        }
        if (action != null && Boolean.TRUE.equals((shouldBackOff = ManagedIndexUtils.shouldBackoff(action, currentActionMetaData, action.getConfigRetry())).getFirst())) {
            logger.info("Backoff for retrying. Remaining time " + String.valueOf(shouldBackOff.getSecond()));
            return;
        }
        if (managedIndexMetaData.getStepMetaData() != null && managedIndexMetaData.getStepMetaData().getStepStatus() == Step.StepStatus.STARTING) {
            Boolean isIdempotent = step != null ? Boolean.valueOf(step.isIdempotent()) : null;
            logger.info("Previous execution failed to update step status, isIdempotent=" + isIdempotent);
            if (!Boolean.TRUE.equals(isIdempotent)) {
                Map<String, String> info = Map.of("message", "Previous action was not able to update IndexMetaData.");
                ManagedIndexMetaData updatedMetadata = new ManagedIndexMetaData.Builder(managedIndexMetaData).policyRetryInfo(new PolicyRetryInfoMetaData(true, 0)).info(info).build();
                UpdateMetadataResult updated = this.updateManagedIndexMetaData(updatedMetadata, null, false);
                if (updated.metadataSaved) {
                    this.disableManagedIndexConfig(managedIndexConfig);
                    this.publishErrorNotification(policy, managedIndexMetaData);
                }
                return;
            }
        }
        if (!this.extensionStatusChecker.isEnabled(actionExtensionName = ISMActionsParser.getInstance().getCustomActionExtensionMap().get(action != null ? action.getType() : null))) {
            Map<String, CallSite> info = Map.of("message", "Failed to execute action=" + (action != null ? action.getType() : "null") + " as extension [" + actionExtensionName + "] is not enabled.");
            ManagedIndexMetaData updatedMetadata = new ManagedIndexMetaData.Builder(managedIndexMetaData).policyRetryInfo(new PolicyRetryInfoMetaData(true, 0)).info(info).build();
            UpdateMetadataResult updated = this.updateManagedIndexMetaData(updatedMetadata, null, false);
            if (updated.metadataSaved) {
                this.disableManagedIndexConfig(managedIndexConfig);
                this.publishErrorNotification(policy, managedIndexMetaData);
            }
            logger.info("ManagedIndexRunner: extensionStatusChecker is disabled");
            return;
        }
        if (action != null && !ManagedIndexUtils.isAllowed(action, this.allowList) && step != null && action.isFirstStep(step.getName()) && !"transition".equals(action.getType())) {
            Map<String, CallSite> info = Map.of("message", "Attempted to execute action=" + action.getType() + " which is not allowed.");
            ManagedIndexMetaData updatedMetadata = new ManagedIndexMetaData.Builder(managedIndexMetaData).policyRetryInfo(new PolicyRetryInfoMetaData(true, 0)).info(info).build();
            UpdateMetadataResult updated = this.updateManagedIndexMetaData(updatedMetadata, null, false);
            if (updated.metadataSaved) {
                this.disableManagedIndexConfig(managedIndexConfig);
                this.publishErrorNotification(policy, managedIndexMetaData);
            }
            return;
        }
        ManagedIndexMetaData startingManagedIndexMetaData = ManagedIndexUtils.getStartingManagedIndexMetaData(managedIndexMetaData, state, action, step);
        logger.info("ManagedIndexRunner: Updating ManagedIndexMetaData with {}", (Object)managedIndexMetaData);
        UpdateMetadataResult updateResult = this.updateManagedIndexMetaData(startingManagedIndexMetaData, null, false);
        logger.info("ManagedIndexRunner: Checking if should execute step for index={}, updateResult.metadataSaved={}, state={}, action={}, step={}, currentActionMetaData={}", (Object)managedIndexConfig.getIndex(), (Object)updateResult.metadataSaved, (Object)(state != null ? state.getName() : "null"), (Object)(action != null ? action.getType() : "null"), (Object)(step != null ? step.getName() : "null"), (Object)currentActionMetaData);
        if (updateResult.metadataSaved && state != null && action != null && step != null && currentActionMetaData != null) {
            IndexManagementSecurityContext ignored;
            logger.info("ManagedIndexRunner: About to execute step for index={}", (Object)managedIndexConfig.getIndex());
            if (this.validationServiceEnabled) {
                ignored = new IndexManagementSecurityContext(managedIndexConfig.getId(), this.settings, this.threadPool.getThreadContext(), policy.getUser());
                try {
                    ValidationResult validationResult = this.actionValidation.validate(action.getType(), stepContext.getMetadata().getIndex());
                    if (validationResult.getValidationStatus() == Validate.ValidationStatus.RE_VALIDATING) {
                        logger.warn("Validation Status is: RE_VALIDATING. The action is {}, state is {}, step is {}.", (Object)action.getType(), (Object)state.getName(), (Object)step.getName());
                        this.publishErrorNotification(policy, managedIndexMetaData);
                        return;
                    }
                    if (validationResult.getValidationStatus() == Validate.ValidationStatus.FAILED) {
                        logger.warn("Validation Status is: FAILED. The action is {}, state is {}, step is {}.", (Object)action.getType(), (Object)state.getName(), (Object)step.getName());
                        this.publishErrorNotification(policy, managedIndexMetaData);
                        this.disableManagedIndexConfig(managedIndexConfig);
                        return;
                    }
                }
                finally {
                    ignored.close();
                }
            }
            logger.info("ManagedIndexRunner: Executing step {} for index={}", (Object)step.getName(), (Object)managedIndexConfig.getIndex());
            ignored = new IndexManagementSecurityContext(managedIndexConfig.getId(), this.settings, this.threadPool.getThreadContext(), policy.getUser());
            try {
                StepContext updatedContext = stepContext.getUpdatedContext(startingManagedIndexMetaData);
                ((Step)step.preExecute(logger, updatedContext).execute().join()).postExecute(logger, this.indexManagementActionMetrics, step, startingManagedIndexMetaData);
            }
            finally {
                ignored.close();
            }
            logger.info("ManagedIndexRunner: Finished executing step {} for index={}", (Object)step.getName(), (Object)managedIndexConfig.getIndex());
            ManagedIndexMetaData executedManagedIndexMetaData = ManagedIndexUtils.getCompletedManagedIndexMetaData(startingManagedIndexMetaData, action, step);
            logger.info("ManagedIndexRunner: Got completed metadata for index={}", (Object)managedIndexConfig.getIndex());
            if (ManagedIndexUtils.isFailed(executedManagedIndexMetaData)) {
                logger.info("ManagedIndexRunner: Metadata indicates failure for index={}, publishing error notification", (Object)managedIndexConfig.getIndex());
                executedManagedIndexMetaData = this.publishErrorNotification(policy, executedManagedIndexMetaData);
            }
            if (ManagedIndexUtils.isSuccessfulDelete(executedManagedIndexMetaData)) {
                logger.info("ManagedIndexRunner: Successful delete for index={}, adding to history and returning", (Object)managedIndexConfig.getIndex());
                ManagedIndexMetaData finalExecutedManagedIndexMetaData = executedManagedIndexMetaData;
                CompletableFuture.runAsync(() -> this.ismHistory.addManagedIndexMetaDataHistory(List.of(finalExecutedManagedIndexMetaData)), this.executorService);
                return;
            }
            if (action.isFinishedSuccessfully(executedManagedIndexMetaData)) {
                logger.info("ManagedIndexRunner: Action finished successfully for index={}", (Object)managedIndexConfig.getIndex());
                if (action.deleteIndexMetadataAfterFinish()) {
                    logger.info("ManagedIndexRunner: Deleting metadata for index={}, returning", (Object)managedIndexConfig.getIndex());
                    this.deleteFromManagedIndex(managedIndexConfig, action.getType());
                    return;
                }
            }
            logger.info("ManagedIndexRunner: About to update metadata after step execution for index={}", (Object)managedIndexConfig.getIndex());
            if (!this.updateManagedIndexMetaData((ManagedIndexMetaData)executedManagedIndexMetaData, (UpdateMetadataResult)updateResult, (boolean)false).metadataSaved) {
                logger.error("Failed to update ManagedIndexMetaData after executing the Step: " + step.getName());
            }
            logger.info("ManagedIndexRunner: Finished updating metadata after step execution for index={}", (Object)managedIndexConfig.getIndex());
            if (ManagedIndexUtils.hasDifferentJobInterval(managedIndexConfig, this.jobInterval)) {
                logger.info("ManagedIndexRunner: Job interval changed for index={}, updating", (Object)managedIndexConfig.getIndex());
                this.updateJobInterval(managedIndexConfig, this.jobInterval);
            }
        } else {
            logger.info("ManagedIndexRunner: Skipping step execution for index={} because condition not met", (Object)managedIndexConfig.getIndex());
        }
        logger.info("ManagedIndexRunner: runManagedIndexConfig completed for index={}", (Object)managedIndexConfig.getIndex());
    }

    private void initManagedIndex(ManagedIndexConfig managedIndexConfig) {
        logger.info("initManagedIndex called for index={}", (Object)managedIndexConfig.getIndex());
        Policy policy = managedIndexConfig.getPolicy();
        ManagedIndexMetaData metadata = this.getInitializedManagedIndexMetaData(managedIndexConfig, policy, policy.getId());
        logger.info("Created initial metadata for index={}, policyID={}", (Object)managedIndexConfig.getIndex(), (Object)metadata.getPolicyID());
        if (managedIndexConfig.getChangePolicy() != null) {
            boolean saved;
            String policyID = managedIndexConfig.getChangePolicy().getPolicyID();
            Policy newPolicy = this.getPolicy(policyID);
            if (newPolicy != null && !(saved = this.savePolicyToManagedIndexConfig(managedIndexConfig, newPolicy))) {
                logger.error("Failed to save policy to ManagedIndexConfig(" + managedIndexConfig.getIndex() + ")");
                return;
            }
            metadata = this.getInitializedManagedIndexMetaData(managedIndexConfig, newPolicy, policyID);
        }
        logger.info("Calling updateManagedIndexMetaData with create=true for index={}", (Object)managedIndexConfig.getIndex());
        UpdateMetadataResult result = this.updateManagedIndexMetaData(metadata, null, true);
        logger.info("updateManagedIndexMetaData returned for index={}, metadataSaved={}", (Object)managedIndexConfig.getIndex(), (Object)result.metadataSaved);
    }

    private Policy getPolicy(String policyID) {
        try {
            GetRequest getRequest = new GetRequest(".opendistro-ism-config", policyID);
            GetResponse getResponse = (GetResponse)this.client.get(getRequest).actionGet();
            if (!getResponse.isExists() || getResponse.isSourceEmpty()) {
                return null;
            }
            XContentParser xcp = XContentHelper.createParser((NamedXContentRegistry)this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)getResponse.getSourceAsBytesRef(), (MediaType)MediaTypeRegistry.JSON);
            return ParseUtils.parseWithType(xcp, getResponse.getId(), getResponse.getSeqNo(), getResponse.getPrimaryTerm(), Policy::parse);
        }
        catch (Exception e) {
            logger.error("Failed to get policy: " + policyID, (Throwable)e);
            return null;
        }
    }

    private void disableManagedIndexConfig(ManagedIndexConfig managedIndexConfig) {
        try {
            ManagedIndexConfig updated = new ManagedIndexConfig.Builder(managedIndexConfig).enabled(false).jobEnabledTime(null).build();
            UpdateRequest updateRequest = ManagedIndexUtils.updateDisableManagedIndexRequest(updated.getIndexUuid());
            UpdateResponse response = (UpdateResponse)this.client.update(updateRequest).actionGet();
            if (response.status() != RestStatus.OK) {
                logger.error("Failed to disable ManagedIndexConfig(" + managedIndexConfig.getIndex() + ") Error: " + String.valueOf(response.status()));
            }
        }
        catch (Exception e) {
            logger.error("Failed to disable ManagedIndexConfig(" + managedIndexConfig.getIndex() + ")", (Throwable)e);
        }
    }

    private boolean savePolicyToManagedIndexConfig(ManagedIndexConfig managedIndexConfig, Policy policy) {
        ManagedIndexConfig updated = new ManagedIndexConfig.Builder(managedIndexConfig).policyID(policy.getId()).policy(policy).policySeqNo(policy.getSeqNo()).policyPrimaryTerm(policy.getPrimaryTerm()).changePolicy(null).build();
        IndexRequest indexRequest = ManagedIndexUtils.managedIndexConfigIndexRequest(updated);
        try {
            return RetryUtils.retry(logger, this.savePolicyRetryPolicy, () -> {
                IndexResponse response = (IndexResponse)this.client.index(indexRequest).actionGet();
                return response.status() == RestStatus.OK;
            });
        }
        catch (Exception e) {
            logger.error("Failed to save policy(" + policy.getId() + ") to ManagedIndexConfig(" + managedIndexConfig.getIndex() + ")", (Throwable)e);
            return false;
        }
    }

    private void updateJobInterval(ManagedIndexConfig managedIndexConfig, int jobInterval) {
        try {
            Instant startTime = this.getIntervalStartTime(managedIndexConfig);
            ManagedIndexConfig updated = new ManagedIndexConfig.Builder(managedIndexConfig).jobSchedule((Schedule)new IntervalSchedule(startTime, jobInterval, ChronoUnit.MINUTES)).build();
            IndexRequest indexRequest = ManagedIndexUtils.managedIndexConfigIndexRequest(updated);
            IndexResponse response = (IndexResponse)this.client.index(indexRequest).actionGet();
            if (response.status() != RestStatus.OK) {
                logger.error("Failed to update ManagedIndexConfig(" + managedIndexConfig.getIndex() + ") job interval");
            }
        }
        catch (Exception e) {
            logger.error("Failed to update ManagedIndexConfig(" + managedIndexConfig.getIndex() + ") job interval", (Throwable)e);
        }
    }

    private ManagedIndexMetaData getInitializedManagedIndexMetaData(ManagedIndexConfig managedIndexConfig, Policy policy, String policyID) {
        logger.info("getInitializedManagedIndexMetaData called for index={}, indexUuid={}", (Object)managedIndexConfig.getIndex(), (Object)managedIndexConfig.getIndexUuid());
        Long indexCreationDate = this.getIndexCreationDate(managedIndexConfig);
        if (policy == null) {
            return new ManagedIndexMetaData(managedIndexConfig.getIndex(), managedIndexConfig.getIndexUuid(), policyID, null, null, Boolean.valueOf(false), Boolean.valueOf(false), indexCreationDate, null, null, null, null, new PolicyRetryInfoMetaData(true, 0), Map.of("message", "Fail to load policy: " + policyID));
        }
        String state = managedIndexConfig.getChangePolicy() != null ? managedIndexConfig.getChangePolicy().getState() : policy.getDefaultState();
        ManagedIndexMetaData metadata = new ManagedIndexMetaData(managedIndexConfig.getIndex(), managedIndexConfig.getIndexUuid(), policy.getId(), Long.valueOf(policy.getSeqNo()), Long.valueOf(policy.getPrimaryTerm()), Boolean.valueOf(false), Boolean.valueOf(false), indexCreationDate, null, new StateMetaData(state, Instant.now().toEpochMilli()), null, null, new PolicyRetryInfoMetaData(false, 0), Map.of("message", "Successfully initialized policy: " + policy.getId()));
        logger.info("Created metadata for index={}, metadata.indexUuid={}", (Object)managedIndexConfig.getIndex(), (Object)metadata.getIndexUuid());
        return metadata;
    }

    private UpdateMetadataResult updateManagedIndexMetaData(ManagedIndexMetaData managedIndexMetaData, UpdateMetadataResult lastUpdateResult, boolean create) {
        UpdateMetadataResult result = new UpdateMetadataResult();
        logger.info("updateManagedIndexMetaData called for index={}, create={}", (Object)managedIndexMetaData.getIndex(), (Object)create);
        if (!this.imIndices.attemptUpdateConfigIndexMapping().join().booleanValue()) {
            logger.error("Failed to update config index mapping for index={}", (Object)managedIndexMetaData.getIndex());
            return result;
        }
        ManagedIndexMetaData metadata = lastUpdateResult != null ? new ManagedIndexMetaData.Builder(managedIndexMetaData).seqNo(lastUpdateResult.seqNo).primaryTerm(lastUpdateResult.primaryTerm).build() : managedIndexMetaData;
        IndexRequest indexRequest = ManagedIndexUtils.managedIndexMetadataIndexRequest(metadata, true, create);
        logger.info("Created index request for metadata, id={}, routing={}", (Object)indexRequest.id(), (Object)indexRequest.routing());
        try {
            RetryUtils.retry(logger, this.updateMetaDataRetryPolicy, () -> {
                boolean metadataSaved;
                logger.info("Attempting to index metadata for index={}", (Object)managedIndexMetaData.getIndex());
                IndexResponse response = (IndexResponse)this.client.index(indexRequest).actionGet();
                logger.info("Index metadata response: status={}, id={}, seqNo={}", (Object)response.status(), (Object)response.getId(), (Object)response.getSeqNo());
                result.metadataSaved = metadataSaved = response.status() == RestStatus.OK || response.status() == RestStatus.CREATED;
                result.seqNo = response.getSeqNo();
                result.primaryTerm = response.getPrimaryTerm();
                return null;
            });
            logger.info("Successfully saved metadata for index={}, metadataSaved={}", (Object)managedIndexMetaData.getIndex(), (Object)result.metadataSaved);
            CompletableFuture.runAsync(() -> this.ismHistory.addManagedIndexMetaDataHistory(List.of(metadata)), this.executorService);
        }
        catch (Exception e) {
            logger.error("Failed to save ManagedIndexMetaData for [index=" + managedIndexMetaData.getIndex() + "]", (Throwable)e);
        }
        return result;
    }

    private void initChangePolicy(ManagedIndexConfig managedIndexConfig, ManagedIndexMetaData managedIndexMetaData, Action actionToExecute) {
        ManagedIndexMetaData updatedManagedIndexMetaData;
        ChangePolicy changePolicy = managedIndexConfig.getChangePolicy();
        if (changePolicy == null) {
            logger.debug("initChangePolicy was called with a null ChangePolicy, ManagedIndexConfig: {}", (Object)managedIndexConfig);
            return;
        }
        Policy policy = this.getPolicy(changePolicy.getPolicyID());
        if (policy == null) {
            updatedManagedIndexMetaData = new ManagedIndexMetaData.Builder(managedIndexMetaData).info(Map.of("message", "Failed to load change policy: " + changePolicy.getPolicyID())).policyRetryInfo(new PolicyRetryInfoMetaData(true, 0)).build();
        } else {
            ActionMetaData actionMetaData = managedIndexMetaData.getActionMetaData();
            if (actionToExecute != null && "transition".equals(actionToExecute.getType())) {
                actionMetaData = new ActionMetaData("transition", Long.valueOf(Instant.now().toEpochMilli()), -1, false, 0, Long.valueOf(0L), null);
            }
            updatedManagedIndexMetaData = new ManagedIndexMetaData.Builder(managedIndexMetaData).info(Map.of("message", "Attempting to change policy to " + policy.getId())).transitionTo(changePolicy.getState()).actionMetaData(actionMetaData).stepMetaData(null).policyCompleted(Boolean.valueOf(false)).policySeqNo(Long.valueOf(policy.getSeqNo())).policyPrimaryTerm(Long.valueOf(policy.getPrimaryTerm())).policyID(policy.getId()).build();
        }
        if (changePolicy.isSafe() && policy != null && !ManagedIndexUtils.isSafeToChange(managedIndexConfig.getPolicy(), managedIndexMetaData.getStateMetaData() != null ? managedIndexMetaData.getStateMetaData().getName() : null, policy, changePolicy)) {
            ChangePolicy updatedChangePolicy = new ChangePolicy(changePolicy.getPolicyID(), changePolicy.getState(), changePolicy.getInclude(), false, changePolicy.getUser());
            this.updateManagedIndexConfig(new ManagedIndexConfig.Builder(managedIndexConfig).changePolicy(updatedChangePolicy).build());
            return;
        }
        UpdateMetadataResult updated = this.updateManagedIndexMetaData(updatedManagedIndexMetaData, null, false);
        if (!updated.metadataSaved || policy == null) {
            return;
        }
        Policy updatedPolicy = new Policy(policy.getId(), policy.getSeqNo(), policy.getPrimaryTerm(), policy.getDescription(), policy.getSchemaVersion(), policy.getLastUpdatedTime(), policy.getErrorNotification(), policy.getDefaultState(), policy.getStates(), policy.getISMTemplate(), changePolicy.getUser());
        this.savePolicyToManagedIndexConfig(managedIndexConfig, updatedPolicy);
    }

    private void updateManagedIndexConfig(ManagedIndexConfig updatedManagedIndexConfig) {
        try {
            IndexRequest indexRequest = ManagedIndexUtils.managedIndexConfigIndexRequest(updatedManagedIndexConfig);
            IndexResponse response = (IndexResponse)this.client.index(indexRequest).actionGet();
            if (response.status() != RestStatus.OK) {
                logger.error("Failed to update ManagedIndexConfig(" + updatedManagedIndexConfig.getIndex() + ")");
            }
        }
        catch (Exception e) {
            logger.error("Failed to update ManagedIndexConfig(" + updatedManagedIndexConfig.getIndex() + ")", (Throwable)e);
        }
    }

    private ManagedIndexMetaData publishErrorNotification(Policy policy, ManagedIndexMetaData metadata) {
        try {
            ErrorNotification errorNotification = policy.getErrorNotification();
            if (errorNotification != null) {
                RetryUtils.retry(logger, this.errorNotificationRetryPolicy, () -> {
                    String compiledMessage = this.compileTemplate(errorNotification.getMessageTemplate(), metadata);
                    if (errorNotification.getDestination() != null) {
                        LegacyBaseMessage message = errorNotification.getDestination().buildLegacyBaseMessage(null, compiledMessage);
                        NotificationUtils.publishLegacyNotification(message, this.client).join();
                    }
                    if (errorNotification.getChannel() != null) {
                        NotificationUtils.sendNotification(errorNotification.getChannel(), this.client, "Index Management-ISM-Error Notification", metadata, compiledMessage, policy.getUser()).join();
                    }
                    return null;
                });
                String message = "Successfully published error notification [index = " + metadata.getIndex() + "]";
                logger.info(message);
                HashMap<String, CallSite> mutableInfo = new HashMap<String, CallSite>(metadata.getInfo() != null ? metadata.getInfo() : Map.of());
                mutableInfo.put("error_notification", (CallSite)((Object)message));
                return new ManagedIndexMetaData.Builder(metadata).info(mutableInfo).build();
            }
            return metadata;
        }
        catch (Exception e) {
            logger.error("Failed to publish error notification", (Throwable)e);
            String errorMessage = e.getMessage() != null ? e.getMessage() : "Failed to publish error notification";
            HashMap<String, String> mutableInfo = new HashMap<String, String>(metadata.getInfo() != null ? metadata.getInfo() : Map.of());
            mutableInfo.put("error_notification", errorMessage);
            return new ManagedIndexMetaData.Builder(metadata).info(mutableInfo).build();
        }
    }

    private String compileTemplate(Script template, ManagedIndexMetaData managedIndexMetaData) {
        try {
            HashMap<String, Map<String, Object>> params = new HashMap<String, Map<String, Object>>(template.getParams());
            params.put("ctx", LuceniaExtensions.convertToMap((ToXContent)managedIndexMetaData));
            TemplateScript.Factory factory = (TemplateScript.Factory)this.scriptService.compile(template, TemplateScript.CONTEXT);
            return factory.newInstance(params).execute();
        }
        catch (Exception e) {
            String message = "There was an error compiling mustache template";
            logger.error(message, (Throwable)e);
            return e.getMessage() != null ? e.getMessage() : message;
        }
    }

    private boolean clusterIsRed() {
        return new ClusterStateHealth(this.clusterService.state()).getStatus() == ClusterHealthStatus.RED;
    }

    private IndexMetadata getIndexMetadata(String index) {
        try {
            ClusterStateRequest request = ((ClusterStateRequest)new ClusterStateRequest().clear().indices(new String[]{index}).metadata(true).local(false)).indicesOptions(IndicesOptions.strictExpand());
            ClusterStateResponse response = (ClusterStateResponse)this.client.admin().cluster().state(request).actionGet();
            return response.getState().metadata().index(index);
        }
        catch (Exception e) {
            logger.error("Failed to get IndexMetaData from cluster manager cluster state for index=" + index, (Throwable)e);
            return null;
        }
    }

    private Instant getIntervalStartTime(ManagedIndexConfig managedIndexConfig) {
        return Instant.now();
    }

    private Long getIndexCreationDate(ManagedIndexConfig managedIndexConfig) {
        try {
            Map<String, Map<String, ISMIndexMetadata>> multiTypeMetadata = this.indexMetadataProvider.getMultiTypeISMIndexMetadata(List.of(managedIndexConfig.getIndex())).join();
            return multiTypeMetadata.values().stream().map(map -> (ISMIndexMetadata)map.get(managedIndexConfig.getIndex())).filter(metadata -> metadata != null && metadata.getIndexUuid().equals(managedIndexConfig.getIndexUuid())).map(ISMIndexMetadata::getIndexCreationDate).findFirst().orElse(null);
        }
        catch (Exception e) {
            logger.error("Failed to get the index creation date", (Throwable)e);
            return null;
        }
    }

    private void deleteFromManagedIndex(ManagedIndexConfig managedIndexConfig, String actionType) {
        try {
            BulkRequest bulkRequest = new BulkRequest().add(ManagedIndexUtils.deleteManagedIndexRequest(managedIndexConfig.getIndexUuid())).add(ManagedIndexUtils.deleteManagedIndexMetadataRequest(managedIndexConfig.getIndexUuid()));
            BulkResponse bulkResponse = (BulkResponse)this.client.bulk(bulkRequest).actionGet();
            for (BulkItemResponse bulkItemResponse : bulkResponse) {
                if (!bulkItemResponse.isFailed()) continue;
                logger.warn("Failed to delete managed index job/metadata [id=" + bulkItemResponse.getId() + "] for " + managedIndexConfig.getIndex() + " after a successful " + actionType + " [result=" + bulkItemResponse.getFailureMessage() + "]");
            }
        }
        catch (Exception e) {
            logger.warn("Failed to delete managed index job for " + managedIndexConfig.getIndex() + " after a successful " + actionType, (Throwable)e);
        }
    }

    public static class UpdateMetadataResult {
        public boolean metadataSaved = false;
        public long seqNo = -2L;
        public long primaryTerm = 0L;
    }

    public static class Pair<F, S> {
        private final F first;
        private final S second;

        public Pair(F first, S second) {
            this.first = first;
            this.second = second;
        }

        public F getFirst() {
            return this.first;
        }

        public S getSecond() {
            return this.second;
        }
    }
}

